/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a Transport Layer Security (TLS) validation context trust.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayTlsValidationContextTrust implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayTlsValidationContextTrust.Builder, VirtualGatewayTlsValidationContextTrust> {
    private static final SdkField<VirtualGatewayTlsValidationContextAcmTrust> ACM_FIELD = SdkField
            .<VirtualGatewayTlsValidationContextAcmTrust> builder(MarshallingType.SDK_POJO).memberName("acm")
            .getter(getter(VirtualGatewayTlsValidationContextTrust::acm)).setter(setter(Builder::acm))
            .constructor(VirtualGatewayTlsValidationContextAcmTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acm").build()).build();

    private static final SdkField<VirtualGatewayTlsValidationContextFileTrust> FILE_FIELD = SdkField
            .<VirtualGatewayTlsValidationContextFileTrust> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(VirtualGatewayTlsValidationContextTrust::file)).setter(setter(Builder::file))
            .constructor(VirtualGatewayTlsValidationContextFileTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<VirtualGatewayTlsValidationContextSdsTrust> SDS_FIELD = SdkField
            .<VirtualGatewayTlsValidationContextSdsTrust> builder(MarshallingType.SDK_POJO).memberName("sds")
            .getter(getter(VirtualGatewayTlsValidationContextTrust::sds)).setter(setter(Builder::sds))
            .constructor(VirtualGatewayTlsValidationContextSdsTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_FIELD, FILE_FIELD,
            SDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayTlsValidationContextAcmTrust acm;

    private final VirtualGatewayTlsValidationContextFileTrust file;

    private final VirtualGatewayTlsValidationContextSdsTrust sds;

    private final Type type;

    private VirtualGatewayTlsValidationContextTrust(BuilderImpl builder) {
        this.acm = builder.acm;
        this.file = builder.file;
        this.sds = builder.sds;
        this.type = builder.type;
    }

    /**
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     * Certificate Manager certificate.
     * </p>
     * 
     * @return A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     *         Certificate Manager certificate.
     */
    public final VirtualGatewayTlsValidationContextAcmTrust acm() {
        return acm;
    }

    /**
     * <p>
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * </p>
     * 
     * @return An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     */
    public final VirtualGatewayTlsValidationContextFileTrust file() {
        return file;
    }

    /**
     * <p>
     * A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret Discovery
     * Service validation context trust.
     * </p>
     * 
     * @return A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret
     *         Discovery Service validation context trust.
     */
    public final VirtualGatewayTlsValidationContextSdsTrust sds() {
        return sds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acm());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(sds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayTlsValidationContextTrust)) {
            return false;
        }
        VirtualGatewayTlsValidationContextTrust other = (VirtualGatewayTlsValidationContextTrust) obj;
        return Objects.equals(acm(), other.acm()) && Objects.equals(file(), other.file()) && Objects.equals(sds(), other.sds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayTlsValidationContextTrust").add("Acm", acm()).add("File", file())
                .add("Sds", sds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acm":
            return Optional.ofNullable(clazz.cast(acm()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "sds":
            return Optional.ofNullable(clazz.cast(sds()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #acm()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     * Certificate Manager certificate.
     * </p>
     * 
     * @param acm
     *        A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     *        Certificate Manager certificate.
     */
    public static VirtualGatewayTlsValidationContextTrust fromAcm(VirtualGatewayTlsValidationContextAcmTrust acm) {
        return builder().acm(acm).build();
    }

    /**
     * Create an instance of this class with {@link #acm()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     * Certificate Manager certificate.
     * </p>
     * 
     * @param acm
     *        A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
     *        Certificate Manager certificate.
     */
    public static VirtualGatewayTlsValidationContextTrust fromAcm(Consumer<VirtualGatewayTlsValidationContextAcmTrust.Builder> acm) {
        VirtualGatewayTlsValidationContextAcmTrust.Builder builder = VirtualGatewayTlsValidationContextAcmTrust.builder();
        acm.accept(builder);
        return fromAcm(builder.build());
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * </p>
     * 
     * @param file
     *        An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     */
    public static VirtualGatewayTlsValidationContextTrust fromFile(VirtualGatewayTlsValidationContextFileTrust file) {
        return builder().file(file).build();
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * </p>
     * 
     * @param file
     *        An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     */
    public static VirtualGatewayTlsValidationContextTrust fromFile(
            Consumer<VirtualGatewayTlsValidationContextFileTrust.Builder> file) {
        VirtualGatewayTlsValidationContextFileTrust.Builder builder = VirtualGatewayTlsValidationContextFileTrust.builder();
        file.accept(builder);
        return fromFile(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sds()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret Discovery
     * Service validation context trust.
     * </p>
     * 
     * @param sds
     *        A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret
     *        Discovery Service validation context trust.
     */
    public static VirtualGatewayTlsValidationContextTrust fromSds(VirtualGatewayTlsValidationContextSdsTrust sds) {
        return builder().sds(sds).build();
    }

    /**
     * Create an instance of this class with {@link #sds()} initialized to the given value.
     *
     * <p>
     * A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret Discovery
     * Service validation context trust.
     * </p>
     * 
     * @param sds
     *        A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret
     *        Discovery Service validation context trust.
     */
    public static VirtualGatewayTlsValidationContextTrust fromSds(Consumer<VirtualGatewayTlsValidationContextSdsTrust.Builder> sds) {
        VirtualGatewayTlsValidationContextSdsTrust.Builder builder = VirtualGatewayTlsValidationContextSdsTrust.builder();
        sds.accept(builder);
        return fromSds(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("acm", ACM_FIELD);
        map.put("file", FILE_FIELD);
        map.put("sds", SDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayTlsValidationContextTrust, T> g) {
        return obj -> g.apply((VirtualGatewayTlsValidationContextTrust) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayTlsValidationContextTrust> {
        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
         * Certificate Manager certificate.
         * </p>
         * 
         * @param acm
         *        A reference to an object that represents a Transport Layer Security (TLS) validation context trust for
         *        an Certificate Manager certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acm(VirtualGatewayTlsValidationContextAcmTrust acm);

        /**
         * <p>
         * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an
         * Certificate Manager certificate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VirtualGatewayTlsValidationContextAcmTrust.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayTlsValidationContextAcmTrust#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VirtualGatewayTlsValidationContextAcmTrust.Builder#build()} is
         * called immediately and its result is passed to {@link #acm(VirtualGatewayTlsValidationContextAcmTrust)}.
         * 
         * @param acm
         *        a consumer that will call methods on {@link VirtualGatewayTlsValidationContextAcmTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acm(VirtualGatewayTlsValidationContextAcmTrust)
         */
        default Builder acm(Consumer<VirtualGatewayTlsValidationContextAcmTrust.Builder> acm) {
            return acm(VirtualGatewayTlsValidationContextAcmTrust.builder().applyMutation(acm).build());
        }

        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * </p>
         * 
         * @param file
         *        An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(VirtualGatewayTlsValidationContextFileTrust file);

        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VirtualGatewayTlsValidationContextFileTrust.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayTlsValidationContextFileTrust#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VirtualGatewayTlsValidationContextFileTrust.Builder#build()} is
         * called immediately and its result is passed to {@link #file(VirtualGatewayTlsValidationContextFileTrust)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link VirtualGatewayTlsValidationContextFileTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(VirtualGatewayTlsValidationContextFileTrust)
         */
        default Builder file(Consumer<VirtualGatewayTlsValidationContextFileTrust.Builder> file) {
            return file(VirtualGatewayTlsValidationContextFileTrust.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret Discovery
         * Service validation context trust.
         * </p>
         * 
         * @param sds
         *        A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret
         *        Discovery Service validation context trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sds(VirtualGatewayTlsValidationContextSdsTrust sds);

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret Discovery
         * Service validation context trust.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VirtualGatewayTlsValidationContextSdsTrust.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayTlsValidationContextSdsTrust#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VirtualGatewayTlsValidationContextSdsTrust.Builder#build()} is
         * called immediately and its result is passed to {@link #sds(VirtualGatewayTlsValidationContextSdsTrust)}.
         * 
         * @param sds
         *        a consumer that will call methods on {@link VirtualGatewayTlsValidationContextSdsTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sds(VirtualGatewayTlsValidationContextSdsTrust)
         */
        default Builder sds(Consumer<VirtualGatewayTlsValidationContextSdsTrust.Builder> sds) {
            return sds(VirtualGatewayTlsValidationContextSdsTrust.builder().applyMutation(sds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayTlsValidationContextAcmTrust acm;

        private VirtualGatewayTlsValidationContextFileTrust file;

        private VirtualGatewayTlsValidationContextSdsTrust sds;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayTlsValidationContextTrust model) {
            acm(model.acm);
            file(model.file);
            sds(model.sds);
        }

        public final VirtualGatewayTlsValidationContextAcmTrust.Builder getAcm() {
            return acm != null ? acm.toBuilder() : null;
        }

        public final void setAcm(VirtualGatewayTlsValidationContextAcmTrust.BuilderImpl acm) {
            Object oldValue = this.acm;
            this.acm = acm != null ? acm.build() : null;
            handleUnionValueChange(Type.ACM, oldValue, this.acm);
        }

        @Override
        public final Builder acm(VirtualGatewayTlsValidationContextAcmTrust acm) {
            Object oldValue = this.acm;
            this.acm = acm;
            handleUnionValueChange(Type.ACM, oldValue, this.acm);
            return this;
        }

        public final VirtualGatewayTlsValidationContextFileTrust.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        public final void setFile(VirtualGatewayTlsValidationContextFileTrust.BuilderImpl file) {
            Object oldValue = this.file;
            this.file = file != null ? file.build() : null;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(VirtualGatewayTlsValidationContextFileTrust file) {
            Object oldValue = this.file;
            this.file = file;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final VirtualGatewayTlsValidationContextSdsTrust.Builder getSds() {
            return sds != null ? sds.toBuilder() : null;
        }

        public final void setSds(VirtualGatewayTlsValidationContextSdsTrust.BuilderImpl sds) {
            Object oldValue = this.sds;
            this.sds = sds != null ? sds.build() : null;
            handleUnionValueChange(Type.SDS, oldValue, this.sds);
        }

        @Override
        public final Builder sds(VirtualGatewayTlsValidationContextSdsTrust sds) {
            Object oldValue = this.sds;
            this.sds = sds;
            handleUnionValueChange(Type.SDS, oldValue, this.sds);
            return this;
        }

        @Override
        public VirtualGatewayTlsValidationContextTrust build() {
            return new VirtualGatewayTlsValidationContextTrust(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see VirtualGatewayTlsValidationContextTrust#type()
     */
    public enum Type {
        ACM,

        FILE,

        SDS,

        UNKNOWN_TO_SDK_VERSION
    }
}
