/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestCaseRequest extends AppTestRequest implements
        ToCopyableBuilder<GetTestCaseRequest.Builder, GetTestCaseRequest> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(GetTestCaseRequest::testCaseId)).setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testCaseId").build()).build();

    private static final SdkField<Integer> TEST_CASE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testCaseVersion").getter(getter(GetTestCaseRequest::testCaseVersion))
            .setter(setter(Builder::testCaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testCaseVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD,
            TEST_CASE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testCaseId;

    private final Integer testCaseVersion;

    private GetTestCaseRequest(BuilderImpl builder) {
        super(builder);
        this.testCaseId = builder.testCaseId;
        this.testCaseVersion = builder.testCaseVersion;
    }

    /**
     * <p>
     * The request test ID of the test case.
     * </p>
     * 
     * @return The request test ID of the test case.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    /**
     * <p>
     * The test case version of the test case.
     * </p>
     * 
     * @return The test case version of the test case.
     */
    public final Integer testCaseVersion() {
        return testCaseVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestCaseRequest)) {
            return false;
        }
        GetTestCaseRequest other = (GetTestCaseRequest) obj;
        return Objects.equals(testCaseId(), other.testCaseId()) && Objects.equals(testCaseVersion(), other.testCaseVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTestCaseRequest").add("TestCaseId", testCaseId()).add("TestCaseVersion", testCaseVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        case "testCaseVersion":
            return Optional.ofNullable(clazz.cast(testCaseVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("testCaseVersion", TEST_CASE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTestCaseRequest, T> g) {
        return obj -> g.apply((GetTestCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTestCaseRequest> {
        /**
         * <p>
         * The request test ID of the test case.
         * </p>
         * 
         * @param testCaseId
         *        The request test ID of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        /**
         * <p>
         * The test case version of the test case.
         * </p>
         * 
         * @param testCaseVersion
         *        The test case version of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseVersion(Integer testCaseVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppTestRequest.BuilderImpl implements Builder {
        private String testCaseId;

        private Integer testCaseVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestCaseRequest model) {
            super(model);
            testCaseId(model.testCaseId);
            testCaseVersion(model.testCaseVersion);
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final Integer getTestCaseVersion() {
            return testCaseVersion;
        }

        public final void setTestCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        @Override
        public final Builder testCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTestCaseRequest build() {
            return new GetTestCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
