/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the AWS Mainframe Modernization managed action properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2ManagedActionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<M2ManagedActionProperties.Builder, M2ManagedActionProperties> {
    private static final SdkField<Boolean> FORCE_STOP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceStop").getter(getter(M2ManagedActionProperties::forceStop)).setter(setter(Builder::forceStop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceStop").build()).build();

    private static final SdkField<String> IMPORT_DATA_SET_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importDataSetLocation").getter(getter(M2ManagedActionProperties::importDataSetLocation))
            .setter(setter(Builder::importDataSetLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importDataSetLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORCE_STOP_FIELD,
            IMPORT_DATA_SET_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean forceStop;

    private final String importDataSetLocation;

    private M2ManagedActionProperties(BuilderImpl builder) {
        this.forceStop = builder.forceStop;
        this.importDataSetLocation = builder.importDataSetLocation;
    }

    /**
     * <p>
     * Force stops the AWS Mainframe Modernization managed action properties.
     * </p>
     * 
     * @return Force stops the AWS Mainframe Modernization managed action properties.
     */
    public final Boolean forceStop() {
        return forceStop;
    }

    /**
     * <p>
     * The import data set location of the AWS Mainframe Modernization managed action properties.
     * </p>
     * 
     * @return The import data set location of the AWS Mainframe Modernization managed action properties.
     */
    public final String importDataSetLocation() {
        return importDataSetLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forceStop());
        hashCode = 31 * hashCode + Objects.hashCode(importDataSetLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedActionProperties)) {
            return false;
        }
        M2ManagedActionProperties other = (M2ManagedActionProperties) obj;
        return Objects.equals(forceStop(), other.forceStop())
                && Objects.equals(importDataSetLocation(), other.importDataSetLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("M2ManagedActionProperties").add("ForceStop", forceStop())
                .add("ImportDataSetLocation", importDataSetLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "forceStop":
            return Optional.ofNullable(clazz.cast(forceStop()));
        case "importDataSetLocation":
            return Optional.ofNullable(clazz.cast(importDataSetLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("forceStop", FORCE_STOP_FIELD);
        map.put("importDataSetLocation", IMPORT_DATA_SET_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedActionProperties, T> g) {
        return obj -> g.apply((M2ManagedActionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2ManagedActionProperties> {
        /**
         * <p>
         * Force stops the AWS Mainframe Modernization managed action properties.
         * </p>
         * 
         * @param forceStop
         *        Force stops the AWS Mainframe Modernization managed action properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceStop(Boolean forceStop);

        /**
         * <p>
         * The import data set location of the AWS Mainframe Modernization managed action properties.
         * </p>
         * 
         * @param importDataSetLocation
         *        The import data set location of the AWS Mainframe Modernization managed action properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDataSetLocation(String importDataSetLocation);
    }

    static final class BuilderImpl implements Builder {
        private Boolean forceStop;

        private String importDataSetLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedActionProperties model) {
            forceStop(model.forceStop);
            importDataSetLocation(model.importDataSetLocation);
        }

        public final Boolean getForceStop() {
            return forceStop;
        }

        public final void setForceStop(Boolean forceStop) {
            this.forceStop = forceStop;
        }

        @Override
        public final Builder forceStop(Boolean forceStop) {
            this.forceStop = forceStop;
            return this;
        }

        public final String getImportDataSetLocation() {
            return importDataSetLocation;
        }

        public final void setImportDataSetLocation(String importDataSetLocation) {
            this.importDataSetLocation = importDataSetLocation;
        }

        @Override
        public final Builder importDataSetLocation(String importDataSetLocation) {
            this.importDataSetLocation = importDataSetLocation;
            return this;
        }

        @Override
        public M2ManagedActionProperties build() {
            return new M2ManagedActionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
