/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a test run summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestRunSummary implements SdkPojo, Serializable, ToCopyableBuilder<TestRunSummary.Builder, TestRunSummary> {
    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testRunId").getter(getter(TestRunSummary::testRunId)).setter(setter(Builder::testRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunId").build()).build();

    private static final SdkField<String> TEST_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testRunArn").getter(getter(TestRunSummary::testRunArn)).setter(setter(Builder::testRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunArn").build()).build();

    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteId").getter(getter(TestRunSummary::testSuiteId)).setter(setter(Builder::testSuiteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteId").build()).build();

    private static final SdkField<Integer> TEST_SUITE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testSuiteVersion").getter(getter(TestRunSummary::testSuiteVersion))
            .setter(setter(Builder::testSuiteVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteVersion").build()).build();

    private static final SdkField<String> TEST_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testConfigurationId").getter(getter(TestRunSummary::testConfigurationId))
            .setter(setter(Builder::testConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationId").build())
            .build();

    private static final SdkField<Integer> TEST_CONFIGURATION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testConfigurationVersion").getter(getter(TestRunSummary::testConfigurationVersion))
            .setter(setter(Builder::testConfigurationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationVersion").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestRunSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(TestRunSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> RUN_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("runStartTime").getter(getter(TestRunSummary::runStartTime)).setter(setter(Builder::runStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStartTime").build()).build();

    private static final SdkField<Instant> RUN_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("runEndTime").getter(getter(TestRunSummary::runEndTime)).setter(setter(Builder::runEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RUN_ID_FIELD,
            TEST_RUN_ARN_FIELD, TEST_SUITE_ID_FIELD, TEST_SUITE_VERSION_FIELD, TEST_CONFIGURATION_ID_FIELD,
            TEST_CONFIGURATION_VERSION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, RUN_START_TIME_FIELD, RUN_END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String testRunId;

    private final String testRunArn;

    private final String testSuiteId;

    private final Integer testSuiteVersion;

    private final String testConfigurationId;

    private final Integer testConfigurationVersion;

    private final String status;

    private final String statusReason;

    private final Instant runStartTime;

    private final Instant runEndTime;

    private TestRunSummary(BuilderImpl builder) {
        this.testRunId = builder.testRunId;
        this.testRunArn = builder.testRunArn;
        this.testSuiteId = builder.testSuiteId;
        this.testSuiteVersion = builder.testSuiteVersion;
        this.testConfigurationId = builder.testConfigurationId;
        this.testConfigurationVersion = builder.testConfigurationVersion;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.runStartTime = builder.runStartTime;
        this.runEndTime = builder.runEndTime;
    }

    /**
     * <p>
     * The test run ID of the test run summary.
     * </p>
     * 
     * @return The test run ID of the test run summary.
     */
    public final String testRunId() {
        return testRunId;
    }

    /**
     * <p>
     * The test run ARN of the test run summary.
     * </p>
     * 
     * @return The test run ARN of the test run summary.
     */
    public final String testRunArn() {
        return testRunArn;
    }

    /**
     * <p>
     * The test suite ID of the test run summary.
     * </p>
     * 
     * @return The test suite ID of the test run summary.
     */
    public final String testSuiteId() {
        return testSuiteId;
    }

    /**
     * <p>
     * The test suite version of the test run summary.
     * </p>
     * 
     * @return The test suite version of the test run summary.
     */
    public final Integer testSuiteVersion() {
        return testSuiteVersion;
    }

    /**
     * <p>
     * The test configuration ID of the test run summary.
     * </p>
     * 
     * @return The test configuration ID of the test run summary.
     */
    public final String testConfigurationId() {
        return testConfigurationId;
    }

    /**
     * <p>
     * The test configuration version of the test run summary.
     * </p>
     * 
     * @return The test configuration version of the test run summary.
     */
    public final Integer testConfigurationVersion() {
        return testConfigurationVersion;
    }

    /**
     * <p>
     * The status of the test run summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test run summary.
     * @see TestRunStatus
     */
    public final TestRunStatus status() {
        return TestRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the test run summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test run summary.
     * @see TestRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the test run summary.
     * </p>
     * 
     * @return The status reason of the test run summary.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The run start time of the test run summary.
     * </p>
     * 
     * @return The run start time of the test run summary.
     */
    public final Instant runStartTime() {
        return runStartTime;
    }

    /**
     * <p>
     * The run end time of the test run summary.
     * </p>
     * 
     * @return The run end time of the test run summary.
     */
    public final Instant runEndTime() {
        return runEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(testRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteVersion());
        hashCode = 31 * hashCode + Objects.hashCode(testConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(testConfigurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(runStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(runEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRunSummary)) {
            return false;
        }
        TestRunSummary other = (TestRunSummary) obj;
        return Objects.equals(testRunId(), other.testRunId()) && Objects.equals(testRunArn(), other.testRunArn())
                && Objects.equals(testSuiteId(), other.testSuiteId())
                && Objects.equals(testSuiteVersion(), other.testSuiteVersion())
                && Objects.equals(testConfigurationId(), other.testConfigurationId())
                && Objects.equals(testConfigurationVersion(), other.testConfigurationVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(runStartTime(), other.runStartTime())
                && Objects.equals(runEndTime(), other.runEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestRunSummary").add("TestRunId", testRunId()).add("TestRunArn", testRunArn())
                .add("TestSuiteId", testSuiteId()).add("TestSuiteVersion", testSuiteVersion())
                .add("TestConfigurationId", testConfigurationId()).add("TestConfigurationVersion", testConfigurationVersion())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("RunStartTime", runStartTime())
                .add("RunEndTime", runEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testRunId":
            return Optional.ofNullable(clazz.cast(testRunId()));
        case "testRunArn":
            return Optional.ofNullable(clazz.cast(testRunArn()));
        case "testSuiteId":
            return Optional.ofNullable(clazz.cast(testSuiteId()));
        case "testSuiteVersion":
            return Optional.ofNullable(clazz.cast(testSuiteVersion()));
        case "testConfigurationId":
            return Optional.ofNullable(clazz.cast(testConfigurationId()));
        case "testConfigurationVersion":
            return Optional.ofNullable(clazz.cast(testConfigurationVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "runStartTime":
            return Optional.ofNullable(clazz.cast(runStartTime()));
        case "runEndTime":
            return Optional.ofNullable(clazz.cast(runEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testRunId", TEST_RUN_ID_FIELD);
        map.put("testRunArn", TEST_RUN_ARN_FIELD);
        map.put("testSuiteId", TEST_SUITE_ID_FIELD);
        map.put("testSuiteVersion", TEST_SUITE_VERSION_FIELD);
        map.put("testConfigurationId", TEST_CONFIGURATION_ID_FIELD);
        map.put("testConfigurationVersion", TEST_CONFIGURATION_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("runStartTime", RUN_START_TIME_FIELD);
        map.put("runEndTime", RUN_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestRunSummary, T> g) {
        return obj -> g.apply((TestRunSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestRunSummary> {
        /**
         * <p>
         * The test run ID of the test run summary.
         * </p>
         * 
         * @param testRunId
         *        The test run ID of the test run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunId(String testRunId);

        /**
         * <p>
         * The test run ARN of the test run summary.
         * </p>
         * 
         * @param testRunArn
         *        The test run ARN of the test run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunArn(String testRunArn);

        /**
         * <p>
         * The test suite ID of the test run summary.
         * </p>
         * 
         * @param testSuiteId
         *        The test suite ID of the test run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteId(String testSuiteId);

        /**
         * <p>
         * The test suite version of the test run summary.
         * </p>
         * 
         * @param testSuiteVersion
         *        The test suite version of the test run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteVersion(Integer testSuiteVersion);

        /**
         * <p>
         * The test configuration ID of the test run summary.
         * </p>
         * 
         * @param testConfigurationId
         *        The test configuration ID of the test run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigurationId(String testConfigurationId);

        /**
         * <p>
         * The test configuration version of the test run summary.
         * </p>
         * 
         * @param testConfigurationVersion
         *        The test configuration version of the test run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigurationVersion(Integer testConfigurationVersion);

        /**
         * <p>
         * The status of the test run summary.
         * </p>
         * 
         * @param status
         *        The status of the test run summary.
         * @see TestRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test run summary.
         * </p>
         * 
         * @param status
         *        The status of the test run summary.
         * @see TestRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestRunStatus
         */
        Builder status(TestRunStatus status);

        /**
         * <p>
         * The status reason of the test run summary.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the test run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The run start time of the test run summary.
         * </p>
         * 
         * @param runStartTime
         *        The run start time of the test run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runStartTime(Instant runStartTime);

        /**
         * <p>
         * The run end time of the test run summary.
         * </p>
         * 
         * @param runEndTime
         *        The run end time of the test run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runEndTime(Instant runEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String testRunId;

        private String testRunArn;

        private String testSuiteId;

        private Integer testSuiteVersion;

        private String testConfigurationId;

        private Integer testConfigurationVersion;

        private String status;

        private String statusReason;

        private Instant runStartTime;

        private Instant runEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRunSummary model) {
            testRunId(model.testRunId);
            testRunArn(model.testRunArn);
            testSuiteId(model.testSuiteId);
            testSuiteVersion(model.testSuiteVersion);
            testConfigurationId(model.testConfigurationId);
            testConfigurationVersion(model.testConfigurationVersion);
            status(model.status);
            statusReason(model.statusReason);
            runStartTime(model.runStartTime);
            runEndTime(model.runEndTime);
        }

        public final String getTestRunId() {
            return testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getTestRunArn() {
            return testRunArn;
        }

        public final void setTestRunArn(String testRunArn) {
            this.testRunArn = testRunArn;
        }

        @Override
        public final Builder testRunArn(String testRunArn) {
            this.testRunArn = testRunArn;
            return this;
        }

        public final String getTestSuiteId() {
            return testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final Integer getTestSuiteVersion() {
            return testSuiteVersion;
        }

        public final void setTestSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
        }

        @Override
        public final Builder testSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
            return this;
        }

        public final String getTestConfigurationId() {
            return testConfigurationId;
        }

        public final void setTestConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
        }

        @Override
        public final Builder testConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
            return this;
        }

        public final Integer getTestConfigurationVersion() {
            return testConfigurationVersion;
        }

        public final void setTestConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
        }

        @Override
        public final Builder testConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getRunStartTime() {
            return runStartTime;
        }

        public final void setRunStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
        }

        @Override
        public final Builder runStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
            return this;
        }

        public final Instant getRunEndTime() {
            return runEndTime;
        }

        public final void setRunEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
        }

        @Override
        public final Builder runEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
            return this;
        }

        @Override
        public TestRunSummary build() {
            return new TestRunSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
