/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.TestRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestRunSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestRunSummary> {
    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testRunId").getter(TestRunSummary.getter(TestRunSummary::testRunId)).setter(TestRunSummary.setter(Builder::testRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunId").build()}).build();
    private static final SdkField<String> TEST_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testRunArn").getter(TestRunSummary.getter(TestRunSummary::testRunArn)).setter(TestRunSummary.setter(Builder::testRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunArn").build()}).build();
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSuiteId").getter(TestRunSummary.getter(TestRunSummary::testSuiteId)).setter(TestRunSummary.setter(Builder::testSuiteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteId").build()}).build();
    private static final SdkField<Integer> TEST_SUITE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testSuiteVersion").getter(TestRunSummary.getter(TestRunSummary::testSuiteVersion)).setter(TestRunSummary.setter(Builder::testSuiteVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteVersion").build()}).build();
    private static final SdkField<String> TEST_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testConfigurationId").getter(TestRunSummary.getter(TestRunSummary::testConfigurationId)).setter(TestRunSummary.setter(Builder::testConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationId").build()}).build();
    private static final SdkField<Integer> TEST_CONFIGURATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testConfigurationVersion").getter(TestRunSummary.getter(TestRunSummary::testConfigurationVersion)).setter(TestRunSummary.setter(Builder::testConfigurationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TestRunSummary.getter(TestRunSummary::statusAsString)).setter(TestRunSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(TestRunSummary.getter(TestRunSummary::statusReason)).setter(TestRunSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Instant> RUN_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("runStartTime").getter(TestRunSummary.getter(TestRunSummary::runStartTime)).setter(TestRunSummary.setter(Builder::runStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStartTime").build()}).build();
    private static final SdkField<Instant> RUN_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("runEndTime").getter(TestRunSummary.getter(TestRunSummary::runEndTime)).setter(TestRunSummary.setter(Builder::runEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RUN_ID_FIELD, TEST_RUN_ARN_FIELD, TEST_SUITE_ID_FIELD, TEST_SUITE_VERSION_FIELD, TEST_CONFIGURATION_ID_FIELD, TEST_CONFIGURATION_VERSION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, RUN_START_TIME_FIELD, RUN_END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestRunSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String testRunId;
    private final String testRunArn;
    private final String testSuiteId;
    private final Integer testSuiteVersion;
    private final String testConfigurationId;
    private final Integer testConfigurationVersion;
    private final String status;
    private final String statusReason;
    private final Instant runStartTime;
    private final Instant runEndTime;

    private TestRunSummary(BuilderImpl builder) {
        this.testRunId = builder.testRunId;
        this.testRunArn = builder.testRunArn;
        this.testSuiteId = builder.testSuiteId;
        this.testSuiteVersion = builder.testSuiteVersion;
        this.testConfigurationId = builder.testConfigurationId;
        this.testConfigurationVersion = builder.testConfigurationVersion;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.runStartTime = builder.runStartTime;
        this.runEndTime = builder.runEndTime;
    }

    public final String testRunId() {
        return this.testRunId;
    }

    public final String testRunArn() {
        return this.testRunArn;
    }

    public final String testSuiteId() {
        return this.testSuiteId;
    }

    public final Integer testSuiteVersion() {
        return this.testSuiteVersion;
    }

    public final String testConfigurationId() {
        return this.testConfigurationId;
    }

    public final Integer testConfigurationVersion() {
        return this.testConfigurationVersion;
    }

    public final TestRunStatus status() {
        return TestRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant runStartTime() {
        return this.runStartTime;
    }

    public final Instant runEndTime() {
        return this.runEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.testConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testConfigurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.runStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.runEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRunSummary)) {
            return false;
        }
        TestRunSummary other = (TestRunSummary)obj;
        return Objects.equals(this.testRunId(), other.testRunId()) && Objects.equals(this.testRunArn(), other.testRunArn()) && Objects.equals(this.testSuiteId(), other.testSuiteId()) && Objects.equals(this.testSuiteVersion(), other.testSuiteVersion()) && Objects.equals(this.testConfigurationId(), other.testConfigurationId()) && Objects.equals(this.testConfigurationVersion(), other.testConfigurationVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.runStartTime(), other.runStartTime()) && Objects.equals(this.runEndTime(), other.runEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"TestRunSummary").add("TestRunId", (Object)this.testRunId()).add("TestRunArn", (Object)this.testRunArn()).add("TestSuiteId", (Object)this.testSuiteId()).add("TestSuiteVersion", (Object)this.testSuiteVersion()).add("TestConfigurationId", (Object)this.testConfigurationId()).add("TestConfigurationVersion", (Object)this.testConfigurationVersion()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("RunStartTime", (Object)this.runStartTime()).add("RunEndTime", (Object)this.runEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testRunId": {
                return Optional.ofNullable(clazz.cast(this.testRunId()));
            }
            case "testRunArn": {
                return Optional.ofNullable(clazz.cast(this.testRunArn()));
            }
            case "testSuiteId": {
                return Optional.ofNullable(clazz.cast(this.testSuiteId()));
            }
            case "testSuiteVersion": {
                return Optional.ofNullable(clazz.cast(this.testSuiteVersion()));
            }
            case "testConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.testConfigurationId()));
            }
            case "testConfigurationVersion": {
                return Optional.ofNullable(clazz.cast(this.testConfigurationVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "runStartTime": {
                return Optional.ofNullable(clazz.cast(this.runStartTime()));
            }
            case "runEndTime": {
                return Optional.ofNullable(clazz.cast(this.runEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testRunId", TEST_RUN_ID_FIELD);
        map.put("testRunArn", TEST_RUN_ARN_FIELD);
        map.put("testSuiteId", TEST_SUITE_ID_FIELD);
        map.put("testSuiteVersion", TEST_SUITE_VERSION_FIELD);
        map.put("testConfigurationId", TEST_CONFIGURATION_ID_FIELD);
        map.put("testConfigurationVersion", TEST_CONFIGURATION_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("runStartTime", RUN_START_TIME_FIELD);
        map.put("runEndTime", RUN_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestRunSummary, T> g) {
        return obj -> g.apply((TestRunSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String testRunId;
        private String testRunArn;
        private String testSuiteId;
        private Integer testSuiteVersion;
        private String testConfigurationId;
        private Integer testConfigurationVersion;
        private String status;
        private String statusReason;
        private Instant runStartTime;
        private Instant runEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRunSummary model) {
            this.testRunId(model.testRunId);
            this.testRunArn(model.testRunArn);
            this.testSuiteId(model.testSuiteId);
            this.testSuiteVersion(model.testSuiteVersion);
            this.testConfigurationId(model.testConfigurationId);
            this.testConfigurationVersion(model.testConfigurationVersion);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.runStartTime(model.runStartTime);
            this.runEndTime(model.runEndTime);
        }

        public final String getTestRunId() {
            return this.testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getTestRunArn() {
            return this.testRunArn;
        }

        public final void setTestRunArn(String testRunArn) {
            this.testRunArn = testRunArn;
        }

        @Override
        public final Builder testRunArn(String testRunArn) {
            this.testRunArn = testRunArn;
            return this;
        }

        public final String getTestSuiteId() {
            return this.testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final Integer getTestSuiteVersion() {
            return this.testSuiteVersion;
        }

        public final void setTestSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
        }

        @Override
        public final Builder testSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
            return this;
        }

        public final String getTestConfigurationId() {
            return this.testConfigurationId;
        }

        public final void setTestConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
        }

        @Override
        public final Builder testConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
            return this;
        }

        public final Integer getTestConfigurationVersion() {
            return this.testConfigurationVersion;
        }

        public final void setTestConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
        }

        @Override
        public final Builder testConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getRunStartTime() {
            return this.runStartTime;
        }

        public final void setRunStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
        }

        @Override
        public final Builder runStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
            return this;
        }

        public final Instant getRunEndTime() {
            return this.runEndTime;
        }

        public final void setRunEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
        }

        @Override
        public final Builder runEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
            return this;
        }

        public TestRunSummary build() {
            return new TestRunSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestRunSummary> {
        public Builder testRunId(String var1);

        public Builder testRunArn(String var1);

        public Builder testSuiteId(String var1);

        public Builder testSuiteVersion(Integer var1);

        public Builder testConfigurationId(String var1);

        public Builder testConfigurationVersion(Integer var1);

        public Builder status(String var1);

        public Builder status(TestRunStatus var1);

        public Builder statusReason(String var1);

        public Builder runStartTime(Instant var1);

        public Builder runEndTime(Instant var1);
    }
}

