/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetQueryExecutionResponse extends AthenaResponse implements
        ToCopyableBuilder<BatchGetQueryExecutionResponse.Builder, BatchGetQueryExecutionResponse> {
    private static final SdkField<List<QueryExecution>> QUERY_EXECUTIONS_FIELD = SdkField
            .<List<QueryExecution>> builder(MarshallingType.LIST)
            .memberName("QueryExecutions")
            .getter(getter(BatchGetQueryExecutionResponse::queryExecutions))
            .setter(setter(Builder::queryExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedQueryExecutionId>> UNPROCESSED_QUERY_EXECUTION_IDS_FIELD = SdkField
            .<List<UnprocessedQueryExecutionId>> builder(MarshallingType.LIST)
            .memberName("UnprocessedQueryExecutionIds")
            .getter(getter(BatchGetQueryExecutionResponse::unprocessedQueryExecutionIds))
            .setter(setter(Builder::unprocessedQueryExecutionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedQueryExecutionIds")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedQueryExecutionId> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedQueryExecutionId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_EXECUTIONS_FIELD,
            UNPROCESSED_QUERY_EXECUTION_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<QueryExecution> queryExecutions;

    private final List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds;

    private BatchGetQueryExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.queryExecutions = builder.queryExecutions;
        this.unprocessedQueryExecutionIds = builder.unprocessedQueryExecutionIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryExecutions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryExecutions() {
        return queryExecutions != null && !(queryExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about a query execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryExecutions} method.
     * </p>
     * 
     * @return Information about a query execution.
     */
    public final List<QueryExecution> queryExecutions() {
        return queryExecutions;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedQueryExecutionIds property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnprocessedQueryExecutionIds() {
        return unprocessedQueryExecutionIds != null && !(unprocessedQueryExecutionIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the query executions that failed to run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedQueryExecutionIds} method.
     * </p>
     * 
     * @return Information about the query executions that failed to run.
     */
    public final List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds() {
        return unprocessedQueryExecutionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryExecutions() ? queryExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedQueryExecutionIds() ? unprocessedQueryExecutionIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetQueryExecutionResponse)) {
            return false;
        }
        BatchGetQueryExecutionResponse other = (BatchGetQueryExecutionResponse) obj;
        return hasQueryExecutions() == other.hasQueryExecutions() && Objects.equals(queryExecutions(), other.queryExecutions())
                && hasUnprocessedQueryExecutionIds() == other.hasUnprocessedQueryExecutionIds()
                && Objects.equals(unprocessedQueryExecutionIds(), other.unprocessedQueryExecutionIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetQueryExecutionResponse")
                .add("QueryExecutions", hasQueryExecutions() ? queryExecutions() : null)
                .add("UnprocessedQueryExecutionIds", hasUnprocessedQueryExecutionIds() ? unprocessedQueryExecutionIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryExecutions":
            return Optional.ofNullable(clazz.cast(queryExecutions()));
        case "UnprocessedQueryExecutionIds":
            return Optional.ofNullable(clazz.cast(unprocessedQueryExecutionIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryExecutions", QUERY_EXECUTIONS_FIELD);
        map.put("UnprocessedQueryExecutionIds", UNPROCESSED_QUERY_EXECUTION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetQueryExecutionResponse, T> g) {
        return obj -> g.apply((BatchGetQueryExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetQueryExecutionResponse> {
        /**
         * <p>
         * Information about a query execution.
         * </p>
         * 
         * @param queryExecutions
         *        Information about a query execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryExecutions(Collection<QueryExecution> queryExecutions);

        /**
         * <p>
         * Information about a query execution.
         * </p>
         * 
         * @param queryExecutions
         *        Information about a query execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryExecutions(QueryExecution... queryExecutions);

        /**
         * <p>
         * Information about a query execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.athena.model.QueryExecution.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.athena.model.QueryExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.athena.model.QueryExecution.Builder#build()} is called immediately and
         * its result is passed to {@link #queryExecutions(List<QueryExecution>)}.
         * 
         * @param queryExecutions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.athena.model.QueryExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryExecutions(java.util.Collection<QueryExecution>)
         */
        Builder queryExecutions(Consumer<QueryExecution.Builder>... queryExecutions);

        /**
         * <p>
         * Information about the query executions that failed to run.
         * </p>
         * 
         * @param unprocessedQueryExecutionIds
         *        Information about the query executions that failed to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds);

        /**
         * <p>
         * Information about the query executions that failed to run.
         * </p>
         * 
         * @param unprocessedQueryExecutionIds
         *        Information about the query executions that failed to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedQueryExecutionIds(UnprocessedQueryExecutionId... unprocessedQueryExecutionIds);

        /**
         * <p>
         * Information about the query executions that failed to run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #unprocessedQueryExecutionIds(List<UnprocessedQueryExecutionId>)}.
         * 
         * @param unprocessedQueryExecutionIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedQueryExecutionIds(java.util.Collection<UnprocessedQueryExecutionId>)
         */
        Builder unprocessedQueryExecutionIds(Consumer<UnprocessedQueryExecutionId.Builder>... unprocessedQueryExecutionIds);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<QueryExecution> queryExecutions = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetQueryExecutionResponse model) {
            super(model);
            queryExecutions(model.queryExecutions);
            unprocessedQueryExecutionIds(model.unprocessedQueryExecutionIds);
        }

        public final List<QueryExecution.Builder> getQueryExecutions() {
            List<QueryExecution.Builder> result = QueryExecutionListCopier.copyToBuilder(this.queryExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryExecutions(Collection<QueryExecution.BuilderImpl> queryExecutions) {
            this.queryExecutions = QueryExecutionListCopier.copyFromBuilder(queryExecutions);
        }

        @Override
        public final Builder queryExecutions(Collection<QueryExecution> queryExecutions) {
            this.queryExecutions = QueryExecutionListCopier.copy(queryExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutions(QueryExecution... queryExecutions) {
            queryExecutions(Arrays.asList(queryExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutions(Consumer<QueryExecution.Builder>... queryExecutions) {
            queryExecutions(Stream.of(queryExecutions).map(c -> QueryExecution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedQueryExecutionId.Builder> getUnprocessedQueryExecutionIds() {
            List<UnprocessedQueryExecutionId.Builder> result = UnprocessedQueryExecutionIdListCopier
                    .copyToBuilder(this.unprocessedQueryExecutionIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedQueryExecutionIds(
                Collection<UnprocessedQueryExecutionId.BuilderImpl> unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds = UnprocessedQueryExecutionIdListCopier
                    .copyFromBuilder(unprocessedQueryExecutionIds);
        }

        @Override
        public final Builder unprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds = UnprocessedQueryExecutionIdListCopier.copy(unprocessedQueryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedQueryExecutionIds(UnprocessedQueryExecutionId... unprocessedQueryExecutionIds) {
            unprocessedQueryExecutionIds(Arrays.asList(unprocessedQueryExecutionIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedQueryExecutionIds(
                Consumer<UnprocessedQueryExecutionId.Builder>... unprocessedQueryExecutionIds) {
            unprocessedQueryExecutionIds(Stream.of(unprocessedQueryExecutionIds)
                    .map(c -> UnprocessedQueryExecutionId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetQueryExecutionResponse build() {
            return new BatchGetQueryExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
