/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCalculationExecutionStatusResponse extends AthenaResponse implements
        ToCopyableBuilder<GetCalculationExecutionStatusResponse.Builder, GetCalculationExecutionStatusResponse> {
    private static final SdkField<CalculationStatus> STATUS_FIELD = SdkField
            .<CalculationStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(GetCalculationExecutionStatusResponse::status)).setter(setter(Builder::status))
            .constructor(CalculationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<CalculationStatistics> STATISTICS_FIELD = SdkField
            .<CalculationStatistics> builder(MarshallingType.SDK_POJO).memberName("Statistics")
            .getter(getter(GetCalculationExecutionStatusResponse::statistics)).setter(setter(Builder::statistics))
            .constructor(CalculationStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STATUS_FIELD, STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CalculationStatus status;

    private final CalculationStatistics statistics;

    private GetCalculationExecutionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * Contains information about the calculation execution status.
     * </p>
     * 
     * @return Contains information about the calculation execution status.
     */
    public final CalculationStatus status() {
        return status;
    }

    /**
     * <p>
     * Contains information about the DPU execution time and progress.
     * </p>
     * 
     * @return Contains information about the DPU execution time and progress.
     */
    public final CalculationStatistics statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCalculationExecutionStatusResponse)) {
            return false;
        }
        GetCalculationExecutionStatusResponse other = (GetCalculationExecutionStatusResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCalculationExecutionStatusResponse").add("Status", status()).add("Statistics", statistics())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("Statistics", STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCalculationExecutionStatusResponse, T> g) {
        return obj -> g.apply((GetCalculationExecutionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCalculationExecutionStatusResponse> {
        /**
         * <p>
         * Contains information about the calculation execution status.
         * </p>
         * 
         * @param status
         *        Contains information about the calculation execution status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(CalculationStatus status);

        /**
         * <p>
         * Contains information about the calculation execution status.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculationStatus.Builder} avoiding the
         * need to create one manually via {@link CalculationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalculationStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(CalculationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link CalculationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(CalculationStatus)
         */
        default Builder status(Consumer<CalculationStatus.Builder> status) {
            return status(CalculationStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Contains information about the DPU execution time and progress.
         * </p>
         * 
         * @param statistics
         *        Contains information about the DPU execution time and progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(CalculationStatistics statistics);

        /**
         * <p>
         * Contains information about the DPU execution time and progress.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculationStatistics.Builder} avoiding
         * the need to create one manually via {@link CalculationStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalculationStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #statistics(CalculationStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link CalculationStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(CalculationStatistics)
         */
        default Builder statistics(Consumer<CalculationStatistics.Builder> statistics) {
            return statistics(CalculationStatistics.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private CalculationStatus status;

        private CalculationStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCalculationExecutionStatusResponse model) {
            super(model);
            status(model.status);
            statistics(model.statistics);
        }

        public final CalculationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(CalculationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(CalculationStatus status) {
            this.status = status;
            return this;
        }

        public final CalculationStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(CalculationStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(CalculationStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public GetCalculationExecutionStatusResponse build() {
            return new GetCalculationExecutionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
