/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopCalculationExecutionResponse extends AthenaResponse implements
        ToCopyableBuilder<StopCalculationExecutionResponse.Builder, StopCalculationExecutionResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(StopCalculationExecutionResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String state;

    private StopCalculationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
    }

    /**
     * <p>
     * <code>CREATING</code> - The calculation is in the process of being created.
     * </p>
     * <p>
     * <code>CREATED</code> - The calculation has been created and is ready to run.
     * </p>
     * <p>
     * <code>QUEUED</code> - The calculation has been queued for processing.
     * </p>
     * <p>
     * <code>RUNNING</code> - The calculation is running.
     * </p>
     * <p>
     * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop
     * it.
     * </p>
     * <p>
     * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     * </p>
     * <p>
     * <code>COMPLETED</code> - The calculation has completed without error.
     * </p>
     * <p>
     * <code>FAILED</code> - The calculation failed and is no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CalculationExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <code>CREATING</code> - The calculation is in the process of being created.</p>
     *         <p>
     *         <code>CREATED</code> - The calculation has been created and is ready to run.
     *         </p>
     *         <p>
     *         <code>QUEUED</code> - The calculation has been queued for processing.
     *         </p>
     *         <p>
     *         <code>RUNNING</code> - The calculation is running.
     *         </p>
     *         <p>
     *         <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working
     *         to stop it.
     *         </p>
     *         <p>
     *         <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     *         </p>
     *         <p>
     *         <code>COMPLETED</code> - The calculation has completed without error.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - The calculation failed and is no longer running.
     * @see CalculationExecutionState
     */
    public final CalculationExecutionState state() {
        return CalculationExecutionState.fromValue(state);
    }

    /**
     * <p>
     * <code>CREATING</code> - The calculation is in the process of being created.
     * </p>
     * <p>
     * <code>CREATED</code> - The calculation has been created and is ready to run.
     * </p>
     * <p>
     * <code>QUEUED</code> - The calculation has been queued for processing.
     * </p>
     * <p>
     * <code>RUNNING</code> - The calculation is running.
     * </p>
     * <p>
     * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop
     * it.
     * </p>
     * <p>
     * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     * </p>
     * <p>
     * <code>COMPLETED</code> - The calculation has completed without error.
     * </p>
     * <p>
     * <code>FAILED</code> - The calculation failed and is no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CalculationExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <code>CREATING</code> - The calculation is in the process of being created.</p>
     *         <p>
     *         <code>CREATED</code> - The calculation has been created and is ready to run.
     *         </p>
     *         <p>
     *         <code>QUEUED</code> - The calculation has been queued for processing.
     *         </p>
     *         <p>
     *         <code>RUNNING</code> - The calculation is running.
     *         </p>
     *         <p>
     *         <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working
     *         to stop it.
     *         </p>
     *         <p>
     *         <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     *         </p>
     *         <p>
     *         <code>COMPLETED</code> - The calculation has completed without error.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - The calculation failed and is no longer running.
     * @see CalculationExecutionState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopCalculationExecutionResponse)) {
            return false;
        }
        StopCalculationExecutionResponse other = (StopCalculationExecutionResponse) obj;
        return Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopCalculationExecutionResponse").add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopCalculationExecutionResponse, T> g) {
        return obj -> g.apply((StopCalculationExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopCalculationExecutionResponse> {
        /**
         * <p>
         * <code>CREATING</code> - The calculation is in the process of being created.
         * </p>
         * <p>
         * <code>CREATED</code> - The calculation has been created and is ready to run.
         * </p>
         * <p>
         * <code>QUEUED</code> - The calculation has been queued for processing.
         * </p>
         * <p>
         * <code>RUNNING</code> - The calculation is running.
         * </p>
         * <p>
         * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to
         * stop it.
         * </p>
         * <p>
         * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
         * </p>
         * <p>
         * <code>COMPLETED</code> - The calculation has completed without error.
         * </p>
         * <p>
         * <code>FAILED</code> - The calculation failed and is no longer running.
         * </p>
         * 
         * @param state
         *        <code>CREATING</code> - The calculation is in the process of being created.</p>
         *        <p>
         *        <code>CREATED</code> - The calculation has been created and is ready to run.
         *        </p>
         *        <p>
         *        <code>QUEUED</code> - The calculation has been queued for processing.
         *        </p>
         *        <p>
         *        <code>RUNNING</code> - The calculation is running.
         *        </p>
         *        <p>
         *        <code>CANCELING</code> - A request to cancel the calculation has been received and the system is
         *        working to stop it.
         *        </p>
         *        <p>
         *        <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
         *        </p>
         *        <p>
         *        <code>COMPLETED</code> - The calculation has completed without error.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - The calculation failed and is no longer running.
         * @see CalculationExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CalculationExecutionState
         */
        Builder state(String state);

        /**
         * <p>
         * <code>CREATING</code> - The calculation is in the process of being created.
         * </p>
         * <p>
         * <code>CREATED</code> - The calculation has been created and is ready to run.
         * </p>
         * <p>
         * <code>QUEUED</code> - The calculation has been queued for processing.
         * </p>
         * <p>
         * <code>RUNNING</code> - The calculation is running.
         * </p>
         * <p>
         * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to
         * stop it.
         * </p>
         * <p>
         * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
         * </p>
         * <p>
         * <code>COMPLETED</code> - The calculation has completed without error.
         * </p>
         * <p>
         * <code>FAILED</code> - The calculation failed and is no longer running.
         * </p>
         * 
         * @param state
         *        <code>CREATING</code> - The calculation is in the process of being created.</p>
         *        <p>
         *        <code>CREATED</code> - The calculation has been created and is ready to run.
         *        </p>
         *        <p>
         *        <code>QUEUED</code> - The calculation has been queued for processing.
         *        </p>
         *        <p>
         *        <code>RUNNING</code> - The calculation is running.
         *        </p>
         *        <p>
         *        <code>CANCELING</code> - A request to cancel the calculation has been received and the system is
         *        working to stop it.
         *        </p>
         *        <p>
         *        <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
         *        </p>
         *        <p>
         *        <code>COMPLETED</code> - The calculation has completed without error.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - The calculation failed and is no longer running.
         * @see CalculationExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CalculationExecutionState
         */
        Builder state(CalculationExecutionState state);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(StopCalculationExecutionResponse model) {
            super(model);
            state(model.state);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CalculationExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public StopCalculationExecutionResponse build() {
            return new StopCalculationExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
