/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.CapacityAssignment;
import software.amazon.awssdk.services.athena.model.CapacityAssignmentsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityAssignmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityAssignmentConfiguration> {
    private static final SdkField<String> CAPACITY_RESERVATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationName").getter(CapacityAssignmentConfiguration.getter(CapacityAssignmentConfiguration::capacityReservationName)).setter(CapacityAssignmentConfiguration.setter(Builder::capacityReservationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationName").build()}).build();
    private static final SdkField<List<CapacityAssignment>> CAPACITY_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityAssignments").getter(CapacityAssignmentConfiguration.getter(CapacityAssignmentConfiguration::capacityAssignments)).setter(CapacityAssignmentConfiguration.setter(Builder::capacityAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityAssignments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityAssignment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_NAME_FIELD, CAPACITY_ASSIGNMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityAssignmentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityReservationName;
    private final List<CapacityAssignment> capacityAssignments;

    private CapacityAssignmentConfiguration(BuilderImpl builder) {
        this.capacityReservationName = builder.capacityReservationName;
        this.capacityAssignments = builder.capacityAssignments;
    }

    public final String capacityReservationName() {
        return this.capacityReservationName;
    }

    public final boolean hasCapacityAssignments() {
        return this.capacityAssignments != null && !(this.capacityAssignments instanceof SdkAutoConstructList);
    }

    public final List<CapacityAssignment> capacityAssignments() {
        return this.capacityAssignments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityAssignments() ? this.capacityAssignments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityAssignmentConfiguration)) {
            return false;
        }
        CapacityAssignmentConfiguration other = (CapacityAssignmentConfiguration)obj;
        return Objects.equals(this.capacityReservationName(), other.capacityReservationName()) && this.hasCapacityAssignments() == other.hasCapacityAssignments() && Objects.equals(this.capacityAssignments(), other.capacityAssignments());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityAssignmentConfiguration").add("CapacityReservationName", (Object)this.capacityReservationName()).add("CapacityAssignments", this.hasCapacityAssignments() ? this.capacityAssignments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationName": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationName()));
            }
            case "CapacityAssignments": {
                return Optional.ofNullable(clazz.cast(this.capacityAssignments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityReservationName", CAPACITY_RESERVATION_NAME_FIELD);
        map.put("CapacityAssignments", CAPACITY_ASSIGNMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityAssignmentConfiguration, T> g) {
        return obj -> g.apply((CapacityAssignmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityReservationName;
        private List<CapacityAssignment> capacityAssignments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityAssignmentConfiguration model) {
            this.capacityReservationName(model.capacityReservationName);
            this.capacityAssignments(model.capacityAssignments);
        }

        public final String getCapacityReservationName() {
            return this.capacityReservationName;
        }

        public final void setCapacityReservationName(String capacityReservationName) {
            this.capacityReservationName = capacityReservationName;
        }

        @Override
        public final Builder capacityReservationName(String capacityReservationName) {
            this.capacityReservationName = capacityReservationName;
            return this;
        }

        public final List<CapacityAssignment.Builder> getCapacityAssignments() {
            List<CapacityAssignment.Builder> result = CapacityAssignmentsListCopier.copyToBuilder(this.capacityAssignments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityAssignments(Collection<CapacityAssignment.BuilderImpl> capacityAssignments) {
            this.capacityAssignments = CapacityAssignmentsListCopier.copyFromBuilder(capacityAssignments);
        }

        @Override
        public final Builder capacityAssignments(Collection<CapacityAssignment> capacityAssignments) {
            this.capacityAssignments = CapacityAssignmentsListCopier.copy(capacityAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityAssignments(CapacityAssignment ... capacityAssignments) {
            this.capacityAssignments(Arrays.asList(capacityAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityAssignments(Consumer<CapacityAssignment.Builder> ... capacityAssignments) {
            this.capacityAssignments(Stream.of(capacityAssignments).map(c -> (CapacityAssignment)((CapacityAssignment.Builder)CapacityAssignment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CapacityAssignmentConfiguration build() {
            return new CapacityAssignmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityAssignmentConfiguration> {
        public Builder capacityReservationName(String var1);

        public Builder capacityAssignments(Collection<CapacityAssignment> var1);

        public Builder capacityAssignments(CapacityAssignment ... var1);

        public Builder capacityAssignments(Consumer<CapacityAssignment.Builder> ... var1);
    }
}

