/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.CapacityAllocation;
import software.amazon.awssdk.services.athena.model.CapacityReservationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservation> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CapacityReservation.getter(CapacityReservation::name)).setter(CapacityReservation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CapacityReservation.getter(CapacityReservation::statusAsString)).setter(CapacityReservation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> TARGET_DPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetDpus").getter(CapacityReservation.getter(CapacityReservation::targetDpus)).setter(CapacityReservation.setter(Builder::targetDpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDpus").build()}).build();
    private static final SdkField<Integer> ALLOCATED_DPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedDpus").getter(CapacityReservation.getter(CapacityReservation::allocatedDpus)).setter(CapacityReservation.setter(Builder::allocatedDpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedDpus").build()}).build();
    private static final SdkField<CapacityAllocation> LAST_ALLOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastAllocation").getter(CapacityReservation.getter(CapacityReservation::lastAllocation)).setter(CapacityReservation.setter(Builder::lastAllocation)).constructor(CapacityAllocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAllocation").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_ALLOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessfulAllocationTime").getter(CapacityReservation.getter(CapacityReservation::lastSuccessfulAllocationTime)).setter(CapacityReservation.setter(Builder::lastSuccessfulAllocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulAllocationTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CapacityReservation.getter(CapacityReservation::creationTime)).setter(CapacityReservation.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, TARGET_DPUS_FIELD, ALLOCATED_DPUS_FIELD, LAST_ALLOCATION_FIELD, LAST_SUCCESSFUL_ALLOCATION_TIME_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityReservation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final Integer targetDpus;
    private final Integer allocatedDpus;
    private final CapacityAllocation lastAllocation;
    private final Instant lastSuccessfulAllocationTime;
    private final Instant creationTime;

    private CapacityReservation(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.targetDpus = builder.targetDpus;
        this.allocatedDpus = builder.allocatedDpus;
        this.lastAllocation = builder.lastAllocation;
        this.lastSuccessfulAllocationTime = builder.lastSuccessfulAllocationTime;
        this.creationTime = builder.creationTime;
    }

    public final String name() {
        return this.name;
    }

    public final CapacityReservationStatus status() {
        return CapacityReservationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer targetDpus() {
        return this.targetDpus;
    }

    public final Integer allocatedDpus() {
        return this.allocatedDpus;
    }

    public final CapacityAllocation lastAllocation() {
        return this.lastAllocation;
    }

    public final Instant lastSuccessfulAllocationTime() {
        return this.lastSuccessfulAllocationTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedDpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAllocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulAllocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservation)) {
            return false;
        }
        CapacityReservation other = (CapacityReservation)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetDpus(), other.targetDpus()) && Objects.equals(this.allocatedDpus(), other.allocatedDpus()) && Objects.equals(this.lastAllocation(), other.lastAllocation()) && Objects.equals(this.lastSuccessfulAllocationTime(), other.lastSuccessfulAllocationTime()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityReservation").add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("TargetDpus", (Object)this.targetDpus()).add("AllocatedDpus", (Object)this.allocatedDpus()).add("LastAllocation", (Object)this.lastAllocation()).add("LastSuccessfulAllocationTime", (Object)this.lastSuccessfulAllocationTime()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TargetDpus": {
                return Optional.ofNullable(clazz.cast(this.targetDpus()));
            }
            case "AllocatedDpus": {
                return Optional.ofNullable(clazz.cast(this.allocatedDpus()));
            }
            case "LastAllocation": {
                return Optional.ofNullable(clazz.cast(this.lastAllocation()));
            }
            case "LastSuccessfulAllocationTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulAllocationTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TargetDpus", TARGET_DPUS_FIELD);
        map.put("AllocatedDpus", ALLOCATED_DPUS_FIELD);
        map.put("LastAllocation", LAST_ALLOCATION_FIELD);
        map.put("LastSuccessfulAllocationTime", LAST_SUCCESSFUL_ALLOCATION_TIME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservation, T> g) {
        return obj -> g.apply((CapacityReservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private Integer targetDpus;
        private Integer allocatedDpus;
        private CapacityAllocation lastAllocation;
        private Instant lastSuccessfulAllocationTime;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservation model) {
            this.name(model.name);
            this.status(model.status);
            this.targetDpus(model.targetDpus);
            this.allocatedDpus(model.allocatedDpus);
            this.lastAllocation(model.lastAllocation);
            this.lastSuccessfulAllocationTime(model.lastSuccessfulAllocationTime);
            this.creationTime(model.creationTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapacityReservationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getTargetDpus() {
            return this.targetDpus;
        }

        public final void setTargetDpus(Integer targetDpus) {
            this.targetDpus = targetDpus;
        }

        @Override
        public final Builder targetDpus(Integer targetDpus) {
            this.targetDpus = targetDpus;
            return this;
        }

        public final Integer getAllocatedDpus() {
            return this.allocatedDpus;
        }

        public final void setAllocatedDpus(Integer allocatedDpus) {
            this.allocatedDpus = allocatedDpus;
        }

        @Override
        public final Builder allocatedDpus(Integer allocatedDpus) {
            this.allocatedDpus = allocatedDpus;
            return this;
        }

        public final CapacityAllocation.Builder getLastAllocation() {
            return this.lastAllocation != null ? this.lastAllocation.toBuilder() : null;
        }

        public final void setLastAllocation(CapacityAllocation.BuilderImpl lastAllocation) {
            this.lastAllocation = lastAllocation != null ? lastAllocation.build() : null;
        }

        @Override
        public final Builder lastAllocation(CapacityAllocation lastAllocation) {
            this.lastAllocation = lastAllocation;
            return this;
        }

        public final Instant getLastSuccessfulAllocationTime() {
            return this.lastSuccessfulAllocationTime;
        }

        public final void setLastSuccessfulAllocationTime(Instant lastSuccessfulAllocationTime) {
            this.lastSuccessfulAllocationTime = lastSuccessfulAllocationTime;
        }

        @Override
        public final Builder lastSuccessfulAllocationTime(Instant lastSuccessfulAllocationTime) {
            this.lastSuccessfulAllocationTime = lastSuccessfulAllocationTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public CapacityReservation build() {
            return new CapacityReservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservation> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(CapacityReservationStatus var1);

        public Builder targetDpus(Integer var1);

        public Builder allocatedDpus(Integer var1);

        public Builder lastAllocation(CapacityAllocation var1);

        default public Builder lastAllocation(Consumer<CapacityAllocation.Builder> lastAllocation) {
            return this.lastAllocation((CapacityAllocation)((CapacityAllocation.Builder)CapacityAllocation.builder().applyMutation(lastAllocation)).build());
        }

        public Builder lastSuccessfulAllocationTime(Instant var1);

        public Builder creationTime(Instant var1);
    }
}

