/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.CapacityReservation;
import software.amazon.awssdk.services.athena.model.CapacityReservationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCapacityReservationsResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListCapacityReservationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCapacityReservationsResponse.getter(ListCapacityReservationsResponse::nextToken)).setter(ListCapacityReservationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<CapacityReservation>> CAPACITY_RESERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservations").getter(ListCapacityReservationsResponse.getter(ListCapacityReservationsResponse::capacityReservations)).setter(ListCapacityReservationsResponse.setter(Builder::capacityReservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CAPACITY_RESERVATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCapacityReservationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CapacityReservation> capacityReservations;

    private ListCapacityReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservations = builder.capacityReservations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCapacityReservations() {
        return this.capacityReservations != null && !(this.capacityReservations instanceof SdkAutoConstructList);
    }

    public final List<CapacityReservation> capacityReservations() {
        return this.capacityReservations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservations() ? this.capacityReservations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapacityReservationsResponse)) {
            return false;
        }
        ListCapacityReservationsResponse other = (ListCapacityReservationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCapacityReservations() == other.hasCapacityReservations() && Objects.equals(this.capacityReservations(), other.capacityReservations());
    }

    public final String toString() {
        return ToString.builder((String)"ListCapacityReservationsResponse").add("NextToken", (Object)this.nextToken()).add("CapacityReservations", this.hasCapacityReservations() ? this.capacityReservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CapacityReservations": {
                return Optional.ofNullable(clazz.cast(this.capacityReservations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CapacityReservations", CAPACITY_RESERVATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCapacityReservationsResponse, T> g) {
        return obj -> g.apply((ListCapacityReservationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CapacityReservation> capacityReservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCapacityReservationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.capacityReservations(model.capacityReservations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CapacityReservation.Builder> getCapacityReservations() {
            List<CapacityReservation.Builder> result = CapacityReservationsListCopier.copyToBuilder(this.capacityReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservations(Collection<CapacityReservation.BuilderImpl> capacityReservations) {
            this.capacityReservations = CapacityReservationsListCopier.copyFromBuilder(capacityReservations);
        }

        @Override
        public final Builder capacityReservations(Collection<CapacityReservation> capacityReservations) {
            this.capacityReservations = CapacityReservationsListCopier.copy(capacityReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(CapacityReservation ... capacityReservations) {
            this.capacityReservations(Arrays.asList(capacityReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(Consumer<CapacityReservation.Builder> ... capacityReservations) {
            this.capacityReservations(Stream.of(capacityReservations).map(c -> (CapacityReservation)((CapacityReservation.Builder)CapacityReservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCapacityReservationsResponse build() {
            return new ListCapacityReservationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCapacityReservationsResponse> {
        public Builder nextToken(String var1);

        public Builder capacityReservations(Collection<CapacityReservation> var1);

        public Builder capacityReservations(CapacityReservation ... var1);

        public Builder capacityReservations(Consumer<CapacityReservation.Builder> ... var1);
    }
}

