/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RestoreValidationStatus {
    FAILED("FAILED"),
    SUCCESSFUL("SUCCESSFUL"),
    TIMED_OUT("TIMED_OUT"),
    VALIDATING("VALIDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RestoreValidationStatus> VALUE_MAP;
    private final String value;

    private RestoreValidationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RestoreValidationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RestoreValidationStatus> knownValues() {
        EnumSet<RestoreValidationStatus> knownValues = EnumSet.allOf(RestoreValidationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RestoreValidationStatus.class, RestoreValidationStatus::toString);
    }
}

