/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the properties for the Amazon ECS resources of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsProperties implements SdkPojo, Serializable, ToCopyableBuilder<EcsProperties.Builder, EcsProperties> {
    private static final SdkField<List<EcsTaskProperties>> TASK_PROPERTIES_FIELD = SdkField
            .<List<EcsTaskProperties>> builder(MarshallingType.LIST)
            .memberName("taskProperties")
            .getter(getter(EcsProperties::taskProperties))
            .setter(setter(Builder::taskProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EcsTaskProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(EcsTaskProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EcsTaskProperties> taskProperties;

    private EcsProperties(BuilderImpl builder) {
        this.taskProperties = builder.taskProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskProperties() {
        return taskProperties != null && !(taskProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains the properties for the Amazon ECS task definition of a job.
     * </p>
     * <note>
     * <p>
     * This object is currently limited to one task element. However, the task element can run up to 10 containers.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskProperties} method.
     * </p>
     * 
     * @return An object that contains the properties for the Amazon ECS task definition of a job.</p> <note>
     *         <p>
     *         This object is currently limited to one task element. However, the task element can run up to 10
     *         containers.
     *         </p>
     */
    public final List<EcsTaskProperties> taskProperties() {
        return taskProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskProperties() ? taskProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsProperties)) {
            return false;
        }
        EcsProperties other = (EcsProperties) obj;
        return hasTaskProperties() == other.hasTaskProperties() && Objects.equals(taskProperties(), other.taskProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcsProperties").add("TaskProperties", hasTaskProperties() ? taskProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskProperties":
            return Optional.ofNullable(clazz.cast(taskProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskProperties", TASK_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsProperties, T> g) {
        return obj -> g.apply((EcsProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcsProperties> {
        /**
         * <p>
         * An object that contains the properties for the Amazon ECS task definition of a job.
         * </p>
         * <note>
         * <p>
         * This object is currently limited to one task element. However, the task element can run up to 10 containers.
         * </p>
         * </note>
         * 
         * @param taskProperties
         *        An object that contains the properties for the Amazon ECS task definition of a job.</p> <note>
         *        <p>
         *        This object is currently limited to one task element. However, the task element can run up to 10
         *        containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskProperties(Collection<EcsTaskProperties> taskProperties);

        /**
         * <p>
         * An object that contains the properties for the Amazon ECS task definition of a job.
         * </p>
         * <note>
         * <p>
         * This object is currently limited to one task element. However, the task element can run up to 10 containers.
         * </p>
         * </note>
         * 
         * @param taskProperties
         *        An object that contains the properties for the Amazon ECS task definition of a job.</p> <note>
         *        <p>
         *        This object is currently limited to one task element. However, the task element can run up to 10
         *        containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskProperties(EcsTaskProperties... taskProperties);

        /**
         * <p>
         * An object that contains the properties for the Amazon ECS task definition of a job.
         * </p>
         * <note>
         * <p>
         * This object is currently limited to one task element. However, the task element can run up to 10 containers.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.EcsTaskProperties.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.EcsTaskProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.EcsTaskProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #taskProperties(List<EcsTaskProperties>)}.
         * 
         * @param taskProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.EcsTaskProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskProperties(java.util.Collection<EcsTaskProperties>)
         */
        Builder taskProperties(Consumer<EcsTaskProperties.Builder>... taskProperties);
    }

    static final class BuilderImpl implements Builder {
        private List<EcsTaskProperties> taskProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcsProperties model) {
            taskProperties(model.taskProperties);
        }

        public final List<EcsTaskProperties.Builder> getTaskProperties() {
            List<EcsTaskProperties.Builder> result = ListEcsTaskPropertiesCopier.copyToBuilder(this.taskProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskProperties(Collection<EcsTaskProperties.BuilderImpl> taskProperties) {
            this.taskProperties = ListEcsTaskPropertiesCopier.copyFromBuilder(taskProperties);
        }

        @Override
        public final Builder taskProperties(Collection<EcsTaskProperties> taskProperties) {
            this.taskProperties = ListEcsTaskPropertiesCopier.copy(taskProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(EcsTaskProperties... taskProperties) {
            taskProperties(Arrays.asList(taskProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(Consumer<EcsTaskProperties.Builder>... taskProperties) {
            taskProperties(Stream.of(taskProperties).map(c -> EcsTaskProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EcsProperties build() {
            return new EcsProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
