/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.ShareAttributes;
import software.amazon.awssdk.services.batch.model.ShareAttributesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FairsharePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FairsharePolicy> {
    private static final SdkField<Integer> SHARE_DECAY_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("shareDecaySeconds").getter(FairsharePolicy.getter(FairsharePolicy::shareDecaySeconds)).setter(FairsharePolicy.setter(Builder::shareDecaySeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareDecaySeconds").build()}).build();
    private static final SdkField<Integer> COMPUTE_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("computeReservation").getter(FairsharePolicy.getter(FairsharePolicy::computeReservation)).setter(FairsharePolicy.setter(Builder::computeReservation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeReservation").build()}).build();
    private static final SdkField<List<ShareAttributes>> SHARE_DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("shareDistribution").getter(FairsharePolicy.getter(FairsharePolicy::shareDistribution)).setter(FairsharePolicy.setter(Builder::shareDistribution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareDistribution").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ShareAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_DECAY_SECONDS_FIELD, COMPUTE_RESERVATION_FIELD, SHARE_DISTRIBUTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FairsharePolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer shareDecaySeconds;
    private final Integer computeReservation;
    private final List<ShareAttributes> shareDistribution;

    private FairsharePolicy(BuilderImpl builder) {
        this.shareDecaySeconds = builder.shareDecaySeconds;
        this.computeReservation = builder.computeReservation;
        this.shareDistribution = builder.shareDistribution;
    }

    public final Integer shareDecaySeconds() {
        return this.shareDecaySeconds;
    }

    public final Integer computeReservation() {
        return this.computeReservation;
    }

    public final boolean hasShareDistribution() {
        return this.shareDistribution != null && !(this.shareDistribution instanceof SdkAutoConstructList);
    }

    public final List<ShareAttributes> shareDistribution() {
        return this.shareDistribution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shareDecaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShareDistribution() ? this.shareDistribution() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FairsharePolicy)) {
            return false;
        }
        FairsharePolicy other = (FairsharePolicy)obj;
        return Objects.equals(this.shareDecaySeconds(), other.shareDecaySeconds()) && Objects.equals(this.computeReservation(), other.computeReservation()) && this.hasShareDistribution() == other.hasShareDistribution() && Objects.equals(this.shareDistribution(), other.shareDistribution());
    }

    public final String toString() {
        return ToString.builder((String)"FairsharePolicy").add("ShareDecaySeconds", (Object)this.shareDecaySeconds()).add("ComputeReservation", (Object)this.computeReservation()).add("ShareDistribution", this.hasShareDistribution() ? this.shareDistribution() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "shareDecaySeconds": {
                return Optional.ofNullable(clazz.cast(this.shareDecaySeconds()));
            }
            case "computeReservation": {
                return Optional.ofNullable(clazz.cast(this.computeReservation()));
            }
            case "shareDistribution": {
                return Optional.ofNullable(clazz.cast(this.shareDistribution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shareDecaySeconds", SHARE_DECAY_SECONDS_FIELD);
        map.put("computeReservation", COMPUTE_RESERVATION_FIELD);
        map.put("shareDistribution", SHARE_DISTRIBUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FairsharePolicy, T> g) {
        return obj -> g.apply((FairsharePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer shareDecaySeconds;
        private Integer computeReservation;
        private List<ShareAttributes> shareDistribution = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FairsharePolicy model) {
            this.shareDecaySeconds(model.shareDecaySeconds);
            this.computeReservation(model.computeReservation);
            this.shareDistribution(model.shareDistribution);
        }

        public final Integer getShareDecaySeconds() {
            return this.shareDecaySeconds;
        }

        public final void setShareDecaySeconds(Integer shareDecaySeconds) {
            this.shareDecaySeconds = shareDecaySeconds;
        }

        @Override
        public final Builder shareDecaySeconds(Integer shareDecaySeconds) {
            this.shareDecaySeconds = shareDecaySeconds;
            return this;
        }

        public final Integer getComputeReservation() {
            return this.computeReservation;
        }

        public final void setComputeReservation(Integer computeReservation) {
            this.computeReservation = computeReservation;
        }

        @Override
        public final Builder computeReservation(Integer computeReservation) {
            this.computeReservation = computeReservation;
            return this;
        }

        public final List<ShareAttributes.Builder> getShareDistribution() {
            List<ShareAttributes.Builder> result = ShareAttributesListCopier.copyToBuilder(this.shareDistribution);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShareDistribution(Collection<ShareAttributes.BuilderImpl> shareDistribution) {
            this.shareDistribution = ShareAttributesListCopier.copyFromBuilder(shareDistribution);
        }

        @Override
        public final Builder shareDistribution(Collection<ShareAttributes> shareDistribution) {
            this.shareDistribution = ShareAttributesListCopier.copy(shareDistribution);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareDistribution(ShareAttributes ... shareDistribution) {
            this.shareDistribution(Arrays.asList(shareDistribution));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareDistribution(Consumer<ShareAttributes.Builder> ... shareDistribution) {
            this.shareDistribution(Stream.of(shareDistribution).map(c -> (ShareAttributes)((ShareAttributes.Builder)ShareAttributes.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FairsharePolicy build() {
            return new FairsharePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FairsharePolicy> {
        public Builder shareDecaySeconds(Integer var1);

        public Builder computeReservation(Integer var1);

        public Builder shareDistribution(Collection<ShareAttributes> var1);

        public Builder shareDistribution(ShareAttributes ... var1);

        public Builder shareDistribution(Consumer<ShareAttributes.Builder> ... var1);
    }
}

