/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileSummary;
import software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest;
import software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse;

public class ListInferenceProfilesPublisher
implements SdkPublisher<ListInferenceProfilesResponse> {
    private final BedrockAsyncClient client;
    private final ListInferenceProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInferenceProfilesPublisher(BedrockAsyncClient client, ListInferenceProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInferenceProfilesPublisher(BedrockAsyncClient client, ListInferenceProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInferenceProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInferenceProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InferenceProfileSummary> inferenceProfileSummaries() {
        Function<ListInferenceProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.inferenceProfileSummaries() != null) {
                return response.inferenceProfileSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInferenceProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInferenceProfilesResponseFetcher
    implements AsyncPageFetcher<ListInferenceProfilesResponse> {
        private ListInferenceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInferenceProfilesResponse> nextPage(ListInferenceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceProfilesPublisher.this.client.listInferenceProfiles(ListInferenceProfilesPublisher.this.firstRequest);
            }
            return ListInferenceProfilesPublisher.this.client.listInferenceProfiles((ListInferenceProfilesRequest)((Object)ListInferenceProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

