/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.EvaluationDatasetLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationDataset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationDataset> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EvaluationDataset.getter(EvaluationDataset::name)).setter(EvaluationDataset.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<EvaluationDatasetLocation> DATASET_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetLocation").getter(EvaluationDataset.getter(EvaluationDataset::datasetLocation)).setter(EvaluationDataset.setter(Builder::datasetLocation)).constructor(EvaluationDatasetLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATASET_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationDataset.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final EvaluationDatasetLocation datasetLocation;

    private EvaluationDataset(BuilderImpl builder) {
        this.name = builder.name;
        this.datasetLocation = builder.datasetLocation;
    }

    public final String name() {
        return this.name;
    }

    public final EvaluationDatasetLocation datasetLocation() {
        return this.datasetLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationDataset)) {
            return false;
        }
        EvaluationDataset other = (EvaluationDataset)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.datasetLocation(), other.datasetLocation());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationDataset").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("DatasetLocation", (Object)this.datasetLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "datasetLocation": {
                return Optional.ofNullable(clazz.cast(this.datasetLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("datasetLocation", DATASET_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationDataset, T> g) {
        return obj -> g.apply((EvaluationDataset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private EvaluationDatasetLocation datasetLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationDataset model) {
            this.name(model.name);
            this.datasetLocation(model.datasetLocation);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EvaluationDatasetLocation.Builder getDatasetLocation() {
            return this.datasetLocation != null ? this.datasetLocation.toBuilder() : null;
        }

        public final void setDatasetLocation(EvaluationDatasetLocation.BuilderImpl datasetLocation) {
            this.datasetLocation = datasetLocation != null ? datasetLocation.build() : null;
        }

        @Override
        public final Builder datasetLocation(EvaluationDatasetLocation datasetLocation) {
            this.datasetLocation = datasetLocation;
            return this;
        }

        public EvaluationDataset build() {
            return new EvaluationDataset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationDataset> {
        public Builder name(String var1);

        public Builder datasetLocation(EvaluationDatasetLocation var1);

        default public Builder datasetLocation(Consumer<EvaluationDatasetLocation.Builder> datasetLocation) {
            return this.datasetLocation((EvaluationDatasetLocation)((EvaluationDatasetLocation.Builder)EvaluationDatasetLocation.builder().applyMutation(datasetLocation)).build());
        }
    }
}

