/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for distilling a foundation model into a smaller and more efficient model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistillationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DistillationConfig.Builder, DistillationConfig> {
    private static final SdkField<TeacherModelConfig> TEACHER_MODEL_CONFIG_FIELD = SdkField
            .<TeacherModelConfig> builder(MarshallingType.SDK_POJO).memberName("teacherModelConfig")
            .getter(getter(DistillationConfig::teacherModelConfig)).setter(setter(Builder::teacherModelConfig))
            .constructor(TeacherModelConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teacherModelConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEACHER_MODEL_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TeacherModelConfig teacherModelConfig;

    private DistillationConfig(BuilderImpl builder) {
        this.teacherModelConfig = builder.teacherModelConfig;
    }

    /**
     * <p>
     * The teacher model configuration.
     * </p>
     * 
     * @return The teacher model configuration.
     */
    public final TeacherModelConfig teacherModelConfig() {
        return teacherModelConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(teacherModelConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistillationConfig)) {
            return false;
        }
        DistillationConfig other = (DistillationConfig) obj;
        return Objects.equals(teacherModelConfig(), other.teacherModelConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DistillationConfig").add("TeacherModelConfig", teacherModelConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "teacherModelConfig":
            return Optional.ofNullable(clazz.cast(teacherModelConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("teacherModelConfig", TEACHER_MODEL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistillationConfig, T> g) {
        return obj -> g.apply((DistillationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DistillationConfig> {
        /**
         * <p>
         * The teacher model configuration.
         * </p>
         * 
         * @param teacherModelConfig
         *        The teacher model configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teacherModelConfig(TeacherModelConfig teacherModelConfig);

        /**
         * <p>
         * The teacher model configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TeacherModelConfig.Builder} avoiding the
         * need to create one manually via {@link TeacherModelConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TeacherModelConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #teacherModelConfig(TeacherModelConfig)}.
         * 
         * @param teacherModelConfig
         *        a consumer that will call methods on {@link TeacherModelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teacherModelConfig(TeacherModelConfig)
         */
        default Builder teacherModelConfig(Consumer<TeacherModelConfig.Builder> teacherModelConfig) {
            return teacherModelConfig(TeacherModelConfig.builder().applyMutation(teacherModelConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TeacherModelConfig teacherModelConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DistillationConfig model) {
            teacherModelConfig(model.teacherModelConfig);
        }

        public final TeacherModelConfig.Builder getTeacherModelConfig() {
            return teacherModelConfig != null ? teacherModelConfig.toBuilder() : null;
        }

        public final void setTeacherModelConfig(TeacherModelConfig.BuilderImpl teacherModelConfig) {
            this.teacherModelConfig = teacherModelConfig != null ? teacherModelConfig.build() : null;
        }

        @Override
        public final Builder teacherModelConfig(TeacherModelConfig teacherModelConfig) {
            this.teacherModelConfig = teacherModelConfig;
            return this;
        }

        @Override
        public DistillationConfig build() {
            return new DistillationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
