/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelInvocationJobsRequest extends BedrockRequest implements
        ToCopyableBuilder<ListModelInvocationJobsRequest.Builder, ListModelInvocationJobsRequest> {
    private static final SdkField<Instant> SUBMIT_TIME_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("submitTimeAfter")
            .getter(getter(ListModelInvocationJobsRequest::submitTimeAfter))
            .setter(setter(Builder::submitTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("submitTimeAfter").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> SUBMIT_TIME_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("submitTimeBefore")
            .getter(getter(ListModelInvocationJobsRequest::submitTimeBefore))
            .setter(setter(Builder::submitTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("submitTimeBefore").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusEquals").getter(getter(ListModelInvocationJobsRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statusEquals").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nameContains").getter(getter(ListModelInvocationJobsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nameContains").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListModelInvocationJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListModelInvocationJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListModelInvocationJobsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListModelInvocationJobsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMIT_TIME_AFTER_FIELD,
            SUBMIT_TIME_BEFORE_FIELD, STATUS_EQUALS_FIELD, NAME_CONTAINS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD,
            SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant submitTimeAfter;

    private final Instant submitTimeBefore;

    private final String statusEquals;

    private final String nameContains;

    private final Integer maxResults;

    private final String nextToken;

    private final String sortBy;

    private final String sortOrder;

    private ListModelInvocationJobsRequest(BuilderImpl builder) {
        super(builder);
        this.submitTimeAfter = builder.submitTimeAfter;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.statusEquals = builder.statusEquals;
        this.nameContains = builder.nameContains;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Specify a time to filter for batch inference jobs that were submitted after the time you specify.
     * </p>
     * 
     * @return Specify a time to filter for batch inference jobs that were submitted after the time you specify.
     */
    public final Instant submitTimeAfter() {
        return submitTimeAfter;
    }

    /**
     * <p>
     * Specify a time to filter for batch inference jobs that were submitted before the time you specify.
     * </p>
     * 
     * @return Specify a time to filter for batch inference jobs that were submitted before the time you specify.
     */
    public final Instant submitTimeBefore() {
        return submitTimeBefore;
    }

    /**
     * <p>
     * Specify a status to filter for batch inference jobs whose statuses match the string you specify.
     * </p>
     * <p>
     * The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submitted – This job has been submitted to a queue for validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Validating – This job is being validated for the requirements described in <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload your
     * batch inference data</a>. The criteria include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Your IAM service role has access to the Amazon S3 buckets containing your files.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
     * validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your files fulfill the requirements for file size and number of records. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Scheduled – This job has been validated and is now in a queue. The job will automatically start when it reaches
     * its turn.
     * </p>
     * </li>
     * <li>
     * <p>
     * Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration. Submit a
     * new job request.
     * </p>
     * </li>
     * <li>
     * <p>
     * InProgress – This job has begun. You can start viewing the results in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed – This job has successfully completed. View the output files in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * PartiallyCompleted – This job has partially completed. Not all of your records could be processed in time. View
     * the output files in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – This job has failed. Check the failure message for any further details. For further assistance, reach
     * out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web Services Support Center</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stopped – This job was stopped by a user.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stopping – This job is being stopped by a user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ModelInvocationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Specify a status to filter for batch inference jobs whose statuses match the string you specify.</p>
     *         <p>
     *         The following statuses are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Submitted – This job has been submitted to a queue for validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Validating – This job is being validated for the requirements described in <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload
     *         your batch inference data</a>. The criteria include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your IAM service role has access to the Amazon S3 buckets containing your files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
     *         validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your files fulfill the requirements for file size and number of records. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Scheduled – This job has been validated and is now in a queue. The job will automatically start when it
     *         reaches its turn.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration.
     *         Submit a new job request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InProgress – This job has begun. You can start viewing the results in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed – This job has successfully completed. View the output files in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PartiallyCompleted – This job has partially completed. Not all of your records could be processed in
     *         time. View the output files in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – This job has failed. Check the failure message for any further details. For further assistance,
     *         reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web Services Support
     *         Center</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Stopped – This job was stopped by a user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Stopping – This job is being stopped by a user.
     *         </p>
     *         </li>
     * @see ModelInvocationJobStatus
     */
    public final ModelInvocationJobStatus statusEquals() {
        return ModelInvocationJobStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * Specify a status to filter for batch inference jobs whose statuses match the string you specify.
     * </p>
     * <p>
     * The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submitted – This job has been submitted to a queue for validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Validating – This job is being validated for the requirements described in <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload your
     * batch inference data</a>. The criteria include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Your IAM service role has access to the Amazon S3 buckets containing your files.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
     * validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your files fulfill the requirements for file size and number of records. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Scheduled – This job has been validated and is now in a queue. The job will automatically start when it reaches
     * its turn.
     * </p>
     * </li>
     * <li>
     * <p>
     * Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration. Submit a
     * new job request.
     * </p>
     * </li>
     * <li>
     * <p>
     * InProgress – This job has begun. You can start viewing the results in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed – This job has successfully completed. View the output files in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * PartiallyCompleted – This job has partially completed. Not all of your records could be processed in time. View
     * the output files in the output S3 location.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed – This job has failed. Check the failure message for any further details. For further assistance, reach
     * out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web Services Support Center</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stopped – This job was stopped by a user.
     * </p>
     * </li>
     * <li>
     * <p>
     * Stopping – This job is being stopped by a user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ModelInvocationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Specify a status to filter for batch inference jobs whose statuses match the string you specify.</p>
     *         <p>
     *         The following statuses are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Submitted – This job has been submitted to a queue for validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Validating – This job is being validated for the requirements described in <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload
     *         your batch inference data</a>. The criteria include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your IAM service role has access to the Amazon S3 buckets containing your files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
     *         validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your files fulfill the requirements for file size and number of records. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Scheduled – This job has been validated and is now in a queue. The job will automatically start when it
     *         reaches its turn.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration.
     *         Submit a new job request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InProgress – This job has begun. You can start viewing the results in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed – This job has successfully completed. View the output files in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PartiallyCompleted – This job has partially completed. Not all of your records could be processed in
     *         time. View the output files in the output S3 location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed – This job has failed. Check the failure message for any further details. For further assistance,
     *         reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web Services Support
     *         Center</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Stopped – This job was stopped by a user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Stopping – This job is being stopped by a user.
     *         </p>
     *         </li>
     * @see ModelInvocationJobStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * Specify a string to filter for batch inference jobs whose names contain the string.
     * </p>
     * 
     * @return Specify a string to filter for batch inference jobs whose names contain the string.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * The maximum number of results to return. If there are more results than the number that you specify, a
     * <code>nextToken</code> value is returned. Use the <code>nextToken</code> in a request to return the next batch of
     * results.
     * </p>
     * 
     * @return The maximum number of results to return. If there are more results than the number that you specify, a
     *         <code>nextToken</code> value is returned. Use the <code>nextToken</code> in a request to return the next
     *         batch of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If there were more results than the value you specified in the <code>maxResults</code> field in a previous
     * <code>ListModelInvocationJobs</code> request, the response would have returned a <code>nextToken</code> value. To
     * see the next batch of results, send the <code>nextToken</code> value in another request.
     * </p>
     * 
     * @return If there were more results than the value you specified in the <code>maxResults</code> field in a
     *         previous <code>ListModelInvocationJobs</code> request, the response would have returned a
     *         <code>nextToken</code> value. To see the next batch of results, send the <code>nextToken</code> value in
     *         another request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An attribute by which to sort the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortJobsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return An attribute by which to sort the results.
     * @see SortJobsBy
     */
    public final SortJobsBy sortBy() {
        return SortJobsBy.fromValue(sortBy);
    }

    /**
     * <p>
     * An attribute by which to sort the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortJobsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return An attribute by which to sort the results.
     * @see SortJobsBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Specifies whether to sort the results by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies whether to sort the results by ascending or descending order.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Specifies whether to sort the results by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies whether to sort the results by ascending or descending order.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelInvocationJobsRequest)) {
            return false;
        }
        ListModelInvocationJobsRequest other = (ListModelInvocationJobsRequest) obj;
        return Objects.equals(submitTimeAfter(), other.submitTimeAfter())
                && Objects.equals(submitTimeBefore(), other.submitTimeBefore())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(nameContains(), other.nameContains()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelInvocationJobsRequest").add("SubmitTimeAfter", submitTimeAfter())
                .add("SubmitTimeBefore", submitTimeBefore()).add("StatusEquals", statusEqualsAsString())
                .add("NameContains", nameContains()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "submitTimeAfter":
            return Optional.ofNullable(clazz.cast(submitTimeAfter()));
        case "submitTimeBefore":
            return Optional.ofNullable(clazz.cast(submitTimeBefore()));
        case "statusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "nameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("submitTimeAfter", SUBMIT_TIME_AFTER_FIELD);
        map.put("submitTimeBefore", SUBMIT_TIME_BEFORE_FIELD);
        map.put("statusEquals", STATUS_EQUALS_FIELD);
        map.put("nameContains", NAME_CONTAINS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelInvocationJobsRequest, T> g) {
        return obj -> g.apply((ListModelInvocationJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListModelInvocationJobsRequest> {
        /**
         * <p>
         * Specify a time to filter for batch inference jobs that were submitted after the time you specify.
         * </p>
         * 
         * @param submitTimeAfter
         *        Specify a time to filter for batch inference jobs that were submitted after the time you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeAfter(Instant submitTimeAfter);

        /**
         * <p>
         * Specify a time to filter for batch inference jobs that were submitted before the time you specify.
         * </p>
         * 
         * @param submitTimeBefore
         *        Specify a time to filter for batch inference jobs that were submitted before the time you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeBefore(Instant submitTimeBefore);

        /**
         * <p>
         * Specify a status to filter for batch inference jobs whose statuses match the string you specify.
         * </p>
         * <p>
         * The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Submitted – This job has been submitted to a queue for validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Validating – This job is being validated for the requirements described in <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload your
         * batch inference data</a>. The criteria include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Your IAM service role has access to the Amazon S3 buckets containing your files.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
         * validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your files fulfill the requirements for file size and number of records. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scheduled – This job has been validated and is now in a queue. The job will automatically start when it
         * reaches its turn.
         * </p>
         * </li>
         * <li>
         * <p>
         * Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration.
         * Submit a new job request.
         * </p>
         * </li>
         * <li>
         * <p>
         * InProgress – This job has begun. You can start viewing the results in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed – This job has successfully completed. View the output files in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * PartiallyCompleted – This job has partially completed. Not all of your records could be processed in time.
         * View the output files in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – This job has failed. Check the failure message for any further details. For further assistance,
         * reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web Services Support
         * Center</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopped – This job was stopped by a user.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopping – This job is being stopped by a user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusEquals
         *        Specify a status to filter for batch inference jobs whose statuses match the string you specify.</p>
         *        <p>
         *        The following statuses are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Submitted – This job has been submitted to a queue for validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Validating – This job is being validated for the requirements described in <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and
         *        upload your batch inference data</a>. The criteria include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Your IAM service role has access to the Amazon S3 buckets containing your files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your files are .jsonl files and each individual record is a JSON object in the correct format. Note
         *        that validation doesn't check if the <code>modelInput</code> value matches the request body for the
         *        model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your files fulfill the requirements for file size and number of records. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scheduled – This job has been validated and is now in a queue. The job will automatically start when
         *        it reaches its turn.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Expired – This job timed out because it was scheduled but didn't begin before the set timeout
         *        duration. Submit a new job request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InProgress – This job has begun. You can start viewing the results in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed – This job has successfully completed. View the output files in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PartiallyCompleted – This job has partially completed. Not all of your records could be processed in
         *        time. View the output files in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – This job has failed. Check the failure message for any further details. For further
         *        assistance, reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web
         *        Services Support Center</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopped – This job was stopped by a user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopping – This job is being stopped by a user.
         *        </p>
         *        </li>
         * @see ModelInvocationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelInvocationJobStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * Specify a status to filter for batch inference jobs whose statuses match the string you specify.
         * </p>
         * <p>
         * The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Submitted – This job has been submitted to a queue for validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Validating – This job is being validated for the requirements described in <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and upload your
         * batch inference data</a>. The criteria include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Your IAM service role has access to the Amazon S3 buckets containing your files.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your files are .jsonl files and each individual record is a JSON object in the correct format. Note that
         * validation doesn't check if the <code>modelInput</code> value matches the request body for the model.
         * </p>
         * </li>
         * <li>
         * <p>
         * Your files fulfill the requirements for file size and number of records. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scheduled – This job has been validated and is now in a queue. The job will automatically start when it
         * reaches its turn.
         * </p>
         * </li>
         * <li>
         * <p>
         * Expired – This job timed out because it was scheduled but didn't begin before the set timeout duration.
         * Submit a new job request.
         * </p>
         * </li>
         * <li>
         * <p>
         * InProgress – This job has begun. You can start viewing the results in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed – This job has successfully completed. View the output files in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * PartiallyCompleted – This job has partially completed. Not all of your records could be processed in time.
         * View the output files in the output S3 location.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed – This job has failed. Check the failure message for any further details. For further assistance,
         * reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web Services Support
         * Center</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopped – This job was stopped by a user.
         * </p>
         * </li>
         * <li>
         * <p>
         * Stopping – This job is being stopped by a user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusEquals
         *        Specify a status to filter for batch inference jobs whose statuses match the string you specify.</p>
         *        <p>
         *        The following statuses are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Submitted – This job has been submitted to a queue for validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Validating – This job is being validated for the requirements described in <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html">Format and
         *        upload your batch inference data</a>. The criteria include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Your IAM service role has access to the Amazon S3 buckets containing your files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your files are .jsonl files and each individual record is a JSON object in the correct format. Note
         *        that validation doesn't check if the <code>modelInput</code> value matches the request body for the
         *        model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Your files fulfill the requirements for file size and number of records. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html">Quotas for Amazon Bedrock</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scheduled – This job has been validated and is now in a queue. The job will automatically start when
         *        it reaches its turn.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Expired – This job timed out because it was scheduled but didn't begin before the set timeout
         *        duration. Submit a new job request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InProgress – This job has begun. You can start viewing the results in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed – This job has successfully completed. View the output files in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PartiallyCompleted – This job has partially completed. Not all of your records could be processed in
         *        time. View the output files in the output S3 location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed – This job has failed. Check the failure message for any further details. For further
         *        assistance, reach out to the <a href="https://console.aws.amazon.com/support/home/">Amazon Web
         *        Services Support Center</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopped – This job was stopped by a user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Stopping – This job is being stopped by a user.
         *        </p>
         *        </li>
         * @see ModelInvocationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelInvocationJobStatus
         */
        Builder statusEquals(ModelInvocationJobStatus statusEquals);

        /**
         * <p>
         * Specify a string to filter for batch inference jobs whose names contain the string.
         * </p>
         * 
         * @param nameContains
         *        Specify a string to filter for batch inference jobs whose names contain the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * The maximum number of results to return. If there are more results than the number that you specify, a
         * <code>nextToken</code> value is returned. Use the <code>nextToken</code> in a request to return the next
         * batch of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return. If there are more results than the number that you specify, a
         *        <code>nextToken</code> value is returned. Use the <code>nextToken</code> in a request to return the
         *        next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If there were more results than the value you specified in the <code>maxResults</code> field in a previous
         * <code>ListModelInvocationJobs</code> request, the response would have returned a <code>nextToken</code>
         * value. To see the next batch of results, send the <code>nextToken</code> value in another request.
         * </p>
         * 
         * @param nextToken
         *        If there were more results than the value you specified in the <code>maxResults</code> field in a
         *        previous <code>ListModelInvocationJobs</code> request, the response would have returned a
         *        <code>nextToken</code> value. To see the next batch of results, send the <code>nextToken</code> value
         *        in another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An attribute by which to sort the results.
         * </p>
         * 
         * @param sortBy
         *        An attribute by which to sort the results.
         * @see SortJobsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortJobsBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * An attribute by which to sort the results.
         * </p>
         * 
         * @param sortBy
         *        An attribute by which to sort the results.
         * @see SortJobsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortJobsBy
         */
        Builder sortBy(SortJobsBy sortBy);

        /**
         * <p>
         * Specifies whether to sort the results by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Specifies whether to sort the results by ascending or descending order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Specifies whether to sort the results by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Specifies whether to sort the results by ascending or descending order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private Instant submitTimeAfter;

        private Instant submitTimeBefore;

        private String statusEquals;

        private String nameContains;

        private Integer maxResults;

        private String nextToken;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelInvocationJobsRequest model) {
            super(model);
            submitTimeAfter(model.submitTimeAfter);
            submitTimeBefore(model.submitTimeBefore);
            statusEquals(model.statusEquals);
            nameContains(model.nameContains);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final Instant getSubmitTimeAfter() {
            return submitTimeAfter;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        @Override
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        public final Instant getSubmitTimeBefore() {
            return submitTimeBefore;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        @Override
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(ModelInvocationJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortJobsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelInvocationJobsRequest build() {
            return new ListModelInvocationJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
