/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInferenceProfileResponse extends BedrockResponse implements
        ToCopyableBuilder<CreateInferenceProfileResponse.Builder, CreateInferenceProfileResponse> {
    private static final SdkField<String> INFERENCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inferenceProfileArn").getter(getter(CreateInferenceProfileResponse::inferenceProfileArn))
            .setter(setter(Builder::inferenceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateInferenceProfileResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_PROFILE_ARN_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String inferenceProfileArn;

    private final String status;

    private CreateInferenceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceProfileArn = builder.inferenceProfileArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the inference profile that you created.
     * </p>
     * 
     * @return The ARN of the inference profile that you created.
     */
    public final String inferenceProfileArn() {
        return inferenceProfileArn;
    }

    /**
     * <p>
     * The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be
     *         used.
     * @see InferenceProfileStatus
     */
    public final InferenceProfileStatus status() {
        return InferenceProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be
     *         used.
     * @see InferenceProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceProfileResponse)) {
            return false;
        }
        CreateInferenceProfileResponse other = (CreateInferenceProfileResponse) obj;
        return Objects.equals(inferenceProfileArn(), other.inferenceProfileArn())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInferenceProfileResponse").add("InferenceProfileArn", inferenceProfileArn())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inferenceProfileArn":
            return Optional.ofNullable(clazz.cast(inferenceProfileArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inferenceProfileArn", INFERENCE_PROFILE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceProfileResponse, T> g) {
        return obj -> g.apply((CreateInferenceProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateInferenceProfileResponse> {
        /**
         * <p>
         * The ARN of the inference profile that you created.
         * </p>
         * 
         * @param inferenceProfileArn
         *        The ARN of the inference profile that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceProfileArn(String inferenceProfileArn);

        /**
         * <p>
         * The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be
         * used.
         * </p>
         * 
         * @param status
         *        The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to
         *        be used.
         * @see InferenceProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to be
         * used.
         * </p>
         * 
         * @param status
         *        The status of the inference profile. <code>ACTIVE</code> means that the inference profile is ready to
         *        be used.
         * @see InferenceProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceProfileStatus
         */
        Builder status(InferenceProfileStatus status);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String inferenceProfileArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceProfileResponse model) {
            super(model);
            inferenceProfileArn(model.inferenceProfileArn);
            status(model.status);
        }

        public final String getInferenceProfileArn() {
            return inferenceProfileArn;
        }

        public final void setInferenceProfileArn(String inferenceProfileArn) {
            this.inferenceProfileArn = inferenceProfileArn;
        }

        @Override
        public final Builder inferenceProfileArn(String inferenceProfileArn) {
            this.inferenceProfileArn = inferenceProfileArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateInferenceProfileResponse build() {
            return new CreateInferenceProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
