/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of either an automated or human-based evaluation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationConfig.Builder, EvaluationConfig> {
    private static final SdkField<AutomatedEvaluationConfig> AUTOMATED_FIELD = SdkField
            .<AutomatedEvaluationConfig> builder(MarshallingType.SDK_POJO).memberName("automated")
            .getter(getter(EvaluationConfig::automated)).setter(setter(Builder::automated))
            .constructor(AutomatedEvaluationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automated").build()).build();

    private static final SdkField<HumanEvaluationConfig> HUMAN_FIELD = SdkField
            .<HumanEvaluationConfig> builder(MarshallingType.SDK_POJO).memberName("human")
            .getter(getter(EvaluationConfig::human)).setter(setter(Builder::human)).constructor(HumanEvaluationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("human").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATED_FIELD, HUMAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedEvaluationConfig automated;

    private final HumanEvaluationConfig human;

    private final Type type;

    private EvaluationConfig(BuilderImpl builder) {
        this.automated = builder.automated;
        this.human = builder.human;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains the configuration details of an automated evaluation job that computes metrics.
     * </p>
     * 
     * @return Contains the configuration details of an automated evaluation job that computes metrics.
     */
    public final AutomatedEvaluationConfig automated() {
        return automated;
    }

    /**
     * <p>
     * Contains the configuration details of an evaluation job that uses human workers.
     * </p>
     * 
     * @return Contains the configuration details of an evaluation job that uses human workers.
     */
    public final HumanEvaluationConfig human() {
        return human;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automated());
        hashCode = 31 * hashCode + Objects.hashCode(human());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationConfig)) {
            return false;
        }
        EvaluationConfig other = (EvaluationConfig) obj;
        return Objects.equals(automated(), other.automated()) && Objects.equals(human(), other.human());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationConfig").add("Automated", automated()).add("Human", human()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "automated":
            return Optional.ofNullable(clazz.cast(automated()));
        case "human":
            return Optional.ofNullable(clazz.cast(human()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #automated()} initialized to the given value.
     *
     * <p>
     * Contains the configuration details of an automated evaluation job that computes metrics.
     * </p>
     * 
     * @param automated
     *        Contains the configuration details of an automated evaluation job that computes metrics.
     */
    public static EvaluationConfig fromAutomated(AutomatedEvaluationConfig automated) {
        return builder().automated(automated).build();
    }

    /**
     * Create an instance of this class with {@link #automated()} initialized to the given value.
     *
     * <p>
     * Contains the configuration details of an automated evaluation job that computes metrics.
     * </p>
     * 
     * @param automated
     *        Contains the configuration details of an automated evaluation job that computes metrics.
     */
    public static EvaluationConfig fromAutomated(Consumer<AutomatedEvaluationConfig.Builder> automated) {
        AutomatedEvaluationConfig.Builder builder = AutomatedEvaluationConfig.builder();
        automated.accept(builder);
        return fromAutomated(builder.build());
    }

    /**
     * Create an instance of this class with {@link #human()} initialized to the given value.
     *
     * <p>
     * Contains the configuration details of an evaluation job that uses human workers.
     * </p>
     * 
     * @param human
     *        Contains the configuration details of an evaluation job that uses human workers.
     */
    public static EvaluationConfig fromHuman(HumanEvaluationConfig human) {
        return builder().human(human).build();
    }

    /**
     * Create an instance of this class with {@link #human()} initialized to the given value.
     *
     * <p>
     * Contains the configuration details of an evaluation job that uses human workers.
     * </p>
     * 
     * @param human
     *        Contains the configuration details of an evaluation job that uses human workers.
     */
    public static EvaluationConfig fromHuman(Consumer<HumanEvaluationConfig.Builder> human) {
        HumanEvaluationConfig.Builder builder = HumanEvaluationConfig.builder();
        human.accept(builder);
        return fromHuman(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("automated", AUTOMATED_FIELD);
        map.put("human", HUMAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationConfig, T> g) {
        return obj -> g.apply((EvaluationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationConfig> {
        /**
         * <p>
         * Contains the configuration details of an automated evaluation job that computes metrics.
         * </p>
         * 
         * @param automated
         *        Contains the configuration details of an automated evaluation job that computes metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automated(AutomatedEvaluationConfig automated);

        /**
         * <p>
         * Contains the configuration details of an automated evaluation job that computes metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedEvaluationConfig.Builder}
         * avoiding the need to create one manually via {@link AutomatedEvaluationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedEvaluationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #automated(AutomatedEvaluationConfig)}.
         * 
         * @param automated
         *        a consumer that will call methods on {@link AutomatedEvaluationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automated(AutomatedEvaluationConfig)
         */
        default Builder automated(Consumer<AutomatedEvaluationConfig.Builder> automated) {
            return automated(AutomatedEvaluationConfig.builder().applyMutation(automated).build());
        }

        /**
         * <p>
         * Contains the configuration details of an evaluation job that uses human workers.
         * </p>
         * 
         * @param human
         *        Contains the configuration details of an evaluation job that uses human workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder human(HumanEvaluationConfig human);

        /**
         * <p>
         * Contains the configuration details of an evaluation job that uses human workers.
         * </p>
         * This is a convenience method that creates an instance of the {@link HumanEvaluationConfig.Builder} avoiding
         * the need to create one manually via {@link HumanEvaluationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HumanEvaluationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #human(HumanEvaluationConfig)}.
         * 
         * @param human
         *        a consumer that will call methods on {@link HumanEvaluationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #human(HumanEvaluationConfig)
         */
        default Builder human(Consumer<HumanEvaluationConfig.Builder> human) {
            return human(HumanEvaluationConfig.builder().applyMutation(human).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedEvaluationConfig automated;

        private HumanEvaluationConfig human;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationConfig model) {
            automated(model.automated);
            human(model.human);
        }

        public final AutomatedEvaluationConfig.Builder getAutomated() {
            return automated != null ? automated.toBuilder() : null;
        }

        public final void setAutomated(AutomatedEvaluationConfig.BuilderImpl automated) {
            Object oldValue = this.automated;
            this.automated = automated != null ? automated.build() : null;
            handleUnionValueChange(Type.AUTOMATED, oldValue, this.automated);
        }

        @Override
        public final Builder automated(AutomatedEvaluationConfig automated) {
            Object oldValue = this.automated;
            this.automated = automated;
            handleUnionValueChange(Type.AUTOMATED, oldValue, this.automated);
            return this;
        }

        public final HumanEvaluationConfig.Builder getHuman() {
            return human != null ? human.toBuilder() : null;
        }

        public final void setHuman(HumanEvaluationConfig.BuilderImpl human) {
            Object oldValue = this.human;
            this.human = human != null ? human.build() : null;
            handleUnionValueChange(Type.HUMAN, oldValue, this.human);
        }

        @Override
        public final Builder human(HumanEvaluationConfig human) {
            Object oldValue = this.human;
            this.human = human;
            handleUnionValueChange(Type.HUMAN, oldValue, this.human);
            return this;
        }

        @Override
        public EvaluationConfig build() {
            return new EvaluationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationConfig#type()
     */
    public enum Type {
        AUTOMATED,

        HUMAN,

        UNKNOWN_TO_SDK_VERSION
    }
}
