/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Rules for filtering invocation logs. A filter can be a mapping of a metadata key to a value that it should or should
 * not equal (a base filter), or a list of base filters that are all applied with <code>AND</code> or <code>OR</code>
 * logical operators
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestMetadataFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestMetadataFilters.Builder, RequestMetadataFilters> {
    private static final SdkField<Map<String, String>> EQUALS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("equals")
            .getter(getter(RequestMetadataFilters::equalsValue))
            .setter(setter(Builder::equalsValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> NOT_EQUALS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("notEquals")
            .getter(getter(RequestMetadataFilters::notEquals))
            .setter(setter(Builder::notEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<RequestMetadataBaseFilters>> AND_ALL_FIELD = SdkField
            .<List<RequestMetadataBaseFilters>> builder(MarshallingType.LIST)
            .memberName("andAll")
            .getter(getter(RequestMetadataFilters::andAll))
            .setter(setter(Builder::andAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequestMetadataBaseFilters> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestMetadataBaseFilters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RequestMetadataBaseFilters>> OR_ALL_FIELD = SdkField
            .<List<RequestMetadataBaseFilters>> builder(MarshallingType.LIST)
            .memberName("orAll")
            .getter(getter(RequestMetadataFilters::orAll))
            .setter(setter(Builder::orAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orAll").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequestMetadataBaseFilters> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestMetadataBaseFilters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUALS_FIELD,
            NOT_EQUALS_FIELD, AND_ALL_FIELD, OR_ALL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> equalsValue;

    private final Map<String, String> notEquals;

    private final List<RequestMetadataBaseFilters> andAll;

    private final List<RequestMetadataBaseFilters> orAll;

    private final Type type;

    private RequestMetadataFilters(BuilderImpl builder) {
        this.equalsValue = builder.equalsValue;
        this.notEquals = builder.notEquals;
        this.andAll = builder.andAll;
        this.orAll = builder.orAll;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Equals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEqualsValue() {
        return equalsValue != null && !(equalsValue instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Include results where the key equals the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEqualsValue} method.
     * </p>
     * 
     * @return Include results where the key equals the value.
     */
    public final Map<String, String> equalsValue() {
        return equalsValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotEquals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotEquals() {
        return notEquals != null && !(notEquals instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Include results where the key does not equal the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotEquals} method.
     * </p>
     * 
     * @return Include results where the key does not equal the value.
     */
    public final Map<String, String> notEquals() {
        return notEquals;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndAll property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAndAll() {
        return andAll != null && !(andAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Include results where all of the based filters match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndAll} method.
     * </p>
     * 
     * @return Include results where all of the based filters match.
     */
    public final List<RequestMetadataBaseFilters> andAll() {
        return andAll;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrAll property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOrAll() {
        return orAll != null && !(orAll instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Include results where any of the base filters match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrAll} method.
     * </p>
     * 
     * @return Include results where any of the base filters match.
     */
    public final List<RequestMetadataBaseFilters> orAll() {
        return orAll;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEqualsValue() ? equalsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotEquals() ? notEquals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAndAll() ? andAll() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrAll() ? orAll() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestMetadataFilters)) {
            return false;
        }
        RequestMetadataFilters other = (RequestMetadataFilters) obj;
        return hasEqualsValue() == other.hasEqualsValue() && Objects.equals(equalsValue(), other.equalsValue())
                && hasNotEquals() == other.hasNotEquals() && Objects.equals(notEquals(), other.notEquals())
                && hasAndAll() == other.hasAndAll() && Objects.equals(andAll(), other.andAll()) && hasOrAll() == other.hasOrAll()
                && Objects.equals(orAll(), other.orAll());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestMetadataFilters")
                .add("Equals", equalsValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NotEquals", notEquals() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AndAll", hasAndAll() ? andAll() : null).add("OrAll", hasOrAll() ? orAll() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "equals":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        case "notEquals":
            return Optional.ofNullable(clazz.cast(notEquals()));
        case "andAll":
            return Optional.ofNullable(clazz.cast(andAll()));
        case "orAll":
            return Optional.ofNullable(clazz.cast(orAll()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #equalsValue()} initialized to the given value.
     *
     * <p>
     * Include results where the key equals the value.
     * </p>
     * 
     * @param equalsValue
     *        Include results where the key equals the value.
     */
    public static RequestMetadataFilters fromEqualsValue(Map<String, String> equalsValue) {
        return builder().equalsValue(equalsValue).build();
    }

    /**
     * Create an instance of this class with {@link #notEquals()} initialized to the given value.
     *
     * <p>
     * Include results where the key does not equal the value.
     * </p>
     * 
     * @param notEquals
     *        Include results where the key does not equal the value.
     */
    public static RequestMetadataFilters fromNotEquals(Map<String, String> notEquals) {
        return builder().notEquals(notEquals).build();
    }

    /**
     * Create an instance of this class with {@link #andAll()} initialized to the given value.
     *
     * <p>
     * Include results where all of the based filters match.
     * </p>
     * 
     * @param andAll
     *        Include results where all of the based filters match.
     */
    public static RequestMetadataFilters fromAndAll(List<RequestMetadataBaseFilters> andAll) {
        return builder().andAll(andAll).build();
    }

    /**
     * Create an instance of this class with {@link #orAll()} initialized to the given value.
     *
     * <p>
     * Include results where any of the base filters match.
     * </p>
     * 
     * @param orAll
     *        Include results where any of the base filters match.
     */
    public static RequestMetadataFilters fromOrAll(List<RequestMetadataBaseFilters> orAll) {
        return builder().orAll(orAll).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("equals", EQUALS_FIELD);
        map.put("notEquals", NOT_EQUALS_FIELD);
        map.put("andAll", AND_ALL_FIELD);
        map.put("orAll", OR_ALL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestMetadataFilters, T> g) {
        return obj -> g.apply((RequestMetadataFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestMetadataFilters> {
        /**
         * <p>
         * Include results where the key equals the value.
         * </p>
         * 
         * @param equalsValue
         *        Include results where the key equals the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(Map<String, String> equalsValue);

        /**
         * <p>
         * Include results where the key does not equal the value.
         * </p>
         * 
         * @param notEquals
         *        Include results where the key does not equal the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(Map<String, String> notEquals);

        /**
         * <p>
         * Include results where all of the based filters match.
         * </p>
         * 
         * @param andAll
         *        Include results where all of the based filters match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(Collection<RequestMetadataBaseFilters> andAll);

        /**
         * <p>
         * Include results where all of the based filters match.
         * </p>
         * 
         * @param andAll
         *        Include results where all of the based filters match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAll(RequestMetadataBaseFilters... andAll);

        /**
         * <p>
         * Include results where all of the based filters match.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.RequestMetadataBaseFilters.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.RequestMetadataBaseFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.RequestMetadataBaseFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #andAll(List<RequestMetadataBaseFilters>)}.
         * 
         * @param andAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.RequestMetadataBaseFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andAll(java.util.Collection<RequestMetadataBaseFilters>)
         */
        Builder andAll(Consumer<RequestMetadataBaseFilters.Builder>... andAll);

        /**
         * <p>
         * Include results where any of the base filters match.
         * </p>
         * 
         * @param orAll
         *        Include results where any of the base filters match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(Collection<RequestMetadataBaseFilters> orAll);

        /**
         * <p>
         * Include results where any of the base filters match.
         * </p>
         * 
         * @param orAll
         *        Include results where any of the base filters match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAll(RequestMetadataBaseFilters... orAll);

        /**
         * <p>
         * Include results where any of the base filters match.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.RequestMetadataBaseFilters.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.RequestMetadataBaseFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.RequestMetadataBaseFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #orAll(List<RequestMetadataBaseFilters>)}.
         * 
         * @param orAll
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.RequestMetadataBaseFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orAll(java.util.Collection<RequestMetadataBaseFilters>)
         */
        Builder orAll(Consumer<RequestMetadataBaseFilters.Builder>... orAll);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> equalsValue = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> notEquals = DefaultSdkAutoConstructMap.getInstance();

        private List<RequestMetadataBaseFilters> andAll = DefaultSdkAutoConstructList.getInstance();

        private List<RequestMetadataBaseFilters> orAll = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RequestMetadataFilters model) {
            equalsValue(model.equalsValue);
            notEquals(model.notEquals);
            andAll(model.andAll);
            orAll(model.orAll);
        }

        public final Map<String, String> getEqualsValue() {
            if (equalsValue instanceof SdkAutoConstructMap) {
                return null;
            }
            return equalsValue;
        }

        public final void setEqualsValue(Map<String, String> equalsValue) {
            Object oldValue = this.equalsValue;
            this.equalsValue = RequestMetadataMapCopier.copy(equalsValue);
            handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
        }

        @Override
        public final Builder equalsValue(Map<String, String> equalsValue) {
            Object oldValue = this.equalsValue;
            this.equalsValue = RequestMetadataMapCopier.copy(equalsValue);
            handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
            return this;
        }

        public final Map<String, String> getNotEquals() {
            if (notEquals instanceof SdkAutoConstructMap) {
                return null;
            }
            return notEquals;
        }

        public final void setNotEquals(Map<String, String> notEquals) {
            Object oldValue = this.notEquals;
            this.notEquals = RequestMetadataMapCopier.copy(notEquals);
            handleUnionValueChange(Type.NOT_EQUALS, oldValue, this.notEquals);
        }

        @Override
        public final Builder notEquals(Map<String, String> notEquals) {
            Object oldValue = this.notEquals;
            this.notEquals = RequestMetadataMapCopier.copy(notEquals);
            handleUnionValueChange(Type.NOT_EQUALS, oldValue, this.notEquals);
            return this;
        }

        public final List<RequestMetadataBaseFilters.Builder> getAndAll() {
            List<RequestMetadataBaseFilters.Builder> result = RequestMetadataFiltersListCopier.copyToBuilder(this.andAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndAll(Collection<RequestMetadataBaseFilters.BuilderImpl> andAll) {
            Object oldValue = this.andAll;
            this.andAll = RequestMetadataFiltersListCopier.copyFromBuilder(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
        }

        @Override
        public final Builder andAll(Collection<RequestMetadataBaseFilters> andAll) {
            Object oldValue = this.andAll;
            this.andAll = RequestMetadataFiltersListCopier.copy(andAll);
            handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(RequestMetadataBaseFilters... andAll) {
            andAll(Arrays.asList(andAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(Consumer<RequestMetadataBaseFilters.Builder>... andAll) {
            andAll(Stream.of(andAll).map(c -> RequestMetadataBaseFilters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RequestMetadataBaseFilters.Builder> getOrAll() {
            List<RequestMetadataBaseFilters.Builder> result = RequestMetadataFiltersListCopier.copyToBuilder(this.orAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrAll(Collection<RequestMetadataBaseFilters.BuilderImpl> orAll) {
            Object oldValue = this.orAll;
            this.orAll = RequestMetadataFiltersListCopier.copyFromBuilder(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
        }

        @Override
        public final Builder orAll(Collection<RequestMetadataBaseFilters> orAll) {
            Object oldValue = this.orAll;
            this.orAll = RequestMetadataFiltersListCopier.copy(orAll);
            handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(RequestMetadataBaseFilters... orAll) {
            orAll(Arrays.asList(orAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(Consumer<RequestMetadataBaseFilters.Builder>... orAll) {
            orAll(Stream.of(orAll).map(c -> RequestMetadataBaseFilters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RequestMetadataFilters build() {
            return new RequestMetadataFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RequestMetadataFilters#type()
     */
    public enum Type {
        EQUALS,

        NOT_EQUALS,

        AND_ALL,

        OR_ALL,

        UNKNOWN_TO_SDK_VERSION
    }
}
