/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGuardrailResponse extends BedrockResponse implements
        ToCopyableBuilder<UpdateGuardrailResponse.Builder, UpdateGuardrailResponse> {
    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailId").getter(getter(UpdateGuardrailResponse::guardrailId)).setter(setter(Builder::guardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()).build();

    private static final SdkField<String> GUARDRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailArn").getter(getter(UpdateGuardrailResponse::guardrailArn))
            .setter(setter(Builder::guardrailArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailArn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(UpdateGuardrailResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(UpdateGuardrailResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_ID_FIELD,
            GUARDRAIL_ARN_FIELD, VERSION_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String guardrailId;

    private final String guardrailArn;

    private final String version;

    private final Instant updatedAt;

    private UpdateGuardrailResponse(BuilderImpl builder) {
        super(builder);
        this.guardrailId = builder.guardrailId;
        this.guardrailArn = builder.guardrailArn;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The unique identifier of the guardrail
     * </p>
     * 
     * @return The unique identifier of the guardrail
     */
    public final String guardrailId() {
        return guardrailId;
    }

    /**
     * <p>
     * The ARN of the guardrail.
     * </p>
     * 
     * @return The ARN of the guardrail.
     */
    public final String guardrailArn() {
        return guardrailArn;
    }

    /**
     * <p>
     * The version of the guardrail.
     * </p>
     * 
     * @return The version of the guardrail.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The date and time at which the guardrail was updated.
     * </p>
     * 
     * @return The date and time at which the guardrail was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGuardrailResponse)) {
            return false;
        }
        UpdateGuardrailResponse other = (UpdateGuardrailResponse) obj;
        return Objects.equals(guardrailId(), other.guardrailId()) && Objects.equals(guardrailArn(), other.guardrailArn())
                && Objects.equals(version(), other.version()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGuardrailResponse").add("GuardrailId", guardrailId()).add("GuardrailArn", guardrailArn())
                .add("Version", version()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailId":
            return Optional.ofNullable(clazz.cast(guardrailId()));
        case "guardrailArn":
            return Optional.ofNullable(clazz.cast(guardrailArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guardrailId", GUARDRAIL_ID_FIELD);
        map.put("guardrailArn", GUARDRAIL_ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGuardrailResponse, T> g) {
        return obj -> g.apply((UpdateGuardrailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGuardrailResponse> {
        /**
         * <p>
         * The unique identifier of the guardrail
         * </p>
         * 
         * @param guardrailId
         *        The unique identifier of the guardrail
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailId(String guardrailId);

        /**
         * <p>
         * The ARN of the guardrail.
         * </p>
         * 
         * @param guardrailArn
         *        The ARN of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailArn(String guardrailArn);

        /**
         * <p>
         * The version of the guardrail.
         * </p>
         * 
         * @param version
         *        The version of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The date and time at which the guardrail was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time at which the guardrail was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String guardrailId;

        private String guardrailArn;

        private String version;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGuardrailResponse model) {
            super(model);
            guardrailId(model.guardrailId);
            guardrailArn(model.guardrailArn);
            version(model.version);
            updatedAt(model.updatedAt);
        }

        public final String getGuardrailId() {
            return guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getGuardrailArn() {
            return guardrailArn;
        }

        public final void setGuardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
        }

        @Override
        public final Builder guardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public UpdateGuardrailResponse build() {
            return new UpdateGuardrailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
