/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.EndpointConfig;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMarketplaceModelEndpointRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateMarketplaceModelEndpointRequest> {
    private static final SdkField<String> MODEL_SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelSourceIdentifier").getter(CreateMarketplaceModelEndpointRequest.getter(CreateMarketplaceModelEndpointRequest::modelSourceIdentifier)).setter(CreateMarketplaceModelEndpointRequest.setter(Builder::modelSourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSourceIdentifier").build()}).build();
    private static final SdkField<EndpointConfig> ENDPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpointConfig").getter(CreateMarketplaceModelEndpointRequest.getter(CreateMarketplaceModelEndpointRequest::endpointConfig)).setter(CreateMarketplaceModelEndpointRequest.setter(Builder::endpointConfig)).constructor(EndpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfig").build()}).build();
    private static final SdkField<Boolean> ACCEPT_EULA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("acceptEula").getter(CreateMarketplaceModelEndpointRequest.getter(CreateMarketplaceModelEndpointRequest::acceptEula)).setter(CreateMarketplaceModelEndpointRequest.setter(Builder::acceptEula)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptEula").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointName").getter(CreateMarketplaceModelEndpointRequest.getter(CreateMarketplaceModelEndpointRequest::endpointName)).setter(CreateMarketplaceModelEndpointRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointName").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateMarketplaceModelEndpointRequest.getter(CreateMarketplaceModelEndpointRequest::clientRequestToken)).setter(CreateMarketplaceModelEndpointRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateMarketplaceModelEndpointRequest.getter(CreateMarketplaceModelEndpointRequest::tags)).setter(CreateMarketplaceModelEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_SOURCE_IDENTIFIER_FIELD, ENDPOINT_CONFIG_FIELD, ACCEPT_EULA_FIELD, ENDPOINT_NAME_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMarketplaceModelEndpointRequest.memberNameToFieldInitializer();
    private final String modelSourceIdentifier;
    private final EndpointConfig endpointConfig;
    private final Boolean acceptEula;
    private final String endpointName;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateMarketplaceModelEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.modelSourceIdentifier = builder.modelSourceIdentifier;
        this.endpointConfig = builder.endpointConfig;
        this.acceptEula = builder.acceptEula;
        this.endpointName = builder.endpointName;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final String modelSourceIdentifier() {
        return this.modelSourceIdentifier;
    }

    public final EndpointConfig endpointConfig() {
        return this.endpointConfig;
    }

    public final Boolean acceptEula() {
        return this.acceptEula;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptEula());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMarketplaceModelEndpointRequest)) {
            return false;
        }
        CreateMarketplaceModelEndpointRequest other = (CreateMarketplaceModelEndpointRequest)((Object)obj);
        return Objects.equals(this.modelSourceIdentifier(), other.modelSourceIdentifier()) && Objects.equals(this.endpointConfig(), other.endpointConfig()) && Objects.equals(this.acceptEula(), other.acceptEula()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMarketplaceModelEndpointRequest").add("ModelSourceIdentifier", (Object)this.modelSourceIdentifier()).add("EndpointConfig", (Object)this.endpointConfig()).add("AcceptEula", (Object)this.acceptEula()).add("EndpointName", (Object)this.endpointName()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelSourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.modelSourceIdentifier()));
            }
            case "endpointConfig": {
                return Optional.ofNullable(clazz.cast(this.endpointConfig()));
            }
            case "acceptEula": {
                return Optional.ofNullable(clazz.cast(this.acceptEula()));
            }
            case "endpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelSourceIdentifier", MODEL_SOURCE_IDENTIFIER_FIELD);
        map.put("endpointConfig", ENDPOINT_CONFIG_FIELD);
        map.put("acceptEula", ACCEPT_EULA_FIELD);
        map.put("endpointName", ENDPOINT_NAME_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMarketplaceModelEndpointRequest, T> g) {
        return obj -> g.apply((CreateMarketplaceModelEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String modelSourceIdentifier;
        private EndpointConfig endpointConfig;
        private Boolean acceptEula;
        private String endpointName;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMarketplaceModelEndpointRequest model) {
            super(model);
            this.modelSourceIdentifier(model.modelSourceIdentifier);
            this.endpointConfig(model.endpointConfig);
            this.acceptEula(model.acceptEula);
            this.endpointName(model.endpointName);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getModelSourceIdentifier() {
            return this.modelSourceIdentifier;
        }

        public final void setModelSourceIdentifier(String modelSourceIdentifier) {
            this.modelSourceIdentifier = modelSourceIdentifier;
        }

        @Override
        public final Builder modelSourceIdentifier(String modelSourceIdentifier) {
            this.modelSourceIdentifier = modelSourceIdentifier;
            return this;
        }

        public final EndpointConfig.Builder getEndpointConfig() {
            return this.endpointConfig != null ? this.endpointConfig.toBuilder() : null;
        }

        public final void setEndpointConfig(EndpointConfig.BuilderImpl endpointConfig) {
            this.endpointConfig = endpointConfig != null ? endpointConfig.build() : null;
        }

        @Override
        public final Builder endpointConfig(EndpointConfig endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        public final Boolean getAcceptEula() {
            return this.acceptEula;
        }

        public final void setAcceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
        }

        @Override
        public final Builder acceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMarketplaceModelEndpointRequest build() {
            return new CreateMarketplaceModelEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMarketplaceModelEndpointRequest> {
        public Builder modelSourceIdentifier(String var1);

        public Builder endpointConfig(EndpointConfig var1);

        default public Builder endpointConfig(Consumer<EndpointConfig.Builder> endpointConfig) {
            return this.endpointConfig((EndpointConfig)((EndpointConfig.Builder)EndpointConfig.builder().applyMutation(endpointConfig)).build());
        }

        public Builder acceptEula(Boolean var1);

        public Builder endpointName(String var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

