/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProvisionedModelThroughputRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, UpdateProvisionedModelThroughputRequest> {
    private static final SdkField<String> PROVISIONED_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisionedModelId").getter(UpdateProvisionedModelThroughputRequest.getter(UpdateProvisionedModelThroughputRequest::provisionedModelId)).setter(UpdateProvisionedModelThroughputRequest.setter(Builder::provisionedModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("provisionedModelId").build()}).build();
    private static final SdkField<String> DESIRED_PROVISIONED_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredProvisionedModelName").getter(UpdateProvisionedModelThroughputRequest.getter(UpdateProvisionedModelThroughputRequest::desiredProvisionedModelName)).setter(UpdateProvisionedModelThroughputRequest.setter(Builder::desiredProvisionedModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredProvisionedModelName").build()}).build();
    private static final SdkField<String> DESIRED_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredModelId").getter(UpdateProvisionedModelThroughputRequest.getter(UpdateProvisionedModelThroughputRequest::desiredModelId)).setter(UpdateProvisionedModelThroughputRequest.setter(Builder::desiredModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredModelId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_MODEL_ID_FIELD, DESIRED_PROVISIONED_MODEL_NAME_FIELD, DESIRED_MODEL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProvisionedModelThroughputRequest.memberNameToFieldInitializer();
    private final String provisionedModelId;
    private final String desiredProvisionedModelName;
    private final String desiredModelId;

    private UpdateProvisionedModelThroughputRequest(BuilderImpl builder) {
        super(builder);
        this.provisionedModelId = builder.provisionedModelId;
        this.desiredProvisionedModelName = builder.desiredProvisionedModelName;
        this.desiredModelId = builder.desiredModelId;
    }

    public final String provisionedModelId() {
        return this.provisionedModelId;
    }

    public final String desiredProvisionedModelName() {
        return this.desiredProvisionedModelName;
    }

    public final String desiredModelId() {
        return this.desiredModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredProvisionedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredModelId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedModelThroughputRequest)) {
            return false;
        }
        UpdateProvisionedModelThroughputRequest other = (UpdateProvisionedModelThroughputRequest)((Object)obj);
        return Objects.equals(this.provisionedModelId(), other.provisionedModelId()) && Objects.equals(this.desiredProvisionedModelName(), other.desiredProvisionedModelName()) && Objects.equals(this.desiredModelId(), other.desiredModelId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProvisionedModelThroughputRequest").add("ProvisionedModelId", (Object)this.provisionedModelId()).add("DesiredProvisionedModelName", (Object)this.desiredProvisionedModelName()).add("DesiredModelId", (Object)this.desiredModelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "provisionedModelId": {
                return Optional.ofNullable(clazz.cast(this.provisionedModelId()));
            }
            case "desiredProvisionedModelName": {
                return Optional.ofNullable(clazz.cast(this.desiredProvisionedModelName()));
            }
            case "desiredModelId": {
                return Optional.ofNullable(clazz.cast(this.desiredModelId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("provisionedModelId", PROVISIONED_MODEL_ID_FIELD);
        map.put("desiredProvisionedModelName", DESIRED_PROVISIONED_MODEL_NAME_FIELD);
        map.put("desiredModelId", DESIRED_MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisionedModelThroughputRequest, T> g) {
        return obj -> g.apply((UpdateProvisionedModelThroughputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String provisionedModelId;
        private String desiredProvisionedModelName;
        private String desiredModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedModelThroughputRequest model) {
            super(model);
            this.provisionedModelId(model.provisionedModelId);
            this.desiredProvisionedModelName(model.desiredProvisionedModelName);
            this.desiredModelId(model.desiredModelId);
        }

        public final String getProvisionedModelId() {
            return this.provisionedModelId;
        }

        public final void setProvisionedModelId(String provisionedModelId) {
            this.provisionedModelId = provisionedModelId;
        }

        @Override
        public final Builder provisionedModelId(String provisionedModelId) {
            this.provisionedModelId = provisionedModelId;
            return this;
        }

        public final String getDesiredProvisionedModelName() {
            return this.desiredProvisionedModelName;
        }

        public final void setDesiredProvisionedModelName(String desiredProvisionedModelName) {
            this.desiredProvisionedModelName = desiredProvisionedModelName;
        }

        @Override
        public final Builder desiredProvisionedModelName(String desiredProvisionedModelName) {
            this.desiredProvisionedModelName = desiredProvisionedModelName;
            return this;
        }

        public final String getDesiredModelId() {
            return this.desiredModelId;
        }

        public final void setDesiredModelId(String desiredModelId) {
            this.desiredModelId = desiredModelId;
        }

        @Override
        public final Builder desiredModelId(String desiredModelId) {
            this.desiredModelId = desiredModelId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisionedModelThroughputRequest build() {
            return new UpdateProvisionedModelThroughputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProvisionedModelThroughputRequest> {
        public Builder provisionedModelId(String var1);

        public Builder desiredProvisionedModelName(String var1);

        public Builder desiredModelId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

