/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleScope;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleType;
import software.amazon.awssdk.services.billingconductor.model.Tiering;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PricingRuleListElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PricingRuleListElement> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PricingRuleListElement.getter(PricingRuleListElement::name)).setter(PricingRuleListElement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(PricingRuleListElement.getter(PricingRuleListElement::arn)).setter(PricingRuleListElement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PricingRuleListElement.getter(PricingRuleListElement::description)).setter(PricingRuleListElement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(PricingRuleListElement.getter(PricingRuleListElement::scopeAsString)).setter(PricingRuleListElement.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(PricingRuleListElement.getter(PricingRuleListElement::typeAsString)).setter(PricingRuleListElement.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Double> MODIFIER_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ModifierPercentage").getter(PricingRuleListElement.getter(PricingRuleListElement::modifierPercentage)).setter(PricingRuleListElement.setter(Builder::modifierPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifierPercentage").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(PricingRuleListElement.getter(PricingRuleListElement::service)).setter(PricingRuleListElement.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<Long> ASSOCIATED_PRICING_PLAN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AssociatedPricingPlanCount").getter(PricingRuleListElement.getter(PricingRuleListElement::associatedPricingPlanCount)).setter(PricingRuleListElement.setter(Builder::associatedPricingPlanCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedPricingPlanCount").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreationTime").getter(PricingRuleListElement.getter(PricingRuleListElement::creationTime)).setter(PricingRuleListElement.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastModifiedTime").getter(PricingRuleListElement.getter(PricingRuleListElement::lastModifiedTime)).setter(PricingRuleListElement.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> BILLING_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingEntity").getter(PricingRuleListElement.getter(PricingRuleListElement::billingEntity)).setter(PricingRuleListElement.setter(Builder::billingEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingEntity").build()}).build();
    private static final SdkField<Tiering> TIERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tiering").getter(PricingRuleListElement.getter(PricingRuleListElement::tiering)).setter(PricingRuleListElement.setter(Builder::tiering)).constructor(Tiering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tiering").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, DESCRIPTION_FIELD, SCOPE_FIELD, TYPE_FIELD, MODIFIER_PERCENTAGE_FIELD, SERVICE_FIELD, ASSOCIATED_PRICING_PLAN_COUNT_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, BILLING_ENTITY_FIELD, TIERING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String description;
    private final String scope;
    private final String type;
    private final Double modifierPercentage;
    private final String service;
    private final Long associatedPricingPlanCount;
    private final Long creationTime;
    private final Long lastModifiedTime;
    private final String billingEntity;
    private final Tiering tiering;

    private PricingRuleListElement(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.scope = builder.scope;
        this.type = builder.type;
        this.modifierPercentage = builder.modifierPercentage;
        this.service = builder.service;
        this.associatedPricingPlanCount = builder.associatedPricingPlanCount;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.billingEntity = builder.billingEntity;
        this.tiering = builder.tiering;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final PricingRuleScope scope() {
        return PricingRuleScope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final PricingRuleType type() {
        return PricingRuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Double modifierPercentage() {
        return this.modifierPercentage;
    }

    public final String service() {
        return this.service;
    }

    public final Long associatedPricingPlanCount() {
        return this.associatedPricingPlanCount;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String billingEntity() {
        return this.billingEntity;
    }

    public final Tiering tiering() {
        return this.tiering;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifierPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedPricingPlanCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.tiering());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PricingRuleListElement)) {
            return false;
        }
        PricingRuleListElement other = (PricingRuleListElement)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.modifierPercentage(), other.modifierPercentage()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.associatedPricingPlanCount(), other.associatedPricingPlanCount()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.billingEntity(), other.billingEntity()) && Objects.equals(this.tiering(), other.tiering());
    }

    public final String toString() {
        return ToString.builder((String)"PricingRuleListElement").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Arn", (Object)this.arn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Scope", (Object)this.scopeAsString()).add("Type", (Object)this.typeAsString()).add("ModifierPercentage", (Object)this.modifierPercentage()).add("Service", (Object)this.service()).add("AssociatedPricingPlanCount", (Object)this.associatedPricingPlanCount()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("BillingEntity", (Object)this.billingEntity()).add("Tiering", (Object)this.tiering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ModifierPercentage": {
                return Optional.ofNullable(clazz.cast(this.modifierPercentage()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "AssociatedPricingPlanCount": {
                return Optional.ofNullable(clazz.cast(this.associatedPricingPlanCount()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "BillingEntity": {
                return Optional.ofNullable(clazz.cast(this.billingEntity()));
            }
            case "Tiering": {
                return Optional.ofNullable(clazz.cast(this.tiering()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PricingRuleListElement, T> g) {
        return obj -> g.apply((PricingRuleListElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String description;
        private String scope;
        private String type;
        private Double modifierPercentage;
        private String service;
        private Long associatedPricingPlanCount;
        private Long creationTime;
        private Long lastModifiedTime;
        private String billingEntity;
        private Tiering tiering;

        private BuilderImpl() {
        }

        private BuilderImpl(PricingRuleListElement model) {
            this.name(model.name);
            this.arn(model.arn);
            this.description(model.description);
            this.scope(model.scope);
            this.type(model.type);
            this.modifierPercentage(model.modifierPercentage);
            this.service(model.service);
            this.associatedPricingPlanCount(model.associatedPricingPlanCount);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.billingEntity(model.billingEntity);
            this.tiering(model.tiering);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(PricingRuleScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PricingRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getModifierPercentage() {
            return this.modifierPercentage;
        }

        public final void setModifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
        }

        @Override
        public final Builder modifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Long getAssociatedPricingPlanCount() {
            return this.associatedPricingPlanCount;
        }

        public final void setAssociatedPricingPlanCount(Long associatedPricingPlanCount) {
            this.associatedPricingPlanCount = associatedPricingPlanCount;
        }

        @Override
        public final Builder associatedPricingPlanCount(Long associatedPricingPlanCount) {
            this.associatedPricingPlanCount = associatedPricingPlanCount;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getBillingEntity() {
            return this.billingEntity;
        }

        public final void setBillingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
        }

        @Override
        public final Builder billingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
            return this;
        }

        public final Tiering.Builder getTiering() {
            return this.tiering != null ? this.tiering.toBuilder() : null;
        }

        public final void setTiering(Tiering.BuilderImpl tiering) {
            this.tiering = tiering != null ? tiering.build() : null;
        }

        @Override
        public final Builder tiering(Tiering tiering) {
            this.tiering = tiering;
            return this;
        }

        public PricingRuleListElement build() {
            return new PricingRuleListElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PricingRuleListElement> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder scope(String var1);

        public Builder scope(PricingRuleScope var1);

        public Builder type(String var1);

        public Builder type(PricingRuleType var1);

        public Builder modifierPercentage(Double var1);

        public Builder service(String var1);

        public Builder associatedPricingPlanCount(Long var1);

        public Builder creationTime(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder billingEntity(String var1);

        public Builder tiering(Tiering var1);

        default public Builder tiering(Consumer<Tiering.Builder> tiering) {
            return this.tiering((Tiering)((Tiering.Builder)Tiering.builder().applyMutation(tiering)).build());
        }
    }
}

