/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleArnsNonEmptyInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatePricingRulesRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, AssociatePricingRulesRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AssociatePricingRulesRequest.getter(AssociatePricingRulesRequest::arn)).setter(AssociatePricingRulesRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<String>> PRICING_RULE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PricingRuleArns").getter(AssociatePricingRulesRequest.getter(AssociatePricingRulesRequest::pricingRuleArns)).setter(AssociatePricingRulesRequest.setter(Builder::pricingRuleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingRuleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PRICING_RULE_ARNS_FIELD));
    private final String arn;
    private final List<String> pricingRuleArns;

    private AssociatePricingRulesRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.pricingRuleArns = builder.pricingRuleArns;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasPricingRuleArns() {
        return this.pricingRuleArns != null && !(this.pricingRuleArns instanceof SdkAutoConstructList);
    }

    public final List<String> pricingRuleArns() {
        return this.pricingRuleArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPricingRuleArns() ? this.pricingRuleArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePricingRulesRequest)) {
            return false;
        }
        AssociatePricingRulesRequest other = (AssociatePricingRulesRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasPricingRuleArns() == other.hasPricingRuleArns() && Objects.equals(this.pricingRuleArns(), other.pricingRuleArns());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatePricingRulesRequest").add("Arn", (Object)this.arn()).add("PricingRuleArns", this.hasPricingRuleArns() ? this.pricingRuleArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "PricingRuleArns": {
                return Optional.ofNullable(clazz.cast(this.pricingRuleArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatePricingRulesRequest, T> g) {
        return obj -> g.apply((AssociatePricingRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> pricingRuleArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePricingRulesRequest model) {
            super(model);
            this.arn(model.arn);
            this.pricingRuleArns(model.pricingRuleArns);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getPricingRuleArns() {
            if (this.pricingRuleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pricingRuleArns;
        }

        public final void setPricingRuleArns(Collection<String> pricingRuleArns) {
            this.pricingRuleArns = PricingRuleArnsNonEmptyInputCopier.copy(pricingRuleArns);
        }

        @Override
        public final Builder pricingRuleArns(Collection<String> pricingRuleArns) {
            this.pricingRuleArns = PricingRuleArnsNonEmptyInputCopier.copy(pricingRuleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingRuleArns(String ... pricingRuleArns) {
            this.pricingRuleArns(Arrays.asList(pricingRuleArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePricingRulesRequest build() {
            return new AssociatePricingRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociatePricingRulesRequest> {
        public Builder arn(String var1);

        public Builder pricingRuleArns(Collection<String> var1);

        public Builder pricingRuleArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

