/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPricingRulesAssociatedToPricingPlanResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, ListPricingRulesAssociatedToPricingPlanResponse> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingPeriod").getter(ListPricingRulesAssociatedToPricingPlanResponse.getter(ListPricingRulesAssociatedToPricingPlanResponse::billingPeriod)).setter(ListPricingRulesAssociatedToPricingPlanResponse.setter(Builder::billingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()}).build();
    private static final SdkField<String> PRICING_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlanArn").getter(ListPricingRulesAssociatedToPricingPlanResponse.getter(ListPricingRulesAssociatedToPricingPlanResponse::pricingPlanArn)).setter(ListPricingRulesAssociatedToPricingPlanResponse.setter(Builder::pricingPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanArn").build()}).build();
    private static final SdkField<List<String>> PRICING_RULE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PricingRuleArns").getter(ListPricingRulesAssociatedToPricingPlanResponse.getter(ListPricingRulesAssociatedToPricingPlanResponse::pricingRuleArns)).setter(ListPricingRulesAssociatedToPricingPlanResponse.setter(Builder::pricingRuleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingRuleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPricingRulesAssociatedToPricingPlanResponse.getter(ListPricingRulesAssociatedToPricingPlanResponse::nextToken)).setter(ListPricingRulesAssociatedToPricingPlanResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD, PRICING_PLAN_ARN_FIELD, PRICING_RULE_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPricingRulesAssociatedToPricingPlanResponse.memberNameToFieldInitializer();
    private final String billingPeriod;
    private final String pricingPlanArn;
    private final List<String> pricingRuleArns;
    private final String nextToken;

    private ListPricingRulesAssociatedToPricingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.pricingPlanArn = builder.pricingPlanArn;
        this.pricingRuleArns = builder.pricingRuleArns;
        this.nextToken = builder.nextToken;
    }

    public final String billingPeriod() {
        return this.billingPeriod;
    }

    public final String pricingPlanArn() {
        return this.pricingPlanArn;
    }

    public final boolean hasPricingRuleArns() {
        return this.pricingRuleArns != null && !(this.pricingRuleArns instanceof SdkAutoConstructList);
    }

    public final List<String> pricingRuleArns() {
        return this.pricingRuleArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPricingRuleArns() ? this.pricingRuleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingRulesAssociatedToPricingPlanResponse)) {
            return false;
        }
        ListPricingRulesAssociatedToPricingPlanResponse other = (ListPricingRulesAssociatedToPricingPlanResponse)((Object)obj);
        return Objects.equals(this.billingPeriod(), other.billingPeriod()) && Objects.equals(this.pricingPlanArn(), other.pricingPlanArn()) && this.hasPricingRuleArns() == other.hasPricingRuleArns() && Objects.equals(this.pricingRuleArns(), other.pricingRuleArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPricingRulesAssociatedToPricingPlanResponse").add("BillingPeriod", (Object)this.billingPeriod()).add("PricingPlanArn", (Object)this.pricingPlanArn()).add("PricingRuleArns", this.hasPricingRuleArns() ? this.pricingRuleArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.billingPeriod()));
            }
            case "PricingPlanArn": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanArn()));
            }
            case "PricingRuleArns": {
                return Optional.ofNullable(clazz.cast(this.pricingRuleArns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BillingPeriod", BILLING_PERIOD_FIELD);
        map.put("PricingPlanArn", PRICING_PLAN_ARN_FIELD);
        map.put("PricingRuleArns", PRICING_RULE_ARNS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPricingRulesAssociatedToPricingPlanResponse, T> g) {
        return obj -> g.apply((ListPricingRulesAssociatedToPricingPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private String billingPeriod;
        private String pricingPlanArn;
        private List<String> pricingRuleArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricingRulesAssociatedToPricingPlanResponse model) {
            super(model);
            this.billingPeriod(model.billingPeriod);
            this.pricingPlanArn(model.pricingPlanArn);
            this.pricingRuleArns(model.pricingRuleArns);
            this.nextToken(model.nextToken);
        }

        public final String getBillingPeriod() {
            return this.billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getPricingPlanArn() {
            return this.pricingPlanArn;
        }

        public final void setPricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
        }

        @Override
        public final Builder pricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
            return this;
        }

        public final Collection<String> getPricingRuleArns() {
            if (this.pricingRuleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pricingRuleArns;
        }

        public final void setPricingRuleArns(Collection<String> pricingRuleArns) {
            this.pricingRuleArns = PricingRuleArnsCopier.copy(pricingRuleArns);
        }

        @Override
        public final Builder pricingRuleArns(Collection<String> pricingRuleArns) {
            this.pricingRuleArns = PricingRuleArnsCopier.copy(pricingRuleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingRuleArns(String ... pricingRuleArns) {
            this.pricingRuleArns(Arrays.asList(pricingRuleArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPricingRulesAssociatedToPricingPlanResponse build() {
            return new ListPricingRulesAssociatedToPricingPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPricingRulesAssociatedToPricingPlanResponse> {
        public Builder billingPeriod(String var1);

        public Builder pricingPlanArn(String var1);

        public Builder pricingRuleArns(Collection<String> var1);

        public Builder pricingRuleArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

