/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBudgetActionRequest extends BudgetsRequest implements
        ToCopyableBuilder<UpdateBudgetActionRequest.Builder, UpdateBudgetActionRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(UpdateBudgetActionRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BudgetName").getter(getter(UpdateBudgetActionRequest::budgetName)).setter(setter(Builder::budgetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()).build();

    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionId").getter(getter(UpdateBudgetActionRequest::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationType").getter(getter(UpdateBudgetActionRequest::notificationTypeAsString))
            .setter(setter(Builder::notificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()).build();

    private static final SdkField<ActionThreshold> ACTION_THRESHOLD_FIELD = SdkField
            .<ActionThreshold> builder(MarshallingType.SDK_POJO).memberName("ActionThreshold")
            .getter(getter(UpdateBudgetActionRequest::actionThreshold)).setter(setter(Builder::actionThreshold))
            .constructor(ActionThreshold::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionThreshold").build()).build();

    private static final SdkField<Definition> DEFINITION_FIELD = SdkField.<Definition> builder(MarshallingType.SDK_POJO)
            .memberName("Definition").getter(getter(UpdateBudgetActionRequest::definition)).setter(setter(Builder::definition))
            .constructor(Definition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(UpdateBudgetActionRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> APPROVAL_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalModel").getter(getter(UpdateBudgetActionRequest::approvalModelAsString))
            .setter(setter(Builder::approvalModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalModel").build()).build();

    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField
            .<List<Subscriber>> builder(MarshallingType.LIST)
            .memberName("Subscribers")
            .getter(getter(UpdateBudgetActionRequest::subscribers))
            .setter(setter(Builder::subscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscriber> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscriber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUDGET_NAME_FIELD, ACTION_ID_FIELD, NOTIFICATION_TYPE_FIELD, ACTION_THRESHOLD_FIELD, DEFINITION_FIELD,
            EXECUTION_ROLE_ARN_FIELD, APPROVAL_MODEL_FIELD, SUBSCRIBERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String budgetName;

    private final String actionId;

    private final String notificationType;

    private final ActionThreshold actionThreshold;

    private final Definition definition;

    private final String executionRoleArn;

    private final String approvalModel;

    private final List<Subscriber> subscribers;

    private UpdateBudgetActionRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.actionId = builder.actionId;
        this.notificationType = builder.notificationType;
        this.actionThreshold = builder.actionThreshold;
        this.definition = builder.definition;
        this.executionRoleArn = builder.executionRoleArn;
        this.approvalModel = builder.approvalModel;
        this.subscribers = builder.subscribers;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public final String budgetName() {
        return budgetName;
    }

    /**
     * <p>
     * A system-generated universally unique identifier (UUID) for the action.
     * </p>
     * 
     * @return A system-generated universally unique identifier (UUID) for the action.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * Returns the value of the NotificationType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The value of the NotificationType property for this object.
     * @see NotificationType
     */
    public final NotificationType notificationType() {
        return NotificationType.fromValue(notificationType);
    }

    /**
     * Returns the value of the NotificationType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The value of the NotificationType property for this object.
     * @see NotificationType
     */
    public final String notificationTypeAsString() {
        return notificationType;
    }

    /**
     * Returns the value of the ActionThreshold property for this object.
     * 
     * @return The value of the ActionThreshold property for this object.
     */
    public final ActionThreshold actionThreshold() {
        return actionThreshold;
    }

    /**
     * Returns the value of the Definition property for this object.
     * 
     * @return The value of the Definition property for this object.
     */
    public final Definition definition() {
        return definition;
    }

    /**
     * <p>
     * The role passed for action execution and reversion. Roles and actions must be in the same account.
     * </p>
     * 
     * @return The role passed for action execution and reversion. Roles and actions must be in the same account.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * This specifies if the action needs manual or automatic approval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #approvalModel}
     * will return {@link ApprovalModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #approvalModelAsString}.
     * </p>
     * 
     * @return This specifies if the action needs manual or automatic approval.
     * @see ApprovalModel
     */
    public final ApprovalModel approvalModel() {
        return ApprovalModel.fromValue(approvalModel);
    }

    /**
     * <p>
     * This specifies if the action needs manual or automatic approval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #approvalModel}
     * will return {@link ApprovalModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #approvalModelAsString}.
     * </p>
     * 
     * @return This specifies if the action needs manual or automatic approval.
     * @see ApprovalModel
     */
    public final String approvalModelAsString() {
        return approvalModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscribers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribers() {
        return subscribers != null && !(subscribers instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Subscribers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribers} method.
     * </p>
     * 
     * @return The value of the Subscribers property for this object.
     */
    public final List<Subscriber> subscribers() {
        return subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(approvalModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribers() ? subscribers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetActionRequest)) {
            return false;
        }
        UpdateBudgetActionRequest other = (UpdateBudgetActionRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(budgetName(), other.budgetName())
                && Objects.equals(actionId(), other.actionId())
                && Objects.equals(notificationTypeAsString(), other.notificationTypeAsString())
                && Objects.equals(actionThreshold(), other.actionThreshold()) && Objects.equals(definition(), other.definition())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(approvalModelAsString(), other.approvalModelAsString())
                && hasSubscribers() == other.hasSubscribers() && Objects.equals(subscribers(), other.subscribers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBudgetActionRequest").add("AccountId", accountId()).add("BudgetName", budgetName())
                .add("ActionId", actionId()).add("NotificationType", notificationTypeAsString())
                .add("ActionThreshold", actionThreshold()).add("Definition", definition())
                .add("ExecutionRoleArn", executionRoleArn()).add("ApprovalModel", approvalModelAsString())
                .add("Subscribers", hasSubscribers() ? subscribers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "BudgetName":
            return Optional.ofNullable(clazz.cast(budgetName()));
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "NotificationType":
            return Optional.ofNullable(clazz.cast(notificationTypeAsString()));
        case "ActionThreshold":
            return Optional.ofNullable(clazz.cast(actionThreshold()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "ApprovalModel":
            return Optional.ofNullable(clazz.cast(approvalModelAsString()));
        case "Subscribers":
            return Optional.ofNullable(clazz.cast(subscribers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("BudgetName", BUDGET_NAME_FIELD);
        map.put("ActionId", ACTION_ID_FIELD);
        map.put("NotificationType", NOTIFICATION_TYPE_FIELD);
        map.put("ActionThreshold", ACTION_THRESHOLD_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("ApprovalModel", APPROVAL_MODEL_FIELD);
        map.put("Subscribers", SUBSCRIBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBudgetActionRequest, T> g) {
        return obj -> g.apply((UpdateBudgetActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBudgetActionRequest> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * <p>
         * A system-generated universally unique identifier (UUID) for the action.
         * </p>
         * 
         * @param actionId
         *        A system-generated universally unique identifier (UUID) for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * Sets the value of the NotificationType property for this object.
         *
         * @param notificationType
         *        The new value for the NotificationType property for this object.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * Sets the value of the NotificationType property for this object.
         *
         * @param notificationType
         *        The new value for the NotificationType property for this object.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);

        /**
         * Sets the value of the ActionThreshold property for this object.
         *
         * @param actionThreshold
         *        The new value for the ActionThreshold property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionThreshold(ActionThreshold actionThreshold);

        /**
         * Sets the value of the ActionThreshold property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ActionThreshold.Builder} avoiding the
         * need to create one manually via {@link ActionThreshold#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionThreshold.Builder#build()} is called immediately and its
         * result is passed to {@link #actionThreshold(ActionThreshold)}.
         * 
         * @param actionThreshold
         *        a consumer that will call methods on {@link ActionThreshold.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionThreshold(ActionThreshold)
         */
        default Builder actionThreshold(Consumer<ActionThreshold.Builder> actionThreshold) {
            return actionThreshold(ActionThreshold.builder().applyMutation(actionThreshold).build());
        }

        /**
         * Sets the value of the Definition property for this object.
         *
         * @param definition
         *        The new value for the Definition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(Definition definition);

        /**
         * Sets the value of the Definition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Definition.Builder} avoiding the need to
         * create one manually via {@link Definition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Definition.Builder#build()} is called immediately and its result
         * is passed to {@link #definition(Definition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link Definition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(Definition)
         */
        default Builder definition(Consumer<Definition.Builder> definition) {
            return definition(Definition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The role passed for action execution and reversion. Roles and actions must be in the same account.
         * </p>
         * 
         * @param executionRoleArn
         *        The role passed for action execution and reversion. Roles and actions must be in the same account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * This specifies if the action needs manual or automatic approval.
         * </p>
         * 
         * @param approvalModel
         *        This specifies if the action needs manual or automatic approval.
         * @see ApprovalModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalModel
         */
        Builder approvalModel(String approvalModel);

        /**
         * <p>
         * This specifies if the action needs manual or automatic approval.
         * </p>
         * 
         * @param approvalModel
         *        This specifies if the action needs manual or automatic approval.
         * @see ApprovalModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalModel
         */
        Builder approvalModel(ApprovalModel approvalModel);

        /**
         * Sets the value of the Subscribers property for this object.
         *
         * @param subscribers
         *        The new value for the Subscribers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<Subscriber> subscribers);

        /**
         * Sets the value of the Subscribers property for this object.
         *
         * @param subscribers
         *        The new value for the Subscribers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Subscriber... subscribers);

        /**
         * Sets the value of the Subscribers property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.budgets.model.Subscriber.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.budgets.model.Subscriber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.budgets.model.Subscriber.Builder#build()} is called immediately and
         * its result is passed to {@link #subscribers(List<Subscriber>)}.
         * 
         * @param subscribers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.budgets.model.Subscriber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribers(java.util.Collection<Subscriber>)
         */
        Builder subscribers(Consumer<Subscriber.Builder>... subscribers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BudgetsRequest.BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private String actionId;

        private String notificationType;

        private ActionThreshold actionThreshold;

        private Definition definition;

        private String executionRoleArn;

        private String approvalModel;

        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetActionRequest model) {
            super(model);
            accountId(model.accountId);
            budgetName(model.budgetName);
            actionId(model.actionId);
            notificationType(model.notificationType);
            actionThreshold(model.actionThreshold);
            definition(model.definition);
            executionRoleArn(model.executionRoleArn);
            approvalModel(model.approvalModel);
            subscribers(model.subscribers);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getNotificationType() {
            return notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        public final ActionThreshold.Builder getActionThreshold() {
            return actionThreshold != null ? actionThreshold.toBuilder() : null;
        }

        public final void setActionThreshold(ActionThreshold.BuilderImpl actionThreshold) {
            this.actionThreshold = actionThreshold != null ? actionThreshold.build() : null;
        }

        @Override
        public final Builder actionThreshold(ActionThreshold actionThreshold) {
            this.actionThreshold = actionThreshold;
            return this;
        }

        public final Definition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(Definition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(Definition definition) {
            this.definition = definition;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getApprovalModel() {
            return approvalModel;
        }

        public final void setApprovalModel(String approvalModel) {
            this.approvalModel = approvalModel;
        }

        @Override
        public final Builder approvalModel(String approvalModel) {
            this.approvalModel = approvalModel;
            return this;
        }

        @Override
        public final Builder approvalModel(ApprovalModel approvalModel) {
            this.approvalModel(approvalModel == null ? null : approvalModel.toString());
            return this;
        }

        public final List<Subscriber.Builder> getSubscribers() {
            List<Subscriber.Builder> result = SubscribersCopier.copyToBuilder(this.subscribers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder>... subscribers) {
            subscribers(Stream.of(subscribers).map(c -> Subscriber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBudgetActionRequest build() {
            return new UpdateBudgetActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
