/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.ChimeWebhookConfiguration;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse;

public class DescribeChimeWebhookConfigurationsIterable
implements SdkIterable<DescribeChimeWebhookConfigurationsResponse> {
    private final ChatbotClient client;
    private final DescribeChimeWebhookConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeChimeWebhookConfigurationsIterable(ChatbotClient client, DescribeChimeWebhookConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeChimeWebhookConfigurationsResponseFetcher();
    }

    public Iterator<DescribeChimeWebhookConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChimeWebhookConfiguration> webhookConfigurations() {
        Function<DescribeChimeWebhookConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.webhookConfigurations() != null) {
                return response.webhookConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeChimeWebhookConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeChimeWebhookConfigurationsResponse> {
        private DescribeChimeWebhookConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeChimeWebhookConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeChimeWebhookConfigurationsResponse nextPage(DescribeChimeWebhookConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeChimeWebhookConfigurationsIterable.this.client.describeChimeWebhookConfigurations(DescribeChimeWebhookConfigurationsIterable.this.firstRequest);
            }
            return DescribeChimeWebhookConfigurationsIterable.this.client.describeChimeWebhookConfigurations((DescribeChimeWebhookConfigurationsRequest)((Object)DescribeChimeWebhookConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

