/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotAsyncClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.ConfiguredTeam;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse;

public class ListMicrosoftTeamsConfiguredTeamsPublisher
implements SdkPublisher<ListMicrosoftTeamsConfiguredTeamsResponse> {
    private final ChatbotAsyncClient client;
    private final ListMicrosoftTeamsConfiguredTeamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMicrosoftTeamsConfiguredTeamsPublisher(ChatbotAsyncClient client, ListMicrosoftTeamsConfiguredTeamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMicrosoftTeamsConfiguredTeamsPublisher(ChatbotAsyncClient client, ListMicrosoftTeamsConfiguredTeamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMicrosoftTeamsConfiguredTeamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMicrosoftTeamsConfiguredTeamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfiguredTeam> configuredTeams() {
        Function<ListMicrosoftTeamsConfiguredTeamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredTeams() != null) {
                return response.configuredTeams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMicrosoftTeamsConfiguredTeamsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMicrosoftTeamsConfiguredTeamsResponseFetcher
    implements AsyncPageFetcher<ListMicrosoftTeamsConfiguredTeamsResponse> {
        private ListMicrosoftTeamsConfiguredTeamsResponseFetcher() {
        }

        public boolean hasNextPage(ListMicrosoftTeamsConfiguredTeamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMicrosoftTeamsConfiguredTeamsResponse> nextPage(ListMicrosoftTeamsConfiguredTeamsResponse previousPage) {
            if (previousPage == null) {
                return ListMicrosoftTeamsConfiguredTeamsPublisher.this.client.listMicrosoftTeamsConfiguredTeams(ListMicrosoftTeamsConfiguredTeamsPublisher.this.firstRequest);
            }
            return ListMicrosoftTeamsConfiguredTeamsPublisher.this.client.listMicrosoftTeamsConfiguredTeams((ListMicrosoftTeamsConfiguredTeamsRequest)((Object)ListMicrosoftTeamsConfiguredTeamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

