/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedactConversationMessageRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, RedactConversationMessageRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(RedactConversationMessageRequest.getter(RedactConversationMessageRequest::accountId)).setter(RedactConversationMessageRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConversationId").getter(RedactConversationMessageRequest.getter(RedactConversationMessageRequest::conversationId)).setter(RedactConversationMessageRequest.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("conversationId").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(RedactConversationMessageRequest.getter(RedactConversationMessageRequest::messageId)).setter(RedactConversationMessageRequest.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CONVERSATION_ID_FIELD, MESSAGE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("conversationId", CONVERSATION_ID_FIELD);
            this.put("messageId", MESSAGE_ID_FIELD);
        }
    });
    private final String accountId;
    private final String conversationId;
    private final String messageId;

    private RedactConversationMessageRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.conversationId = builder.conversationId;
        this.messageId = builder.messageId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String messageId() {
        return this.messageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedactConversationMessageRequest)) {
            return false;
        }
        RedactConversationMessageRequest other = (RedactConversationMessageRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.messageId(), other.messageId());
    }

    public final String toString() {
        return ToString.builder((String)"RedactConversationMessageRequest").add("AccountId", (Object)this.accountId()).add("ConversationId", (Object)this.conversationId()).add("MessageId", (Object)this.messageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ConversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedactConversationMessageRequest, T> g) {
        return obj -> g.apply((RedactConversationMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String conversationId;
        private String messageId;

        private BuilderImpl() {
        }

        private BuilderImpl(RedactConversationMessageRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.conversationId(model.conversationId);
            this.messageId(model.messageId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RedactConversationMessageRequest build() {
            return new RedactConversationMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RedactConversationMessageRequest> {
        public Builder accountId(String var1);

        public Builder conversationId(String var1);

        public Builder messageId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

