/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersResponse;

public class SearchAvailablePhoneNumbersIterable
implements SdkIterable<SearchAvailablePhoneNumbersResponse> {
    private final ChimeClient client;
    private final SearchAvailablePhoneNumbersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchAvailablePhoneNumbersIterable(ChimeClient client, SearchAvailablePhoneNumbersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchAvailablePhoneNumbersResponseFetcher();
    }

    public Iterator<SearchAvailablePhoneNumbersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchAvailablePhoneNumbersResponseFetcher
    implements SyncPageFetcher<SearchAvailablePhoneNumbersResponse> {
        private SearchAvailablePhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(SearchAvailablePhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchAvailablePhoneNumbersResponse nextPage(SearchAvailablePhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return SearchAvailablePhoneNumbersIterable.this.client.searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersIterable.this.firstRequest);
            }
            return SearchAvailablePhoneNumbersIterable.this.client.searchAvailablePhoneNumbers((SearchAvailablePhoneNumbersRequest)((Object)SearchAvailablePhoneNumbersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

