/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeletePhoneNumberRequest extends ChimeRequest implements
        ToCopyableBuilder<BatchDeletePhoneNumberRequest.Builder, BatchDeletePhoneNumberRequest> {
    private static final SdkField<List<String>> PHONE_NUMBER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PhoneNumberIds")
            .getter(getter(BatchDeletePhoneNumberRequest::phoneNumberIds))
            .setter(setter(Builder::phoneNumberIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> phoneNumberIds;

    private BatchDeletePhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumberIds = builder.phoneNumberIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhoneNumberIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhoneNumberIds() {
        return phoneNumberIds != null && !(phoneNumberIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of phone number IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhoneNumberIds} method.
     * </p>
     * 
     * @return List of phone number IDs.
     */
    public final List<String> phoneNumberIds() {
        return phoneNumberIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumberIds() ? phoneNumberIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeletePhoneNumberRequest)) {
            return false;
        }
        BatchDeletePhoneNumberRequest other = (BatchDeletePhoneNumberRequest) obj;
        return hasPhoneNumberIds() == other.hasPhoneNumberIds() && Objects.equals(phoneNumberIds(), other.phoneNumberIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeletePhoneNumberRequest")
                .add("PhoneNumberIds", hasPhoneNumberIds() ? phoneNumberIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberIds":
            return Optional.ofNullable(clazz.cast(phoneNumberIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PhoneNumberIds", PHONE_NUMBER_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeletePhoneNumberRequest, T> g) {
        return obj -> g.apply((BatchDeletePhoneNumberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeletePhoneNumberRequest> {
        /**
         * <p>
         * List of phone number IDs.
         * </p>
         * 
         * @param phoneNumberIds
         *        List of phone number IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberIds(Collection<String> phoneNumberIds);

        /**
         * <p>
         * List of phone number IDs.
         * </p>
         * 
         * @param phoneNumberIds
         *        List of phone number IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberIds(String... phoneNumberIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private List<String> phoneNumberIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeletePhoneNumberRequest model) {
            super(model);
            phoneNumberIds(model.phoneNumberIds);
        }

        public final Collection<String> getPhoneNumberIds() {
            if (phoneNumberIds instanceof SdkAutoConstructList) {
                return null;
            }
            return phoneNumberIds;
        }

        public final void setPhoneNumberIds(Collection<String> phoneNumberIds) {
            this.phoneNumberIds = NonEmptyStringListCopier.copy(phoneNumberIds);
        }

        @Override
        public final Builder phoneNumberIds(Collection<String> phoneNumberIds) {
            this.phoneNumberIds = NonEmptyStringListCopier.copy(phoneNumberIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberIds(String... phoneNumberIds) {
            phoneNumberIds(Arrays.asList(phoneNumberIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeletePhoneNumberRequest build() {
            return new BatchDeletePhoneNumberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
