/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelBanResponse extends ChimeResponse implements
        ToCopyableBuilder<CreateChannelBanResponse.Builder, CreateChannelBanResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(CreateChannelBanResponse::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<Identity> MEMBER_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("Member").getter(getter(CreateChannelBanResponse::member)).setter(setter(Builder::member))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Member").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            MEMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelArn;

    private final Identity member;

    private CreateChannelBanResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.member = builder.member;
    }

    /**
     * <p>
     * The ARN of the response to the ban request.
     * </p>
     * 
     * @return The ARN of the response to the ban request.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.
     * </p>
     * 
     * @return The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.
     */
    public final Identity member() {
        return member;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(member());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelBanResponse)) {
            return false;
        }
        CreateChannelBanResponse other = (CreateChannelBanResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(member(), other.member());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelBanResponse").add("ChannelArn", channelArn()).add("Member", member()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "Member":
            return Optional.ofNullable(clazz.cast(member()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelArn", CHANNEL_ARN_FIELD);
        map.put("Member", MEMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelBanResponse, T> g) {
        return obj -> g.apply((CreateChannelBanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelBanResponse> {
        /**
         * <p>
         * The ARN of the response to the ban request.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the response to the ban request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.
         * </p>
         * 
         * @param member
         *        The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder member(Identity member);

        /**
         * <p>
         * The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identity.Builder} avoiding the need to
         * create one manually via {@link Identity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #member(Identity)}.
         * 
         * @param member
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #member(Identity)
         */
        default Builder member(Consumer<Identity.Builder> member) {
            return member(Identity.builder().applyMutation(member).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private String channelArn;

        private Identity member;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelBanResponse model) {
            super(model);
            channelArn(model.channelArn);
            member(model.member);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final Identity.Builder getMember() {
            return member != null ? member.toBuilder() : null;
        }

        public final void setMember(Identity.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        public final Builder member(Identity member) {
            this.member = member;
            return this;
        }

        @Override
        public CreateChannelBanResponse build() {
            return new CreateChannelBanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
