/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSipMediaApplicationCallResponse extends ChimeResponse implements
        ToCopyableBuilder<CreateSipMediaApplicationCallResponse.Builder, CreateSipMediaApplicationCallResponse> {
    private static final SdkField<SipMediaApplicationCall> SIP_MEDIA_APPLICATION_CALL_FIELD = SdkField
            .<SipMediaApplicationCall> builder(MarshallingType.SDK_POJO).memberName("SipMediaApplicationCall")
            .getter(getter(CreateSipMediaApplicationCallResponse::sipMediaApplicationCall))
            .setter(setter(Builder::sipMediaApplicationCall)).constructor(SipMediaApplicationCall::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipMediaApplicationCall").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SIP_MEDIA_APPLICATION_CALL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SipMediaApplicationCall sipMediaApplicationCall;

    private CreateSipMediaApplicationCallResponse(BuilderImpl builder) {
        super(builder);
        this.sipMediaApplicationCall = builder.sipMediaApplicationCall;
    }

    /**
     * <p>
     * The actual call.
     * </p>
     * 
     * @return The actual call.
     */
    public final SipMediaApplicationCall sipMediaApplicationCall() {
        return sipMediaApplicationCall;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationCall());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSipMediaApplicationCallResponse)) {
            return false;
        }
        CreateSipMediaApplicationCallResponse other = (CreateSipMediaApplicationCallResponse) obj;
        return Objects.equals(sipMediaApplicationCall(), other.sipMediaApplicationCall());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSipMediaApplicationCallResponse")
                .add("SipMediaApplicationCall", sipMediaApplicationCall()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipMediaApplicationCall":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationCall()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SipMediaApplicationCall", SIP_MEDIA_APPLICATION_CALL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSipMediaApplicationCallResponse, T> g) {
        return obj -> g.apply((CreateSipMediaApplicationCallResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSipMediaApplicationCallResponse> {
        /**
         * <p>
         * The actual call.
         * </p>
         * 
         * @param sipMediaApplicationCall
         *        The actual call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationCall(SipMediaApplicationCall sipMediaApplicationCall);

        /**
         * <p>
         * The actual call.
         * </p>
         * This is a convenience method that creates an instance of the {@link SipMediaApplicationCall.Builder} avoiding
         * the need to create one manually via {@link SipMediaApplicationCall#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SipMediaApplicationCall.Builder#build()} is called immediately
         * and its result is passed to {@link #sipMediaApplicationCall(SipMediaApplicationCall)}.
         * 
         * @param sipMediaApplicationCall
         *        a consumer that will call methods on {@link SipMediaApplicationCall.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sipMediaApplicationCall(SipMediaApplicationCall)
         */
        default Builder sipMediaApplicationCall(Consumer<SipMediaApplicationCall.Builder> sipMediaApplicationCall) {
            return sipMediaApplicationCall(SipMediaApplicationCall.builder().applyMutation(sipMediaApplicationCall).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private SipMediaApplicationCall sipMediaApplicationCall;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSipMediaApplicationCallResponse model) {
            super(model);
            sipMediaApplicationCall(model.sipMediaApplicationCall);
        }

        public final SipMediaApplicationCall.Builder getSipMediaApplicationCall() {
            return sipMediaApplicationCall != null ? sipMediaApplicationCall.toBuilder() : null;
        }

        public final void setSipMediaApplicationCall(SipMediaApplicationCall.BuilderImpl sipMediaApplicationCall) {
            this.sipMediaApplicationCall = sipMediaApplicationCall != null ? sipMediaApplicationCall.build() : null;
        }

        @Override
        public final Builder sipMediaApplicationCall(SipMediaApplicationCall sipMediaApplicationCall) {
            this.sipMediaApplicationCall = sipMediaApplicationCall;
            return this;
        }

        @Override
        public CreateSipMediaApplicationCallResponse build() {
            return new CreateSipMediaApplicationCallResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
