/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppInstanceUserResponse extends ChimeResponse implements
        ToCopyableBuilder<DescribeAppInstanceUserResponse.Builder, DescribeAppInstanceUserResponse> {
    private static final SdkField<AppInstanceUser> APP_INSTANCE_USER_FIELD = SdkField
            .<AppInstanceUser> builder(MarshallingType.SDK_POJO).memberName("AppInstanceUser")
            .getter(getter(DescribeAppInstanceUserResponse::appInstanceUser)).setter(setter(Builder::appInstanceUser))
            .constructor(AppInstanceUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceUser").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AppInstanceUser appInstanceUser;

    private DescribeAppInstanceUserResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceUser = builder.appInstanceUser;
    }

    /**
     * <p>
     * The name of the <code>AppInstanceUser</code>.
     * </p>
     * 
     * @return The name of the <code>AppInstanceUser</code>.
     */
    public final AppInstanceUser appInstanceUser() {
        return appInstanceUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceUser());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppInstanceUserResponse)) {
            return false;
        }
        DescribeAppInstanceUserResponse other = (DescribeAppInstanceUserResponse) obj;
        return Objects.equals(appInstanceUser(), other.appInstanceUser());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppInstanceUserResponse").add("AppInstanceUser", appInstanceUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceUser":
            return Optional.ofNullable(clazz.cast(appInstanceUser()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppInstanceUser", APP_INSTANCE_USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppInstanceUserResponse, T> g) {
        return obj -> g.apply((DescribeAppInstanceUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAppInstanceUserResponse> {
        /**
         * <p>
         * The name of the <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param appInstanceUser
         *        The name of the <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUser(AppInstanceUser appInstanceUser);

        /**
         * <p>
         * The name of the <code>AppInstanceUser</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppInstanceUser.Builder} avoiding the
         * need to create one manually via {@link AppInstanceUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppInstanceUser.Builder#build()} is called immediately and its
         * result is passed to {@link #appInstanceUser(AppInstanceUser)}.
         * 
         * @param appInstanceUser
         *        a consumer that will call methods on {@link AppInstanceUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstanceUser(AppInstanceUser)
         */
        default Builder appInstanceUser(Consumer<AppInstanceUser.Builder> appInstanceUser) {
            return appInstanceUser(AppInstanceUser.builder().applyMutation(appInstanceUser).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private AppInstanceUser appInstanceUser;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppInstanceUserResponse model) {
            super(model);
            appInstanceUser(model.appInstanceUser);
        }

        public final AppInstanceUser.Builder getAppInstanceUser() {
            return appInstanceUser != null ? appInstanceUser.toBuilder() : null;
        }

        public final void setAppInstanceUser(AppInstanceUser.BuilderImpl appInstanceUser) {
            this.appInstanceUser = appInstanceUser != null ? appInstanceUser.build() : null;
        }

        @Override
        public final Builder appInstanceUser(AppInstanceUser appInstanceUser) {
            this.appInstanceUser = appInstanceUser;
            return this;
        }

        @Override
        public DescribeAppInstanceUserResponse build() {
            return new DescribeAppInstanceUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
