/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMeetingResponse extends ChimeResponse implements
        ToCopyableBuilder<GetMeetingResponse.Builder, GetMeetingResponse> {
    private static final SdkField<Meeting> MEETING_FIELD = SdkField.<Meeting> builder(MarshallingType.SDK_POJO)
            .memberName("Meeting").getter(getter(GetMeetingResponse::meeting)).setter(setter(Builder::meeting))
            .constructor(Meeting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Meeting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Meeting meeting;

    private GetMeetingResponse(BuilderImpl builder) {
        super(builder);
        this.meeting = builder.meeting;
    }

    /**
     * <p>
     * The Amazon Chime SDK meeting information.
     * </p>
     * 
     * @return The Amazon Chime SDK meeting information.
     */
    public final Meeting meeting() {
        return meeting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meeting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMeetingResponse)) {
            return false;
        }
        GetMeetingResponse other = (GetMeetingResponse) obj;
        return Objects.equals(meeting(), other.meeting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMeetingResponse").add("Meeting", meeting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Meeting":
            return Optional.ofNullable(clazz.cast(meeting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Meeting", MEETING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMeetingResponse, T> g) {
        return obj -> g.apply((GetMeetingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMeetingResponse> {
        /**
         * <p>
         * The Amazon Chime SDK meeting information.
         * </p>
         * 
         * @param meeting
         *        The Amazon Chime SDK meeting information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meeting(Meeting meeting);

        /**
         * <p>
         * The Amazon Chime SDK meeting information.
         * </p>
         * This is a convenience method that creates an instance of the {@link Meeting.Builder} avoiding the need to
         * create one manually via {@link Meeting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Meeting.Builder#build()} is called immediately and its result is
         * passed to {@link #meeting(Meeting)}.
         * 
         * @param meeting
         *        a consumer that will call methods on {@link Meeting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meeting(Meeting)
         */
        default Builder meeting(Consumer<Meeting.Builder> meeting) {
            return meeting(Meeting.builder().applyMutation(meeting).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private Meeting meeting;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMeetingResponse model) {
            super(model);
            meeting(model.meeting);
        }

        public final Meeting.Builder getMeeting() {
            return meeting != null ? meeting.toBuilder() : null;
        }

        public final void setMeeting(Meeting.BuilderImpl meeting) {
            this.meeting = meeting != null ? meeting.build() : null;
        }

        @Override
        public final Builder meeting(Meeting meeting) {
            this.meeting = meeting;
            return this;
        }

        @Override
        public GetMeetingResponse build() {
            return new GetMeetingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
