/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPhoneNumberOrderResponse extends ChimeResponse implements
        ToCopyableBuilder<GetPhoneNumberOrderResponse.Builder, GetPhoneNumberOrderResponse> {
    private static final SdkField<PhoneNumberOrder> PHONE_NUMBER_ORDER_FIELD = SdkField
            .<PhoneNumberOrder> builder(MarshallingType.SDK_POJO).memberName("PhoneNumberOrder")
            .getter(getter(GetPhoneNumberOrderResponse::phoneNumberOrder)).setter(setter(Builder::phoneNumberOrder))
            .constructor(PhoneNumberOrder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PhoneNumberOrder phoneNumberOrder;

    private GetPhoneNumberOrderResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberOrder = builder.phoneNumberOrder;
    }

    /**
     * <p>
     * The phone number order details.
     * </p>
     * 
     * @return The phone number order details.
     */
    public final PhoneNumberOrder phoneNumberOrder() {
        return phoneNumberOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberOrder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPhoneNumberOrderResponse)) {
            return false;
        }
        GetPhoneNumberOrderResponse other = (GetPhoneNumberOrderResponse) obj;
        return Objects.equals(phoneNumberOrder(), other.phoneNumberOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPhoneNumberOrderResponse").add("PhoneNumberOrder", phoneNumberOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberOrder":
            return Optional.ofNullable(clazz.cast(phoneNumberOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PhoneNumberOrder", PHONE_NUMBER_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPhoneNumberOrderResponse, T> g) {
        return obj -> g.apply((GetPhoneNumberOrderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPhoneNumberOrderResponse> {
        /**
         * <p>
         * The phone number order details.
         * </p>
         * 
         * @param phoneNumberOrder
         *        The phone number order details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberOrder(PhoneNumberOrder phoneNumberOrder);

        /**
         * <p>
         * The phone number order details.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhoneNumberOrder.Builder} avoiding the
         * need to create one manually via {@link PhoneNumberOrder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhoneNumberOrder.Builder#build()} is called immediately and its
         * result is passed to {@link #phoneNumberOrder(PhoneNumberOrder)}.
         * 
         * @param phoneNumberOrder
         *        a consumer that will call methods on {@link PhoneNumberOrder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumberOrder(PhoneNumberOrder)
         */
        default Builder phoneNumberOrder(Consumer<PhoneNumberOrder.Builder> phoneNumberOrder) {
            return phoneNumberOrder(PhoneNumberOrder.builder().applyMutation(phoneNumberOrder).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private PhoneNumberOrder phoneNumberOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPhoneNumberOrderResponse model) {
            super(model);
            phoneNumberOrder(model.phoneNumberOrder);
        }

        public final PhoneNumberOrder.Builder getPhoneNumberOrder() {
            return phoneNumberOrder != null ? phoneNumberOrder.toBuilder() : null;
        }

        public final void setPhoneNumberOrder(PhoneNumberOrder.BuilderImpl phoneNumberOrder) {
            this.phoneNumberOrder = phoneNumberOrder != null ? phoneNumberOrder.build() : null;
        }

        @Override
        public final Builder phoneNumberOrder(PhoneNumberOrder phoneNumberOrder) {
            this.phoneNumberOrder = phoneNumberOrder;
            return this;
        }

        @Override
        public GetPhoneNumberOrderResponse build() {
            return new GetPhoneNumberOrderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
