/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A phone number used for Amazon Chime Business Calling or an Amazon Chime Voice Connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumber implements SdkPojo, Serializable, ToCopyableBuilder<PhoneNumber.Builder, PhoneNumber> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberId").getter(getter(PhoneNumber::phoneNumberId)).setter(setter(Builder::phoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()).build();

    private static final SdkField<String> E164_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("E164PhoneNumber").getter(getter(PhoneNumber::e164PhoneNumber)).setter(setter(Builder::e164PhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumber").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(PhoneNumber::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(PhoneNumber::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductType").getter(getter(PhoneNumber::productTypeAsString)).setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PhoneNumber::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<PhoneNumberCapabilities> CAPABILITIES_FIELD = SdkField
            .<PhoneNumberCapabilities> builder(MarshallingType.SDK_POJO).memberName("Capabilities")
            .getter(getter(PhoneNumber::capabilities)).setter(setter(Builder::capabilities))
            .constructor(PhoneNumberCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final SdkField<List<PhoneNumberAssociation>> ASSOCIATIONS_FIELD = SdkField
            .<List<PhoneNumberAssociation>> builder(MarshallingType.LIST)
            .memberName("Associations")
            .getter(getter(PhoneNumber::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumberAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumberAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CALLING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallingName").getter(getter(PhoneNumber::callingName)).setter(setter(Builder::callingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingName").build()).build();

    private static final SdkField<String> CALLING_NAME_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallingNameStatus").getter(getter(PhoneNumber::callingNameStatusAsString))
            .setter(setter(Builder::callingNameStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingNameStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(PhoneNumber::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(PhoneNumber::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> DELETION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletionTimestamp")
            .getter(getter(PhoneNumber::deletionTimestamp))
            .setter(setter(Builder::deletionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD,
            E164_PHONE_NUMBER_FIELD, COUNTRY_FIELD, TYPE_FIELD, PRODUCT_TYPE_FIELD, STATUS_FIELD, CAPABILITIES_FIELD,
            ASSOCIATIONS_FIELD, CALLING_NAME_FIELD, CALLING_NAME_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD,
            DELETION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String phoneNumberId;

    private final String e164PhoneNumber;

    private final String country;

    private final String type;

    private final String productType;

    private final String status;

    private final PhoneNumberCapabilities capabilities;

    private final List<PhoneNumberAssociation> associations;

    private final String callingName;

    private final String callingNameStatus;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final Instant deletionTimestamp;

    private PhoneNumber(BuilderImpl builder) {
        this.phoneNumberId = builder.phoneNumberId;
        this.e164PhoneNumber = builder.e164PhoneNumber;
        this.country = builder.country;
        this.type = builder.type;
        this.productType = builder.productType;
        this.status = builder.status;
        this.capabilities = builder.capabilities;
        this.associations = builder.associations;
        this.callingName = builder.callingName;
        this.callingNameStatus = builder.callingNameStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.deletionTimestamp = builder.deletionTimestamp;
    }

    /**
     * <p>
     * The phone number ID.
     * </p>
     * 
     * @return The phone number ID.
     */
    public final String phoneNumberId() {
        return phoneNumberId;
    }

    /**
     * <p>
     * The phone number, in E.164 format.
     * </p>
     * 
     * @return The phone number, in E.164 format.
     */
    public final String e164PhoneNumber() {
        return e164PhoneNumber;
    }

    /**
     * <p>
     * The phone number country. Format: ISO 3166-1 alpha-2.
     * </p>
     * 
     * @return The phone number country. Format: ISO 3166-1 alpha-2.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The phone number type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The phone number type.
     * @see PhoneNumberType
     */
    public final PhoneNumberType type() {
        return PhoneNumberType.fromValue(type);
    }

    /**
     * <p>
     * The phone number type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The phone number type.
     * @see PhoneNumberType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The phone number product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number product type.
     * @see PhoneNumberProductType
     */
    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(productType);
    }

    /**
     * <p>
     * The phone number product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number product type.
     * @see PhoneNumberProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The phone number status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhoneNumberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The phone number status.
     * @see PhoneNumberStatus
     */
    public final PhoneNumberStatus status() {
        return PhoneNumberStatus.fromValue(status);
    }

    /**
     * <p>
     * The phone number status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhoneNumberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The phone number status.
     * @see PhoneNumberStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The phone number capabilities.
     * </p>
     * 
     * @return The phone number capabilities.
     */
    public final PhoneNumberCapabilities capabilities() {
        return capabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The phone number associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return The phone number associations.
     */
    public final List<PhoneNumberAssociation> associations() {
        return associations;
    }

    /**
     * <p>
     * The outbound calling name associated with the phone number.
     * </p>
     * 
     * @return The outbound calling name associated with the phone number.
     */
    public final String callingName() {
        return callingName;
    }

    /**
     * <p>
     * The outbound calling name status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callingNameStatus}
     * will return {@link CallingNameStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #callingNameStatusAsString}.
     * </p>
     * 
     * @return The outbound calling name status.
     * @see CallingNameStatus
     */
    public final CallingNameStatus callingNameStatus() {
        return CallingNameStatus.fromValue(callingNameStatus);
    }

    /**
     * <p>
     * The outbound calling name status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callingNameStatus}
     * will return {@link CallingNameStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #callingNameStatusAsString}.
     * </p>
     * 
     * @return The outbound calling name status.
     * @see CallingNameStatus
     */
    public final String callingNameStatusAsString() {
        return callingNameStatus;
    }

    /**
     * <p>
     * The phone number creation timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The phone number creation timestamp, in ISO 8601 format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The updated phone number timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The updated phone number timestamp, in ISO 8601 format.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * <p>
     * The deleted phone number timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The deleted phone number timestamp, in ISO 8601 format.
     */
    public final Instant deletionTimestamp() {
        return deletionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(e164PhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(callingName());
        hashCode = 31 * hashCode + Objects.hashCode(callingNameStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(deletionTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumber)) {
            return false;
        }
        PhoneNumber other = (PhoneNumber) obj;
        return Objects.equals(phoneNumberId(), other.phoneNumberId())
                && Objects.equals(e164PhoneNumber(), other.e164PhoneNumber()) && Objects.equals(country(), other.country())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(capabilities(), other.capabilities()) && hasAssociations() == other.hasAssociations()
                && Objects.equals(associations(), other.associations()) && Objects.equals(callingName(), other.callingName())
                && Objects.equals(callingNameStatusAsString(), other.callingNameStatusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp())
                && Objects.equals(deletionTimestamp(), other.deletionTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhoneNumber").add("PhoneNumberId", phoneNumberId())
                .add("E164PhoneNumber", e164PhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Country", country()).add("Type", typeAsString()).add("ProductType", productTypeAsString())
                .add("Status", statusAsString()).add("Capabilities", capabilities())
                .add("Associations", hasAssociations() ? associations() : null)
                .add("CallingName", callingName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CallingNameStatus", callingNameStatusAsString()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).add("DeletionTimestamp", deletionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberId":
            return Optional.ofNullable(clazz.cast(phoneNumberId()));
        case "E164PhoneNumber":
            return Optional.ofNullable(clazz.cast(e164PhoneNumber()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ProductType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "Associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "CallingName":
            return Optional.ofNullable(clazz.cast(callingName()));
        case "CallingNameStatus":
            return Optional.ofNullable(clazz.cast(callingNameStatusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "DeletionTimestamp":
            return Optional.ofNullable(clazz.cast(deletionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PhoneNumberId", PHONE_NUMBER_ID_FIELD);
        map.put("E164PhoneNumber", E164_PHONE_NUMBER_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ProductType", PRODUCT_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("Associations", ASSOCIATIONS_FIELD);
        map.put("CallingName", CALLING_NAME_FIELD);
        map.put("CallingNameStatus", CALLING_NAME_STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("DeletionTimestamp", DELETION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumber, T> g) {
        return obj -> g.apply((PhoneNumber) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhoneNumber> {
        /**
         * <p>
         * The phone number ID.
         * </p>
         * 
         * @param phoneNumberId
         *        The phone number ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberId(String phoneNumberId);

        /**
         * <p>
         * The phone number, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumber
         *        The phone number, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumber(String e164PhoneNumber);

        /**
         * <p>
         * The phone number country. Format: ISO 3166-1 alpha-2.
         * </p>
         * 
         * @param country
         *        The phone number country. Format: ISO 3166-1 alpha-2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The phone number type.
         * </p>
         * 
         * @param type
         *        The phone number type.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder type(String type);

        /**
         * <p>
         * The phone number type.
         * </p>
         * 
         * @param type
         *        The phone number type.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder type(PhoneNumberType type);

        /**
         * <p>
         * The phone number product type.
         * </p>
         * 
         * @param productType
         *        The phone number product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The phone number product type.
         * </p>
         * 
         * @param productType
         *        The phone number product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(PhoneNumberProductType productType);

        /**
         * <p>
         * The phone number status.
         * </p>
         * 
         * @param status
         *        The phone number status.
         * @see PhoneNumberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The phone number status.
         * </p>
         * 
         * @param status
         *        The phone number status.
         * @see PhoneNumberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberStatus
         */
        Builder status(PhoneNumberStatus status);

        /**
         * <p>
         * The phone number capabilities.
         * </p>
         * 
         * @param capabilities
         *        The phone number capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(PhoneNumberCapabilities capabilities);

        /**
         * <p>
         * The phone number capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhoneNumberCapabilities.Builder} avoiding
         * the need to create one manually via {@link PhoneNumberCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhoneNumberCapabilities.Builder#build()} is called immediately
         * and its result is passed to {@link #capabilities(PhoneNumberCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link PhoneNumberCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(PhoneNumberCapabilities)
         */
        default Builder capabilities(Consumer<PhoneNumberCapabilities.Builder> capabilities) {
            return capabilities(PhoneNumberCapabilities.builder().applyMutation(capabilities).build());
        }

        /**
         * <p>
         * The phone number associations.
         * </p>
         * 
         * @param associations
         *        The phone number associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<PhoneNumberAssociation> associations);

        /**
         * <p>
         * The phone number associations.
         * </p>
         * 
         * @param associations
         *        The phone number associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(PhoneNumberAssociation... associations);

        /**
         * <p>
         * The phone number associations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chime.model.PhoneNumberAssociation.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.chime.model.PhoneNumberAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chime.model.PhoneNumberAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #associations(List<PhoneNumberAssociation>)}.
         * 
         * @param associations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chime.model.PhoneNumberAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(java.util.Collection<PhoneNumberAssociation>)
         */
        Builder associations(Consumer<PhoneNumberAssociation.Builder>... associations);

        /**
         * <p>
         * The outbound calling name associated with the phone number.
         * </p>
         * 
         * @param callingName
         *        The outbound calling name associated with the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callingName(String callingName);

        /**
         * <p>
         * The outbound calling name status.
         * </p>
         * 
         * @param callingNameStatus
         *        The outbound calling name status.
         * @see CallingNameStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallingNameStatus
         */
        Builder callingNameStatus(String callingNameStatus);

        /**
         * <p>
         * The outbound calling name status.
         * </p>
         * 
         * @param callingNameStatus
         *        The outbound calling name status.
         * @see CallingNameStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallingNameStatus
         */
        Builder callingNameStatus(CallingNameStatus callingNameStatus);

        /**
         * <p>
         * The phone number creation timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The phone number creation timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The updated phone number timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The updated phone number timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * <p>
         * The deleted phone number timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param deletionTimestamp
         *        The deleted phone number timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionTimestamp(Instant deletionTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String phoneNumberId;

        private String e164PhoneNumber;

        private String country;

        private String type;

        private String productType;

        private String status;

        private PhoneNumberCapabilities capabilities;

        private List<PhoneNumberAssociation> associations = DefaultSdkAutoConstructList.getInstance();

        private String callingName;

        private String callingNameStatus;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private Instant deletionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumber model) {
            phoneNumberId(model.phoneNumberId);
            e164PhoneNumber(model.e164PhoneNumber);
            country(model.country);
            type(model.type);
            productType(model.productType);
            status(model.status);
            capabilities(model.capabilities);
            associations(model.associations);
            callingName(model.callingName);
            callingNameStatus(model.callingNameStatus);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            deletionTimestamp(model.deletionTimestamp);
        }

        public final String getPhoneNumberId() {
            return phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getE164PhoneNumber() {
            return e164PhoneNumber;
        }

        public final void setE164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
        }

        @Override
        public final Builder e164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PhoneNumberType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getProductType() {
            return productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PhoneNumberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final PhoneNumberCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(PhoneNumberCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(PhoneNumberCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final List<PhoneNumberAssociation.Builder> getAssociations() {
            List<PhoneNumberAssociation.Builder> result = PhoneNumberAssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<PhoneNumberAssociation.BuilderImpl> associations) {
            this.associations = PhoneNumberAssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<PhoneNumberAssociation> associations) {
            this.associations = PhoneNumberAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(PhoneNumberAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<PhoneNumberAssociation.Builder>... associations) {
            associations(Stream.of(associations).map(c -> PhoneNumberAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCallingName() {
            return callingName;
        }

        public final void setCallingName(String callingName) {
            this.callingName = callingName;
        }

        @Override
        public final Builder callingName(String callingName) {
            this.callingName = callingName;
            return this;
        }

        public final String getCallingNameStatus() {
            return callingNameStatus;
        }

        public final void setCallingNameStatus(String callingNameStatus) {
            this.callingNameStatus = callingNameStatus;
        }

        @Override
        public final Builder callingNameStatus(String callingNameStatus) {
            this.callingNameStatus = callingNameStatus;
            return this;
        }

        @Override
        public final Builder callingNameStatus(CallingNameStatus callingNameStatus) {
            this.callingNameStatus(callingNameStatus == null ? null : callingNameStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final Instant getDeletionTimestamp() {
            return deletionTimestamp;
        }

        public final void setDeletionTimestamp(Instant deletionTimestamp) {
            this.deletionTimestamp = deletionTimestamp;
        }

        @Override
        public final Builder deletionTimestamp(Instant deletionTimestamp) {
            this.deletionTimestamp = deletionTimestamp;
            return this;
        }

        @Override
        public PhoneNumber build() {
            return new PhoneNumber(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
