/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVoiceConnectorProxyRequest extends ChimeRequest implements
        ToCopyableBuilder<PutVoiceConnectorProxyRequest.Builder, PutVoiceConnectorProxyRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId").getter(getter(PutVoiceConnectorProxyRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()).build();

    private static final SdkField<Integer> DEFAULT_SESSION_EXPIRY_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultSessionExpiryMinutes")
            .getter(getter(PutVoiceConnectorProxyRequest::defaultSessionExpiryMinutes))
            .setter(setter(Builder::defaultSessionExpiryMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSessionExpiryMinutes")
                    .build()).build();

    private static final SdkField<List<String>> PHONE_NUMBER_POOL_COUNTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PhoneNumberPoolCountries")
            .getter(getter(PutVoiceConnectorProxyRequest::phoneNumberPoolCountries))
            .setter(setter(Builder::phoneNumberPoolCountries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberPoolCountries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FALL_BACK_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FallBackPhoneNumber").getter(getter(PutVoiceConnectorProxyRequest::fallBackPhoneNumber))
            .setter(setter(Builder::fallBackPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallBackPhoneNumber").build())
            .build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(PutVoiceConnectorProxyRequest::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VOICE_CONNECTOR_ID_FIELD, DEFAULT_SESSION_EXPIRY_MINUTES_FIELD, PHONE_NUMBER_POOL_COUNTRIES_FIELD,
                    FALL_BACK_PHONE_NUMBER_FIELD, DISABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String voiceConnectorId;

    private final Integer defaultSessionExpiryMinutes;

    private final List<String> phoneNumberPoolCountries;

    private final String fallBackPhoneNumber;

    private final Boolean disabled;

    private PutVoiceConnectorProxyRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.defaultSessionExpiryMinutes = builder.defaultSessionExpiryMinutes;
        this.phoneNumberPoolCountries = builder.phoneNumberPoolCountries;
        this.fallBackPhoneNumber = builder.fallBackPhoneNumber;
        this.disabled = builder.disabled;
    }

    /**
     * <p>
     * The Amazon Chime voice connector ID.
     * </p>
     * 
     * @return The Amazon Chime voice connector ID.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The default number of minutes allowed for proxy sessions.
     * </p>
     * 
     * @return The default number of minutes allowed for proxy sessions.
     */
    public final Integer defaultSessionExpiryMinutes() {
        return defaultSessionExpiryMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhoneNumberPoolCountries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhoneNumberPoolCountries() {
        return phoneNumberPoolCountries != null && !(phoneNumberPoolCountries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The countries for proxy phone numbers to be selected from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhoneNumberPoolCountries} method.
     * </p>
     * 
     * @return The countries for proxy phone numbers to be selected from.
     */
    public final List<String> phoneNumberPoolCountries() {
        return phoneNumberPoolCountries;
    }

    /**
     * <p>
     * The phone number to route calls to after a proxy session expires.
     * </p>
     * 
     * @return The phone number to route calls to after a proxy session expires.
     */
    public final String fallBackPhoneNumber() {
        return fallBackPhoneNumber;
    }

    /**
     * <p>
     * When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
     * </p>
     * 
     * @return When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
     */
    public final Boolean disabled() {
        return disabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSessionExpiryMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumberPoolCountries() ? phoneNumberPoolCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fallBackPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorProxyRequest)) {
            return false;
        }
        PutVoiceConnectorProxyRequest other = (PutVoiceConnectorProxyRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && Objects.equals(defaultSessionExpiryMinutes(), other.defaultSessionExpiryMinutes())
                && hasPhoneNumberPoolCountries() == other.hasPhoneNumberPoolCountries()
                && Objects.equals(phoneNumberPoolCountries(), other.phoneNumberPoolCountries())
                && Objects.equals(fallBackPhoneNumber(), other.fallBackPhoneNumber())
                && Objects.equals(disabled(), other.disabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutVoiceConnectorProxyRequest").add("VoiceConnectorId", voiceConnectorId())
                .add("DefaultSessionExpiryMinutes", defaultSessionExpiryMinutes())
                .add("PhoneNumberPoolCountries", hasPhoneNumberPoolCountries() ? phoneNumberPoolCountries() : null)
                .add("FallBackPhoneNumber", fallBackPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Disabled", disabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "DefaultSessionExpiryMinutes":
            return Optional.ofNullable(clazz.cast(defaultSessionExpiryMinutes()));
        case "PhoneNumberPoolCountries":
            return Optional.ofNullable(clazz.cast(phoneNumberPoolCountries()));
        case "FallBackPhoneNumber":
            return Optional.ofNullable(clazz.cast(fallBackPhoneNumber()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("voiceConnectorId", VOICE_CONNECTOR_ID_FIELD);
        map.put("DefaultSessionExpiryMinutes", DEFAULT_SESSION_EXPIRY_MINUTES_FIELD);
        map.put("PhoneNumberPoolCountries", PHONE_NUMBER_POOL_COUNTRIES_FIELD);
        map.put("FallBackPhoneNumber", FALL_BACK_PHONE_NUMBER_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorProxyRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorProxyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutVoiceConnectorProxyRequest> {
        /**
         * <p>
         * The Amazon Chime voice connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Amazon Chime voice connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The default number of minutes allowed for proxy sessions.
         * </p>
         * 
         * @param defaultSessionExpiryMinutes
         *        The default number of minutes allowed for proxy sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes);

        /**
         * <p>
         * The countries for proxy phone numbers to be selected from.
         * </p>
         * 
         * @param phoneNumberPoolCountries
         *        The countries for proxy phone numbers to be selected from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberPoolCountries(Collection<String> phoneNumberPoolCountries);

        /**
         * <p>
         * The countries for proxy phone numbers to be selected from.
         * </p>
         * 
         * @param phoneNumberPoolCountries
         *        The countries for proxy phone numbers to be selected from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberPoolCountries(String... phoneNumberPoolCountries);

        /**
         * <p>
         * The phone number to route calls to after a proxy session expires.
         * </p>
         * 
         * @param fallBackPhoneNumber
         *        The phone number to route calls to after a proxy session expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fallBackPhoneNumber(String fallBackPhoneNumber);

        /**
         * <p>
         * When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
         * </p>
         * 
         * @param disabled
         *        When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private Integer defaultSessionExpiryMinutes;

        private List<String> phoneNumberPoolCountries = DefaultSdkAutoConstructList.getInstance();

        private String fallBackPhoneNumber;

        private Boolean disabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorProxyRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            defaultSessionExpiryMinutes(model.defaultSessionExpiryMinutes);
            phoneNumberPoolCountries(model.phoneNumberPoolCountries);
            fallBackPhoneNumber(model.fallBackPhoneNumber);
            disabled(model.disabled);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final Integer getDefaultSessionExpiryMinutes() {
            return defaultSessionExpiryMinutes;
        }

        public final void setDefaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
            this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes;
        }

        @Override
        public final Builder defaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
            this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes;
            return this;
        }

        public final Collection<String> getPhoneNumberPoolCountries() {
            if (phoneNumberPoolCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return phoneNumberPoolCountries;
        }

        public final void setPhoneNumberPoolCountries(Collection<String> phoneNumberPoolCountries) {
            this.phoneNumberPoolCountries = CountryListCopier.copy(phoneNumberPoolCountries);
        }

        @Override
        public final Builder phoneNumberPoolCountries(Collection<String> phoneNumberPoolCountries) {
            this.phoneNumberPoolCountries = CountryListCopier.copy(phoneNumberPoolCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberPoolCountries(String... phoneNumberPoolCountries) {
            phoneNumberPoolCountries(Arrays.asList(phoneNumberPoolCountries));
            return this;
        }

        public final String getFallBackPhoneNumber() {
            return fallBackPhoneNumber;
        }

        public final void setFallBackPhoneNumber(String fallBackPhoneNumber) {
            this.fallBackPhoneNumber = fallBackPhoneNumber;
        }

        @Override
        public final Builder fallBackPhoneNumber(String fallBackPhoneNumber) {
            this.fallBackPhoneNumber = fallBackPhoneNumber;
            return this;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorProxyRequest build() {
            return new PutVoiceConnectorProxyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
