/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retention settings for an Amazon Chime Enterprise account that determine how long to retain items such as
 * chat-room messages and chat-conversation messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<RetentionSettings.Builder, RetentionSettings> {
    private static final SdkField<RoomRetentionSettings> ROOM_RETENTION_SETTINGS_FIELD = SdkField
            .<RoomRetentionSettings> builder(MarshallingType.SDK_POJO).memberName("RoomRetentionSettings")
            .getter(getter(RetentionSettings::roomRetentionSettings)).setter(setter(Builder::roomRetentionSettings))
            .constructor(RoomRetentionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomRetentionSettings").build())
            .build();

    private static final SdkField<ConversationRetentionSettings> CONVERSATION_RETENTION_SETTINGS_FIELD = SdkField
            .<ConversationRetentionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("ConversationRetentionSettings")
            .getter(getter(RetentionSettings::conversationRetentionSettings))
            .setter(setter(Builder::conversationRetentionSettings))
            .constructor(ConversationRetentionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversationRetentionSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_RETENTION_SETTINGS_FIELD,
            CONVERSATION_RETENTION_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RoomRetentionSettings roomRetentionSettings;

    private final ConversationRetentionSettings conversationRetentionSettings;

    private RetentionSettings(BuilderImpl builder) {
        this.roomRetentionSettings = builder.roomRetentionSettings;
        this.conversationRetentionSettings = builder.conversationRetentionSettings;
    }

    /**
     * <p>
     * The chat room retention settings.
     * </p>
     * 
     * @return The chat room retention settings.
     */
    public final RoomRetentionSettings roomRetentionSettings() {
        return roomRetentionSettings;
    }

    /**
     * <p>
     * The chat conversation retention settings.
     * </p>
     * 
     * @return The chat conversation retention settings.
     */
    public final ConversationRetentionSettings conversationRetentionSettings() {
        return conversationRetentionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomRetentionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(conversationRetentionSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionSettings)) {
            return false;
        }
        RetentionSettings other = (RetentionSettings) obj;
        return Objects.equals(roomRetentionSettings(), other.roomRetentionSettings())
                && Objects.equals(conversationRetentionSettings(), other.conversationRetentionSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetentionSettings").add("RoomRetentionSettings", roomRetentionSettings())
                .add("ConversationRetentionSettings", conversationRetentionSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomRetentionSettings":
            return Optional.ofNullable(clazz.cast(roomRetentionSettings()));
        case "ConversationRetentionSettings":
            return Optional.ofNullable(clazz.cast(conversationRetentionSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoomRetentionSettings", ROOM_RETENTION_SETTINGS_FIELD);
        map.put("ConversationRetentionSettings", CONVERSATION_RETENTION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetentionSettings, T> g) {
        return obj -> g.apply((RetentionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionSettings> {
        /**
         * <p>
         * The chat room retention settings.
         * </p>
         * 
         * @param roomRetentionSettings
         *        The chat room retention settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomRetentionSettings(RoomRetentionSettings roomRetentionSettings);

        /**
         * <p>
         * The chat room retention settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoomRetentionSettings.Builder} avoiding
         * the need to create one manually via {@link RoomRetentionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoomRetentionSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #roomRetentionSettings(RoomRetentionSettings)}.
         * 
         * @param roomRetentionSettings
         *        a consumer that will call methods on {@link RoomRetentionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roomRetentionSettings(RoomRetentionSettings)
         */
        default Builder roomRetentionSettings(Consumer<RoomRetentionSettings.Builder> roomRetentionSettings) {
            return roomRetentionSettings(RoomRetentionSettings.builder().applyMutation(roomRetentionSettings).build());
        }

        /**
         * <p>
         * The chat conversation retention settings.
         * </p>
         * 
         * @param conversationRetentionSettings
         *        The chat conversation retention settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationRetentionSettings(ConversationRetentionSettings conversationRetentionSettings);

        /**
         * <p>
         * The chat conversation retention settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationRetentionSettings.Builder}
         * avoiding the need to create one manually via {@link ConversationRetentionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationRetentionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #conversationRetentionSettings(ConversationRetentionSettings)}.
         * 
         * @param conversationRetentionSettings
         *        a consumer that will call methods on {@link ConversationRetentionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationRetentionSettings(ConversationRetentionSettings)
         */
        default Builder conversationRetentionSettings(
                Consumer<ConversationRetentionSettings.Builder> conversationRetentionSettings) {
            return conversationRetentionSettings(ConversationRetentionSettings.builder()
                    .applyMutation(conversationRetentionSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RoomRetentionSettings roomRetentionSettings;

        private ConversationRetentionSettings conversationRetentionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionSettings model) {
            roomRetentionSettings(model.roomRetentionSettings);
            conversationRetentionSettings(model.conversationRetentionSettings);
        }

        public final RoomRetentionSettings.Builder getRoomRetentionSettings() {
            return roomRetentionSettings != null ? roomRetentionSettings.toBuilder() : null;
        }

        public final void setRoomRetentionSettings(RoomRetentionSettings.BuilderImpl roomRetentionSettings) {
            this.roomRetentionSettings = roomRetentionSettings != null ? roomRetentionSettings.build() : null;
        }

        @Override
        public final Builder roomRetentionSettings(RoomRetentionSettings roomRetentionSettings) {
            this.roomRetentionSettings = roomRetentionSettings;
            return this;
        }

        public final ConversationRetentionSettings.Builder getConversationRetentionSettings() {
            return conversationRetentionSettings != null ? conversationRetentionSettings.toBuilder() : null;
        }

        public final void setConversationRetentionSettings(ConversationRetentionSettings.BuilderImpl conversationRetentionSettings) {
            this.conversationRetentionSettings = conversationRetentionSettings != null ? conversationRetentionSettings.build()
                    : null;
        }

        @Override
        public final Builder conversationRetentionSettings(ConversationRetentionSettings conversationRetentionSettings) {
            this.conversationRetentionSettings = conversationRetentionSettings;
            return this;
        }

        @Override
        public RetentionSettings build() {
            return new RetentionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
