/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that allow management of telephony permissions for an Amazon Chime user, such as inbound and outbound
 * calling and text messaging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelephonySettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TelephonySettings.Builder, TelephonySettings> {
    private static final SdkField<Boolean> INBOUND_CALLING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InboundCalling").getter(getter(TelephonySettings::inboundCalling))
            .setter(setter(Builder::inboundCalling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundCalling").build()).build();

    private static final SdkField<Boolean> OUTBOUND_CALLING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OutboundCalling").getter(getter(TelephonySettings::outboundCalling))
            .setter(setter(Builder::outboundCalling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCalling").build()).build();

    private static final SdkField<Boolean> SMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("SMS")
            .getter(getter(TelephonySettings::sms)).setter(setter(Builder::sms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMS").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOUND_CALLING_FIELD,
            OUTBOUND_CALLING_FIELD, SMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean inboundCalling;

    private final Boolean outboundCalling;

    private final Boolean sms;

    private TelephonySettings(BuilderImpl builder) {
        this.inboundCalling = builder.inboundCalling;
        this.outboundCalling = builder.outboundCalling;
        this.sms = builder.sms;
    }

    /**
     * <p>
     * Allows or denies inbound calling.
     * </p>
     * 
     * @return Allows or denies inbound calling.
     */
    public final Boolean inboundCalling() {
        return inboundCalling;
    }

    /**
     * <p>
     * Allows or denies outbound calling.
     * </p>
     * 
     * @return Allows or denies outbound calling.
     */
    public final Boolean outboundCalling() {
        return outboundCalling;
    }

    /**
     * <p>
     * Allows or denies SMS messaging.
     * </p>
     * 
     * @return Allows or denies SMS messaging.
     */
    public final Boolean sms() {
        return sms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inboundCalling());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCalling());
        hashCode = 31 * hashCode + Objects.hashCode(sms());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelephonySettings)) {
            return false;
        }
        TelephonySettings other = (TelephonySettings) obj;
        return Objects.equals(inboundCalling(), other.inboundCalling())
                && Objects.equals(outboundCalling(), other.outboundCalling()) && Objects.equals(sms(), other.sms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelephonySettings").add("InboundCalling", inboundCalling())
                .add("OutboundCalling", outboundCalling()).add("SMS", sms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InboundCalling":
            return Optional.ofNullable(clazz.cast(inboundCalling()));
        case "OutboundCalling":
            return Optional.ofNullable(clazz.cast(outboundCalling()));
        case "SMS":
            return Optional.ofNullable(clazz.cast(sms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InboundCalling", INBOUND_CALLING_FIELD);
        map.put("OutboundCalling", OUTBOUND_CALLING_FIELD);
        map.put("SMS", SMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelephonySettings, T> g) {
        return obj -> g.apply((TelephonySettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelephonySettings> {
        /**
         * <p>
         * Allows or denies inbound calling.
         * </p>
         * 
         * @param inboundCalling
         *        Allows or denies inbound calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundCalling(Boolean inboundCalling);

        /**
         * <p>
         * Allows or denies outbound calling.
         * </p>
         * 
         * @param outboundCalling
         *        Allows or denies outbound calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCalling(Boolean outboundCalling);

        /**
         * <p>
         * Allows or denies SMS messaging.
         * </p>
         * 
         * @param sms
         *        Allows or denies SMS messaging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sms(Boolean sms);
    }

    static final class BuilderImpl implements Builder {
        private Boolean inboundCalling;

        private Boolean outboundCalling;

        private Boolean sms;

        private BuilderImpl() {
        }

        private BuilderImpl(TelephonySettings model) {
            inboundCalling(model.inboundCalling);
            outboundCalling(model.outboundCalling);
            sms(model.sms);
        }

        public final Boolean getInboundCalling() {
            return inboundCalling;
        }

        public final void setInboundCalling(Boolean inboundCalling) {
            this.inboundCalling = inboundCalling;
        }

        @Override
        public final Builder inboundCalling(Boolean inboundCalling) {
            this.inboundCalling = inboundCalling;
            return this;
        }

        public final Boolean getOutboundCalling() {
            return outboundCalling;
        }

        public final void setOutboundCalling(Boolean outboundCalling) {
            this.outboundCalling = outboundCalling;
        }

        @Override
        public final Builder outboundCalling(Boolean outboundCalling) {
            this.outboundCalling = outboundCalling;
            return this;
        }

        public final Boolean getSms() {
            return sms;
        }

        public final void setSms(Boolean sms) {
            this.sms = sms;
        }

        @Override
        public final Builder sms(Boolean sms) {
            this.sms = sms;
            return this;
        }

        @Override
        public TelephonySettings build() {
            return new TelephonySettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
