/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType;
import software.amazon.awssdk.services.chime.model.ChannelMessageType;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendChannelMessageRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, SendChannelMessageRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(SendChannelMessageRequest.getter(SendChannelMessageRequest::channelArn)).setter(SendChannelMessageRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(SendChannelMessageRequest.getter(SendChannelMessageRequest::content)).setter(SendChannelMessageRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SendChannelMessageRequest.getter(SendChannelMessageRequest::typeAsString)).setter(SendChannelMessageRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> PERSISTENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Persistence").getter(SendChannelMessageRequest.getter(SendChannelMessageRequest::persistenceAsString)).setter(SendChannelMessageRequest.setter(Builder::persistence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persistence").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(SendChannelMessageRequest.getter(SendChannelMessageRequest::metadata)).setter(SendChannelMessageRequest.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(SendChannelMessageRequest.getter(SendChannelMessageRequest::clientRequestToken)).setter(SendChannelMessageRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChimeBearer").getter(SendChannelMessageRequest.getter(SendChannelMessageRequest::chimeBearer)).setter(SendChannelMessageRequest.setter(Builder::chimeBearer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CONTENT_FIELD, TYPE_FIELD, PERSISTENCE_FIELD, METADATA_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CHIME_BEARER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendChannelMessageRequest.memberNameToFieldInitializer();
    private final String channelArn;
    private final String content;
    private final String type;
    private final String persistence;
    private final String metadata;
    private final String clientRequestToken;
    private final String chimeBearer;

    private SendChannelMessageRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.content = builder.content;
        this.type = builder.type;
        this.persistence = builder.persistence;
        this.metadata = builder.metadata;
        this.clientRequestToken = builder.clientRequestToken;
        this.chimeBearer = builder.chimeBearer;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String content() {
        return this.content;
    }

    public final ChannelMessageType type() {
        return ChannelMessageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ChannelMessagePersistenceType persistence() {
        return ChannelMessagePersistenceType.fromValue(this.persistence);
    }

    public final String persistenceAsString() {
        return this.persistence;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String chimeBearer() {
        return this.chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeBearer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendChannelMessageRequest)) {
            return false;
        }
        SendChannelMessageRequest other = (SendChannelMessageRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.persistenceAsString(), other.persistenceAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.chimeBearer(), other.chimeBearer());
    }

    public final String toString() {
        return ToString.builder((String)"SendChannelMessageRequest").add("ChannelArn", (Object)this.channelArn()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("Persistence", (Object)this.persistenceAsString()).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ChimeBearer", (Object)this.chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Persistence": {
                return Optional.ofNullable(clazz.cast(this.persistenceAsString()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "ChimeBearer": {
                return Optional.ofNullable(clazz.cast(this.chimeBearer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Persistence", PERSISTENCE_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("x-amz-chime-bearer", CHIME_BEARER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendChannelMessageRequest, T> g) {
        return obj -> g.apply((SendChannelMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String content;
        private String type;
        private String persistence;
        private String metadata;
        private String clientRequestToken;
        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(SendChannelMessageRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.content(model.content);
            this.type(model.type);
            this.persistence(model.persistence);
            this.metadata(model.metadata);
            this.clientRequestToken(model.clientRequestToken);
            this.chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelMessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPersistence() {
            return this.persistence;
        }

        public final void setPersistence(String persistence) {
            this.persistence = persistence;
        }

        @Override
        public final Builder persistence(String persistence) {
            this.persistence = persistence;
            return this;
        }

        @Override
        public final Builder persistence(ChannelMessagePersistenceType persistence) {
            this.persistence(persistence == null ? null : persistence.toString());
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getChimeBearer() {
            return this.chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendChannelMessageRequest build() {
            return new SendChannelMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendChannelMessageRequest> {
        public Builder channelArn(String var1);

        public Builder content(String var1);

        public Builder type(String var1);

        public Builder type(ChannelMessageType var1);

        public Builder persistence(String var1);

        public Builder persistence(ChannelMessagePersistenceType var1);

        public Builder metadata(String var1);

        public Builder clientRequestToken(String var1);

        public Builder chimeBearer(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

