/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeCapabilities;
import software.amazon.awssdk.services.chimesdkmeetings.model.ChimeSdkMeetingsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAttendeeRequest
extends ChimeSdkMeetingsRequest
implements ToCopyableBuilder<Builder, CreateAttendeeRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingId").getter(CreateAttendeeRequest.getter(CreateAttendeeRequest::meetingId)).setter(CreateAttendeeRequest.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MeetingId").build()}).build();
    private static final SdkField<String> EXTERNAL_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalUserId").getter(CreateAttendeeRequest.getter(CreateAttendeeRequest::externalUserId)).setter(CreateAttendeeRequest.setter(Builder::externalUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalUserId").build()}).build();
    private static final SdkField<AttendeeCapabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capabilities").getter(CreateAttendeeRequest.getter(CreateAttendeeRequest::capabilities)).setter(CreateAttendeeRequest.setter(Builder::capabilities)).constructor(AttendeeCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD, EXTERNAL_USER_ID_FIELD, CAPABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MeetingId", MEETING_ID_FIELD);
            this.put("ExternalUserId", EXTERNAL_USER_ID_FIELD);
            this.put("Capabilities", CAPABILITIES_FIELD);
        }
    });
    private final String meetingId;
    private final String externalUserId;
    private final AttendeeCapabilities capabilities;

    private CreateAttendeeRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.externalUserId = builder.externalUserId;
        this.capabilities = builder.capabilities;
    }

    public final String meetingId() {
        return this.meetingId;
    }

    public final String externalUserId() {
        return this.externalUserId;
    }

    public final AttendeeCapabilities capabilities() {
        return this.capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAttendeeRequest)) {
            return false;
        }
        CreateAttendeeRequest other = (CreateAttendeeRequest)((Object)obj);
        return Objects.equals(this.meetingId(), other.meetingId()) && Objects.equals(this.externalUserId(), other.externalUserId()) && Objects.equals(this.capabilities(), other.capabilities());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAttendeeRequest").add("MeetingId", (Object)this.meetingId()).add("ExternalUserId", (Object)(this.externalUserId() == null ? null : "*** Sensitive Data Redacted ***")).add("Capabilities", (Object)this.capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
            case "ExternalUserId": {
                return Optional.ofNullable(clazz.cast(this.externalUserId()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAttendeeRequest, T> g) {
        return obj -> g.apply((CreateAttendeeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMeetingsRequest.BuilderImpl
    implements Builder {
        private String meetingId;
        private String externalUserId;
        private AttendeeCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAttendeeRequest model) {
            super(model);
            this.meetingId(model.meetingId);
            this.externalUserId(model.externalUserId);
            this.capabilities(model.capabilities);
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final String getExternalUserId() {
            return this.externalUserId;
        }

        public final void setExternalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
        }

        @Override
        public final Builder externalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
            return this;
        }

        public final AttendeeCapabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(AttendeeCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(AttendeeCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAttendeeRequest build() {
            return new CreateAttendeeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMeetingsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAttendeeRequest> {
        public Builder meetingId(String var1);

        public Builder externalUserId(String var1);

        public Builder capabilities(AttendeeCapabilities var1);

        default public Builder capabilities(Consumer<AttendeeCapabilities.Builder> capabilities) {
            return this.capabilities((AttendeeCapabilities)((AttendeeCapabilities.Builder)AttendeeCapabilities.builder().applyMutation(capabilities)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

