/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates an index object inside of a <a>BatchRead</a> operation. For more information, see <a>CreateIndex</a> and
 * <a>BatchReadRequest$Operations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateIndex implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchCreateIndex.Builder, BatchCreateIndex> {
    private static final SdkField<List<AttributeKey>> ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD = SdkField
            .<List<AttributeKey>> builder(MarshallingType.LIST)
            .memberName("OrderedIndexedAttributeList")
            .getter(getter(BatchCreateIndex::orderedIndexedAttributeList))
            .setter(setter(Builder::orderedIndexedAttributeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedIndexedAttributeList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_UNIQUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsUnique").getter(getter(BatchCreateIndex::isUnique)).setter(setter(Builder::isUnique))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsUnique").build()).build();

    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ParentReference")
            .getter(getter(BatchCreateIndex::parentReference)).setter(setter(Builder::parentReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()).build();

    private static final SdkField<String> LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkName").getter(getter(BatchCreateIndex::linkName)).setter(setter(Builder::linkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()).build();

    private static final SdkField<String> BATCH_REFERENCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchReferenceName").getter(getter(BatchCreateIndex::batchReferenceName))
            .setter(setter(Builder::batchReferenceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchReferenceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD, IS_UNIQUE_FIELD, PARENT_REFERENCE_FIELD, LINK_NAME_FIELD,
            BATCH_REFERENCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AttributeKey> orderedIndexedAttributeList;

    private final Boolean isUnique;

    private final ObjectReference parentReference;

    private final String linkName;

    private final String batchReferenceName;

    private BatchCreateIndex(BuilderImpl builder) {
        this.orderedIndexedAttributeList = builder.orderedIndexedAttributeList;
        this.isUnique = builder.isUnique;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
        this.batchReferenceName = builder.batchReferenceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrderedIndexedAttributeList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrderedIndexedAttributeList() {
        return orderedIndexedAttributeList != null && !(orderedIndexedAttributeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrderedIndexedAttributeList} method.
     * </p>
     * 
     * @return Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
     */
    public final List<AttributeKey> orderedIndexedAttributeList() {
        return orderedIndexedAttributeList;
    }

    /**
     * <p>
     * Indicates whether the attribute that is being indexed has unique values or not.
     * </p>
     * 
     * @return Indicates whether the attribute that is being indexed has unique values or not.
     */
    public final Boolean isUnique() {
        return isUnique;
    }

    /**
     * <p>
     * A reference to the parent object that contains the index object.
     * </p>
     * 
     * @return A reference to the parent object that contains the index object.
     */
    public final ObjectReference parentReference() {
        return parentReference;
    }

    /**
     * <p>
     * The name of the link between the parent object and the index object.
     * </p>
     * 
     * @return The name of the link between the parent object and the index object.
     */
    public final String linkName() {
        return linkName;
    }

    /**
     * <p>
     * The batch reference name. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction
     * Support</a> for more information.
     * </p>
     * 
     * @return The batch reference name. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html"
     *         >Transaction Support</a> for more information.
     */
    public final String batchReferenceName() {
        return batchReferenceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderedIndexedAttributeList() ? orderedIndexedAttributeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isUnique());
        hashCode = 31 * hashCode + Objects.hashCode(parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(linkName());
        hashCode = 31 * hashCode + Objects.hashCode(batchReferenceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateIndex)) {
            return false;
        }
        BatchCreateIndex other = (BatchCreateIndex) obj;
        return hasOrderedIndexedAttributeList() == other.hasOrderedIndexedAttributeList()
                && Objects.equals(orderedIndexedAttributeList(), other.orderedIndexedAttributeList())
                && Objects.equals(isUnique(), other.isUnique()) && Objects.equals(parentReference(), other.parentReference())
                && Objects.equals(linkName(), other.linkName())
                && Objects.equals(batchReferenceName(), other.batchReferenceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateIndex")
                .add("OrderedIndexedAttributeList", hasOrderedIndexedAttributeList() ? orderedIndexedAttributeList() : null)
                .add("IsUnique", isUnique()).add("ParentReference", parentReference()).add("LinkName", linkName())
                .add("BatchReferenceName", batchReferenceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrderedIndexedAttributeList":
            return Optional.ofNullable(clazz.cast(orderedIndexedAttributeList()));
        case "IsUnique":
            return Optional.ofNullable(clazz.cast(isUnique()));
        case "ParentReference":
            return Optional.ofNullable(clazz.cast(parentReference()));
        case "LinkName":
            return Optional.ofNullable(clazz.cast(linkName()));
        case "BatchReferenceName":
            return Optional.ofNullable(clazz.cast(batchReferenceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrderedIndexedAttributeList", ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD);
        map.put("IsUnique", IS_UNIQUE_FIELD);
        map.put("ParentReference", PARENT_REFERENCE_FIELD);
        map.put("LinkName", LINK_NAME_FIELD);
        map.put("BatchReferenceName", BATCH_REFERENCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateIndex, T> g) {
        return obj -> g.apply((BatchCreateIndex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchCreateIndex> {
        /**
         * <p>
         * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * </p>
         * 
         * @param orderedIndexedAttributeList
         *        Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList);

        /**
         * <p>
         * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * </p>
         * 
         * @param orderedIndexedAttributeList
         *        Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedIndexedAttributeList(AttributeKey... orderedIndexedAttributeList);

        /**
         * <p>
         * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.clouddirectory.model.AttributeKey.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.clouddirectory.model.AttributeKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.clouddirectory.model.AttributeKey.Builder#build()} is called
         * immediately and its result is passed to {@link #orderedIndexedAttributeList(List<AttributeKey>)}.
         * 
         * @param orderedIndexedAttributeList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.clouddirectory.model.AttributeKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderedIndexedAttributeList(java.util.Collection<AttributeKey>)
         */
        Builder orderedIndexedAttributeList(Consumer<AttributeKey.Builder>... orderedIndexedAttributeList);

        /**
         * <p>
         * Indicates whether the attribute that is being indexed has unique values or not.
         * </p>
         * 
         * @param isUnique
         *        Indicates whether the attribute that is being indexed has unique values or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isUnique(Boolean isUnique);

        /**
         * <p>
         * A reference to the parent object that contains the index object.
         * </p>
         * 
         * @param parentReference
         *        A reference to the parent object that contains the index object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentReference(ObjectReference parentReference);

        /**
         * <p>
         * A reference to the parent object that contains the index object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #parentReference(ObjectReference)}.
         * 
         * @param parentReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentReference(ObjectReference)
         */
        default Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return parentReference(ObjectReference.builder().applyMutation(parentReference).build());
        }

        /**
         * <p>
         * The name of the link between the parent object and the index object.
         * </p>
         * 
         * @param linkName
         *        The name of the link between the parent object and the index object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkName(String linkName);

        /**
         * <p>
         * The batch reference name. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html">Transaction
         * Support</a> for more information.
         * </p>
         * 
         * @param batchReferenceName
         *        The batch reference name. See <a
         *        href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html"
         *        >Transaction Support</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchReferenceName(String batchReferenceName);
    }

    static final class BuilderImpl implements Builder {
        private List<AttributeKey> orderedIndexedAttributeList = DefaultSdkAutoConstructList.getInstance();

        private Boolean isUnique;

        private ObjectReference parentReference;

        private String linkName;

        private String batchReferenceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateIndex model) {
            orderedIndexedAttributeList(model.orderedIndexedAttributeList);
            isUnique(model.isUnique);
            parentReference(model.parentReference);
            linkName(model.linkName);
            batchReferenceName(model.batchReferenceName);
        }

        public final List<AttributeKey.Builder> getOrderedIndexedAttributeList() {
            List<AttributeKey.Builder> result = AttributeKeyListCopier.copyToBuilder(this.orderedIndexedAttributeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderedIndexedAttributeList(Collection<AttributeKey.BuilderImpl> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copyFromBuilder(orderedIndexedAttributeList);
        }

        @Override
        public final Builder orderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copy(orderedIndexedAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(AttributeKey... orderedIndexedAttributeList) {
            orderedIndexedAttributeList(Arrays.asList(orderedIndexedAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(Consumer<AttributeKey.Builder>... orderedIndexedAttributeList) {
            orderedIndexedAttributeList(Stream.of(orderedIndexedAttributeList)
                    .map(c -> AttributeKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsUnique() {
            return isUnique;
        }

        public final void setIsUnique(Boolean isUnique) {
            this.isUnique = isUnique;
        }

        @Override
        public final Builder isUnique(Boolean isUnique) {
            this.isUnique = isUnique;
            return this;
        }

        public final ObjectReference.Builder getParentReference() {
            return parentReference != null ? parentReference.toBuilder() : null;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final String getLinkName() {
            return linkName;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final String getBatchReferenceName() {
            return batchReferenceName;
        }

        public final void setBatchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
        }

        @Override
        public final Builder batchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
            return this;
        }

        @Override
        public BatchCreateIndex build() {
            return new BatchCreateIndex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
