/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTypedLinkFacetInformationResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<GetTypedLinkFacetInformationResponse.Builder, GetTypedLinkFacetInformationResponse> {
    private static final SdkField<List<String>> IDENTITY_ATTRIBUTE_ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IdentityAttributeOrder")
            .getter(getter(GetTypedLinkFacetInformationResponse::identityAttributeOrder))
            .setter(setter(Builder::identityAttributeOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IDENTITY_ATTRIBUTE_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> identityAttributeOrder;

    private GetTypedLinkFacetInformationResponse(BuilderImpl builder) {
        super(builder);
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityAttributeOrder property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityAttributeOrder() {
        return identityAttributeOrder != null && !(identityAttributeOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The order of identity attributes for the facet, from most significant to least significant. The ability to filter
     * typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to
     * typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range
     * specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the
     * typed link facet, not the order in which they are supplied to any API calls. For more information about identity
     * attributes, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityAttributeOrder} method.
     * </p>
     * 
     * @return The order of identity attributes for the facet, from most significant to least significant. The ability
     *         to filter typed links considers the order that the attributes are defined on the typed link facet. When
     *         providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes
     *         that do not have a range specified are presumed to match the entire range. Filters are interpreted in the
     *         order of the attributes on the typed link facet, not the order in which they are supplied to any API
     *         calls. For more information about identity attributes, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final List<String> identityAttributeOrder() {
        return identityAttributeOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityAttributeOrder() ? identityAttributeOrder() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTypedLinkFacetInformationResponse)) {
            return false;
        }
        GetTypedLinkFacetInformationResponse other = (GetTypedLinkFacetInformationResponse) obj;
        return hasIdentityAttributeOrder() == other.hasIdentityAttributeOrder()
                && Objects.equals(identityAttributeOrder(), other.identityAttributeOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTypedLinkFacetInformationResponse")
                .add("IdentityAttributeOrder", hasIdentityAttributeOrder() ? identityAttributeOrder() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityAttributeOrder":
            return Optional.ofNullable(clazz.cast(identityAttributeOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityAttributeOrder", IDENTITY_ATTRIBUTE_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTypedLinkFacetInformationResponse, T> g) {
        return obj -> g.apply((GetTypedLinkFacetInformationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTypedLinkFacetInformationResponse> {
        /**
         * <p>
         * The order of identity attributes for the facet, from most significant to least significant. The ability to
         * filter typed links considers the order that the attributes are defined on the typed link facet. When
         * providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes
         * that do not have a range specified are presumed to match the entire range. Filters are interpreted in the
         * order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.
         * For more information about identity attributes, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param identityAttributeOrder
         *        The order of identity attributes for the facet, from most significant to least significant. The
         *        ability to filter typed links considers the order that the attributes are defined on the typed link
         *        facet. When providing ranges to typed link selection, any inexact ranges must be specified at the end.
         *        Any attributes that do not have a range specified are presumed to match the entire range. Filters are
         *        interpreted in the order of the attributes on the typed link facet, not the order in which they are
         *        supplied to any API calls. For more information about identity attributes, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeOrder(Collection<String> identityAttributeOrder);

        /**
         * <p>
         * The order of identity attributes for the facet, from most significant to least significant. The ability to
         * filter typed links considers the order that the attributes are defined on the typed link facet. When
         * providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes
         * that do not have a range specified are presumed to match the entire range. Filters are interpreted in the
         * order of the attributes on the typed link facet, not the order in which they are supplied to any API calls.
         * For more information about identity attributes, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param identityAttributeOrder
         *        The order of identity attributes for the facet, from most significant to least significant. The
         *        ability to filter typed links considers the order that the attributes are defined on the typed link
         *        facet. When providing ranges to typed link selection, any inexact ranges must be specified at the end.
         *        Any attributes that do not have a range specified are presumed to match the entire range. Filters are
         *        interpreted in the order of the attributes on the typed link facet, not the order in which they are
         *        supplied to any API calls. For more information about identity attributes, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeOrder(String... identityAttributeOrder);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<String> identityAttributeOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTypedLinkFacetInformationResponse model) {
            super(model);
            identityAttributeOrder(model.identityAttributeOrder);
        }

        public final Collection<String> getIdentityAttributeOrder() {
            if (identityAttributeOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return identityAttributeOrder;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String... identityAttributeOrder) {
            identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        @Override
        public GetTypedLinkFacetInformationResponse build() {
            return new GetTypedLinkFacetInformationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
