/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the schema Amazon Resource Name (ARN) and facet name for the typed link.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypedLinkSchemaAndFacetName implements SdkPojo, Serializable,
        ToCopyableBuilder<TypedLinkSchemaAndFacetName.Builder, TypedLinkSchemaAndFacetName> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(TypedLinkSchemaAndFacetName::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> TYPED_LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypedLinkName").getter(getter(TypedLinkSchemaAndFacetName::typedLinkName))
            .setter(setter(Builder::typedLinkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD,
            TYPED_LINK_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schemaArn;

    private final String typedLinkName;

    private TypedLinkSchemaAndFacetName(BuilderImpl builder) {
        this.schemaArn = builder.schemaArn;
        this.typedLinkName = builder.typedLinkName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <a>arns</a>.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The unique name of the typed link facet.
     * </p>
     * 
     * @return The unique name of the typed link facet.
     */
    public final String typedLinkName() {
        return typedLinkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(typedLinkName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkSchemaAndFacetName)) {
            return false;
        }
        TypedLinkSchemaAndFacetName other = (TypedLinkSchemaAndFacetName) obj;
        return Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(typedLinkName(), other.typedLinkName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypedLinkSchemaAndFacetName").add("SchemaArn", schemaArn())
                .add("TypedLinkName", typedLinkName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "TypedLinkName":
            return Optional.ofNullable(clazz.cast(typedLinkName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaArn", SCHEMA_ARN_FIELD);
        map.put("TypedLinkName", TYPED_LINK_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TypedLinkSchemaAndFacetName, T> g) {
        return obj -> g.apply((TypedLinkSchemaAndFacetName) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypedLinkSchemaAndFacetName> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the schema. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param schemaArn
         *        The Amazon Resource Name (ARN) that is associated with the schema. For more information, see
         *        <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The unique name of the typed link facet.
         * </p>
         * 
         * @param typedLinkName
         *        The unique name of the typed link facet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typedLinkName(String typedLinkName);
    }

    static final class BuilderImpl implements Builder {
        private String schemaArn;

        private String typedLinkName;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkSchemaAndFacetName model) {
            schemaArn(model.schemaArn);
            typedLinkName(model.typedLinkName);
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getTypedLinkName() {
            return typedLinkName;
        }

        public final void setTypedLinkName(String typedLinkName) {
            this.typedLinkName = typedLinkName;
        }

        @Override
        public final Builder typedLinkName(String typedLinkName) {
            this.typedLinkName = typedLinkName;
            return this;
        }

        @Override
        public TypedLinkSchemaAndFacetName build() {
            return new TypedLinkSchemaAndFacetName(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
