/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableZonesResponse extends CloudHsmResponse implements
        ToCopyableBuilder<ListAvailableZonesResponse.Builder, ListAvailableZonesResponse> {
    private static final SdkField<List<String>> AZ_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AZList")
            .getter(getter(ListAvailableZonesResponse::azList))
            .setter(setter(Builder::azList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AZList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AZ_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> azList;

    private ListAvailableZonesResponse(BuilderImpl builder) {
        super(builder);
        this.azList = builder.azList;
    }

    /**
     * For responses, this returns true if the service returned a value for the AZList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAzList() {
        return azList != null && !(azList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Availability Zones that have available AWS CloudHSM capacity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAzList} method.
     * </p>
     * 
     * @return The list of Availability Zones that have available AWS CloudHSM capacity.
     */
    public final List<String> azList() {
        return azList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAzList() ? azList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableZonesResponse)) {
            return false;
        }
        ListAvailableZonesResponse other = (ListAvailableZonesResponse) obj;
        return hasAzList() == other.hasAzList() && Objects.equals(azList(), other.azList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAvailableZonesResponse").add("AZList", hasAzList() ? azList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AZList":
            return Optional.ofNullable(clazz.cast(azList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AZList", AZ_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableZonesResponse, T> g) {
        return obj -> g.apply((ListAvailableZonesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAvailableZonesResponse> {
        /**
         * <p>
         * The list of Availability Zones that have available AWS CloudHSM capacity.
         * </p>
         * 
         * @param azList
         *        The list of Availability Zones that have available AWS CloudHSM capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azList(Collection<String> azList);

        /**
         * <p>
         * The list of Availability Zones that have available AWS CloudHSM capacity.
         * </p>
         * 
         * @param azList
         *        The list of Availability Zones that have available AWS CloudHSM capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azList(String... azList);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private List<String> azList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableZonesResponse model) {
            super(model);
            azList(model.azList);
        }

        public final Collection<String> getAzList() {
            if (azList instanceof SdkAutoConstructList) {
                return null;
            }
            return azList;
        }

        public final void setAzList(Collection<String> azList) {
            this.azList = AZListCopier.copy(azList);
        }

        @Override
        public final Builder azList(Collection<String> azList) {
            this.azList = AZListCopier.copy(azList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder azList(String... azList) {
            azList(Arrays.asList(azList));
            return this;
        }

        @Override
        public ListAvailableZonesResponse build() {
            return new ListAvailableZonesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
