/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.GenerateQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.GenerateQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartDashboardRefreshRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartDashboardRefreshResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListInsightsMetricDataPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher;

/**
 * Service client for accessing CloudTrail asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>CloudTrail</fullname>
 * <p>
 * This is the CloudTrail API Reference. It provides descriptions of actions, data types, common parameters, and common
 * errors for CloudTrail.
 * </p>
 * <p>
 * CloudTrail is a web service that records Amazon Web Services API calls for your Amazon Web Services account and
 * delivers log files to an Amazon S3 bucket. The recorded information includes the identity of the user, the start time
 * of the Amazon Web Services API call, the source IP address, the request parameters, and the response elements
 * returned by the service.
 * </p>
 * <note>
 * <p>
 * As an alternative to the API, you can use one of the Amazon Web Services SDKs, which consist of libraries and sample
 * code for various programming languages and platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs provide
 * programmatic access to CloudTrail. For example, the SDKs handle cryptographically signing requests, managing errors,
 * and retrying requests automatically. For more information about the Amazon Web Services SDKs, including how to
 * download and install them, see <a href="http://aws.amazon.com/tools/">Tools to Build on Amazon Web Services</a>.
 * </p>
 * </note>
 * <p>
 * See the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html">CloudTrail
 * User Guide</a> for information about the data that is included with each Amazon Web Services API call listed in the
 * log files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudTrailAsyncClient extends AwsClient {
    String SERVICE_NAME = "cloudtrail";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudtrail";

    /**
     * <p>
     * Adds one or more tags to a trail, event data store, dashboard, or channel, up to a limit of 50. Overwrites an
     * existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique; you
     * cannot have two keys with the same name but different values. If you specify a key without a value, the tag will
     * be created with the specified key and a value of null. You can tag a trail or event data store that applies to
     * all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also
     * known as its home Region).
     * </p>
     *
     * @param addTagsRequest
     *        Specifies the tags to add to a trail, event data store, dashboard, or channel.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>TagsLimitExceededException The number of tags per trail, event data store, dashboard, or channel has
     *         exceeded the permitted amount. Currently, the limit is 50.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a trail, event data store, dashboard, or channel, up to a limit of 50. Overwrites an
     * existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique; you
     * cannot have two keys with the same name but different values. If you specify a key without a value, the tag will
     * be created with the specified key and a value of null. You can tag a trail or event data store that applies to
     * all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also
     * known as its home Region).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.AddTagsRequest.Builder} to create a request.
     *        Specifies the tags to add to a trail, event data store, dashboard, or channel.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>TagsLimitExceededException The number of tags per trail, event data store, dashboard, or channel has
     *         exceeded the permitted amount. Currently, the limit is 50.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Cancels a query if the query is not in a terminated state, such as <code>CANCELLED</code>, <code>FAILED</code>,
     * <code>TIMED_OUT</code>, or <code>FINISHED</code>. You must specify an ARN value for <code>EventDataStore</code>.
     * The ID of the query that you want to cancel is also required. When you run <code>CancelQuery</code>, the query
     * status might show as <code>CANCELLED</code> even if the operation is not yet finished.
     * </p>
     *
     * @param cancelQueryRequest
     * @return A Java Future containing the result of the CancelQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InactiveQueryException The specified query cannot be canceled because it is in the
     *         <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code> state.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CancelQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CancelQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelQueryResponse> cancelQuery(CancelQueryRequest cancelQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a query if the query is not in a terminated state, such as <code>CANCELLED</code>, <code>FAILED</code>,
     * <code>TIMED_OUT</code>, or <code>FINISHED</code>. You must specify an ARN value for <code>EventDataStore</code>.
     * The ID of the query that you want to cancel is also required. When you run <code>CancelQuery</code>, the query
     * status might show as <code>CANCELLED</code> even if the operation is not yet finished.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelQueryRequest.Builder} avoiding the need to
     * create one manually via {@link CancelQueryRequest#builder()}
     * </p>
     *
     * @param cancelQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.CancelQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InactiveQueryException The specified query cannot be canceled because it is in the
     *         <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code> state.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CancelQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CancelQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelQueryResponse> cancelQuery(Consumer<CancelQueryRequest.Builder> cancelQueryRequest) {
        return cancelQuery(CancelQueryRequest.builder().applyMutation(cancelQueryRequest).build());
    }

    /**
     * <p>
     * Creates a channel for CloudTrail to ingest events from a partner or external source. After you create a channel,
     * a CloudTrail Lake event data store can log events from the partner or source that you specify.
     * </p>
     *
     * @param createChannelRequest
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChannelMaxLimitExceededException This exception is thrown when the maximum number of channels limit
     *         is exceeded.</li>
     *         <li>InvalidSourceException This exception is thrown when the specified value of <code>Source</code> is
     *         not valid.</li>
     *         <li>ChannelAlreadyExistsException This exception is thrown when the provided channel already exists.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>TagsLimitExceededException The number of tags per trail, event data store, dashboard, or channel has
     *         exceeded the permitted amount. Currently, the limit is 50.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a channel for CloudTrail to ingest events from a partner or external source. After you create a channel,
     * a CloudTrail Lake event data store can log events from the partner or source that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.CreateChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChannelMaxLimitExceededException This exception is thrown when the maximum number of channels limit
     *         is exceeded.</li>
     *         <li>InvalidSourceException This exception is thrown when the specified value of <code>Source</code> is
     *         not valid.</li>
     *         <li>ChannelAlreadyExistsException This exception is thrown when the provided channel already exists.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>TagsLimitExceededException The number of tags per trail, event data store, dashboard, or channel has
     *         exceeded the permitted amount. Currently, the limit is 50.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest) {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * <p>
     * Creates a custom dashboard or the Highlights dashboard.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Custom dashboards</b> - Custom dashboards allow you to query events in any event data store type. You can add
     * up to 10 widgets to a custom dashboard. You can manually refresh a custom dashboard, or you can set a refresh
     * schedule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Highlights dashboard</b> - You can create the Highlights dashboard to see a summary of key user activities and
     * API usage across all your event data stores. CloudTrail Lake manages the Highlights dashboard and refreshes the
     * dashboard every 6 hours. To create the Highlights dashboard, you must set and enable a refresh schedule.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must
     * be granted permissions to run the <code>StartQuery</code> operation on your behalf. To provide permissions, run
     * the <code>PutResourcePolicy</code> operation to attach a resource-based policy to each event data store. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard"
     * >Example: Allow CloudTrail to run queries to populate a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * To set a refresh schedule, CloudTrail must be granted permissions to run the <code>StartDashboardRefresh</code>
     * operation to refresh the dashboard on your behalf. To provide permissions, run the <code>PutResourcePolicy</code>
     * operation to attach a resource-based policy to the dashboard. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards"
     * > Resource-based policy example for a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * For more information about dashboards, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-dashboard.html">CloudTrail Lake
     * dashboards</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param createDashboardRequest
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidQueryStatementException The query that was submitted has validation errors, or uses incorrect
     *         syntax or unsupported keywords. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when the quota is exceeded. For information
     *         about CloudTrail quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ct.html#limits_cloudtrail">Service quotas</a> in the
     *         <i>Amazon Web Services General Reference</i>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDashboardResponse> createDashboard(CreateDashboardRequest createDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom dashboard or the Highlights dashboard.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Custom dashboards</b> - Custom dashboards allow you to query events in any event data store type. You can add
     * up to 10 widgets to a custom dashboard. You can manually refresh a custom dashboard, or you can set a refresh
     * schedule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Highlights dashboard</b> - You can create the Highlights dashboard to see a summary of key user activities and
     * API usage across all your event data stores. CloudTrail Lake manages the Highlights dashboard and refreshes the
     * dashboard every 6 hours. To create the Highlights dashboard, you must set and enable a refresh schedule.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must
     * be granted permissions to run the <code>StartQuery</code> operation on your behalf. To provide permissions, run
     * the <code>PutResourcePolicy</code> operation to attach a resource-based policy to each event data store. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard"
     * >Example: Allow CloudTrail to run queries to populate a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * To set a refresh schedule, CloudTrail must be granted permissions to run the <code>StartDashboardRefresh</code>
     * operation to refresh the dashboard on your behalf. To provide permissions, run the <code>PutResourcePolicy</code>
     * operation to attach a resource-based policy to the dashboard. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards"
     * > Resource-based policy example for a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * For more information about dashboards, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-dashboard.html">CloudTrail Lake
     * dashboards</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDashboardRequest#builder()}
     * </p>
     *
     * @param createDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.CreateDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidQueryStatementException The query that was submitted has validation errors, or uses incorrect
     *         syntax or unsupported keywords. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when the quota is exceeded. For information
     *         about CloudTrail quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ct.html#limits_cloudtrail">Service quotas</a> in the
     *         <i>Amazon Web Services General Reference</i>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDashboardResponse> createDashboard(
            Consumer<CreateDashboardRequest.Builder> createDashboardRequest) {
        return createDashboard(CreateDashboardRequest.builder().applyMutation(createDashboardRequest).build());
    }

    /**
     * <p>
     * Creates a new event data store.
     * </p>
     *
     * @param createEventDataStoreRequest
     * @return A Java Future containing the result of the CreateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreAlreadyExistsException An event data store with that name already exists.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventDataStoreResponse> createEventDataStore(
            CreateEventDataStoreRequest createEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new event data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventDataStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEventDataStoreRequest#builder()}
     * </p>
     *
     * @param createEventDataStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreAlreadyExistsException An event data store with that name already exists.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventDataStoreResponse> createEventDataStore(
            Consumer<CreateEventDataStoreRequest.Builder> createEventDataStoreRequest) {
        return createEventDataStore(CreateEventDataStoreRequest.builder().applyMutation(createEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     * </p>
     *
     * @param createTrailRequest
     *        Specifies the settings for each trail.
     * @return A Java Future containing the result of the CreateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MaximumNumberOfTrailsExceededException This exception is thrown when the maximum number of trails is
     *         reached.</li>
     *         <li>TrailAlreadyExistsException This exception is thrown when the specified trail already exists.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>TagsLimitExceededException The number of tags per trail, event data store, dashboard, or channel has
     *         exceeded the permitted amount. Currently, the limit is 50.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this Region.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrailResponse> createTrail(CreateTrailRequest createTrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrailRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTrailRequest#builder()}
     * </p>
     *
     * @param createTrailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.CreateTrailRequest.Builder} to create a request.
     *        Specifies the settings for each trail.
     * @return A Java Future containing the result of the CreateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MaximumNumberOfTrailsExceededException This exception is thrown when the maximum number of trails is
     *         reached.</li>
     *         <li>TrailAlreadyExistsException This exception is thrown when the specified trail already exists.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>TagsLimitExceededException The number of tags per trail, event data store, dashboard, or channel has
     *         exceeded the permitted amount. Currently, the limit is 50.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this Region.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrailResponse> createTrail(Consumer<CreateTrailRequest.Builder> createTrailRequest) {
        return createTrail(CreateTrailRequest.builder().applyMutation(createTrailRequest).build());
    }

    /**
     * <p>
     * Deletes a channel.
     * </p>
     *
     * @param deleteChannelRequest
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(DeleteChannelRequest deleteChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.DeleteChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest) {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified dashboard. You cannot delete a dashboard that has termination protection enabled.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified dashboard. You cannot delete a dashboard that has termination protection enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDashboardRequest#builder()}
     * </p>
     *
     * @param deleteDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.DeleteDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDashboardResponse> deleteDashboard(
            Consumer<DeleteDashboardRequest.Builder> deleteDashboardRequest) {
        return deleteDashboard(DeleteDashboardRequest.builder().applyMutation(deleteDashboardRequest).build());
    }

    /**
     * <p>
     * Disables the event data store specified by <code>EventDataStore</code>, which accepts an event data store ARN.
     * After you run <code>DeleteEventDataStore</code>, the event data store enters a <code>PENDING_DELETION</code>
     * state, and is automatically deleted after a wait period of seven days. <code>TerminationProtectionEnabled</code>
     * must be set to <code>False</code> on the event data store and the <code>FederationStatus</code> must be
     * <code>DISABLED</code>. You cannot delete an event data store if <code>TerminationProtectionEnabled</code> is
     * <code>True</code> or the <code>FederationStatus</code> is <code>ENABLED</code>.
     * </p>
     * <p>
     * After you run <code>DeleteEventDataStore</code> on an event data store, you cannot run <code>ListQueries</code>,
     * <code>DescribeQuery</code>, or <code>GetQueryResults</code> on queries that are using an event data store in a
     * <code>PENDING_DELETION</code> state. An event data store in the <code>PENDING_DELETION</code> state does not
     * incur costs.
     * </p>
     *
     * @param deleteEventDataStoreRequest
     * @return A Java Future containing the result of the DeleteEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreTerminationProtectedException The event data store cannot be deleted because
     *         termination protection is enabled for it.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ChannelExistsForEdsException This exception is thrown when the specified event data store cannot yet
     *         be deleted because it is in use by a channel.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>EventDataStoreFederationEnabledException You cannot delete the event data store because Lake query
     *         federation is enabled. To delete the event data store, run the <code>DisableFederation</code> operation
     *         to disable Lake query federation on the event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventDataStoreResponse> deleteEventDataStore(
            DeleteEventDataStoreRequest deleteEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the event data store specified by <code>EventDataStore</code>, which accepts an event data store ARN.
     * After you run <code>DeleteEventDataStore</code>, the event data store enters a <code>PENDING_DELETION</code>
     * state, and is automatically deleted after a wait period of seven days. <code>TerminationProtectionEnabled</code>
     * must be set to <code>False</code> on the event data store and the <code>FederationStatus</code> must be
     * <code>DISABLED</code>. You cannot delete an event data store if <code>TerminationProtectionEnabled</code> is
     * <code>True</code> or the <code>FederationStatus</code> is <code>ENABLED</code>.
     * </p>
     * <p>
     * After you run <code>DeleteEventDataStore</code> on an event data store, you cannot run <code>ListQueries</code>,
     * <code>DescribeQuery</code>, or <code>GetQueryResults</code> on queries that are using an event data store in a
     * <code>PENDING_DELETION</code> state. An event data store in the <code>PENDING_DELETION</code> state does not
     * incur costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventDataStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEventDataStoreRequest#builder()}
     * </p>
     *
     * @param deleteEventDataStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreTerminationProtectedException The event data store cannot be deleted because
     *         termination protection is enabled for it.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ChannelExistsForEdsException This exception is thrown when the specified event data store cannot yet
     *         be deleted because it is in use by a channel.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>EventDataStoreFederationEnabledException You cannot delete the event data store because Lake query
     *         federation is enabled. To delete the event data store, run the <code>DisableFederation</code> operation
     *         to disable Lake query federation on the event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventDataStoreResponse> deleteEventDataStore(
            Consumer<DeleteEventDataStoreRequest.Builder> deleteEventDataStoreRequest) {
        return deleteEventDataStore(DeleteEventDataStoreRequest.builder().applyMutation(deleteEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Deletes the resource-based policy attached to the CloudTrail event data store, dashboard, or channel.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceArnNotValidException This exception is thrown when the provided resource does not exist, or
     *         the ARN format of the resource is not valid. </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>ResourcePolicyNotFoundException This exception is thrown when the specified resource policy is not
     *         found.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource-based policy attached to the CloudTrail event data store, dashboard, or channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceArnNotValidException This exception is thrown when the provided resource does not exist, or
     *         the ARN format of the resource is not valid. </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>ResourcePolicyNotFoundException This exception is thrown when the specified resource policy is not
     *         found.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a trail. This operation must be called from the Region in which the trail was created.
     * <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails in other Regions) of a trail
     * that is enabled in all Regions.
     * </p>
     *
     * @param deleteTrailRequest
     *        The request that specifies the name of a trail to delete.
     * @return A Java Future containing the result of the DeleteTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrailResponse> deleteTrail(DeleteTrailRequest deleteTrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a trail. This operation must be called from the Region in which the trail was created.
     * <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails in other Regions) of a trail
     * that is enabled in all Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrailRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTrailRequest#builder()}
     * </p>
     *
     * @param deleteTrailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.DeleteTrailRequest.Builder} to create a request.
     *        The request that specifies the name of a trail to delete.
     * @return A Java Future containing the result of the DeleteTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrailResponse> deleteTrail(Consumer<DeleteTrailRequest.Builder> deleteTrailRequest) {
        return deleteTrail(DeleteTrailRequest.builder().applyMutation(deleteTrailRequest).build());
    }

    /**
     * <p>
     * Removes CloudTrail delegated administrator permissions from a member account in an organization.
     * </p>
     *
     * @param deregisterOrganizationDelegatedAdminRequest
     *        Removes CloudTrail delegated administrator permissions from a specified member account in an organization
     *        that is currently designated as a delegated administrator.
     * @return A Java Future containing the result of the DeregisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccountNotFoundException This exception is thrown when the specified account is not found or not part
     *         of an organization.</li>
     *         <li>AccountNotRegisteredException This exception is thrown when the specified account is not registered
     *         as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeregisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeregisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterOrganizationDelegatedAdminResponse> deregisterOrganizationDelegatedAdmin(
            DeregisterOrganizationDelegatedAdminRequest deregisterOrganizationDelegatedAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes CloudTrail delegated administrator permissions from a member account in an organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeregisterOrganizationDelegatedAdminRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterOrganizationDelegatedAdminRequest#builder()}
     * </p>
     *
     * @param deregisterOrganizationDelegatedAdminRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminRequest.Builder}
     *        to create a request. Removes CloudTrail delegated administrator permissions from a specified member
     *        account in an organization that is currently designated as a delegated administrator.
     * @return A Java Future containing the result of the DeregisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccountNotFoundException This exception is thrown when the specified account is not found or not part
     *         of an organization.</li>
     *         <li>AccountNotRegisteredException This exception is thrown when the specified account is not registered
     *         as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeregisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeregisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterOrganizationDelegatedAdminResponse> deregisterOrganizationDelegatedAdmin(
            Consumer<DeregisterOrganizationDelegatedAdminRequest.Builder> deregisterOrganizationDelegatedAdminRequest) {
        return deregisterOrganizationDelegatedAdmin(DeregisterOrganizationDelegatedAdminRequest.builder()
                .applyMutation(deregisterOrganizationDelegatedAdminRequest).build());
    }

    /**
     * <p>
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched,
     * and query status. If the query results were delivered to an S3 bucket, the response also provides the S3 URI and
     * the delivery status.
     * </p>
     * <p>
     * You must specify either <code>QueryId</code> or <code>QueryAlias</code>. Specifying the <code>QueryAlias</code>
     * parameter returns information about the last query run for the alias. You can provide <code>RefreshId</code>
     * along with <code>QueryAlias</code> to view the query results of a dashboard query for the specified
     * <code>RefreshId</code>.
     * </p>
     *
     * @param describeQueryRequest
     * @return A Java Future containing the result of the DescribeQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeQueryResponse> describeQuery(DescribeQueryRequest describeQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched,
     * and query status. If the query results were delivered to an S3 bucket, the response also provides the S3 URI and
     * the delivery status.
     * </p>
     * <p>
     * You must specify either <code>QueryId</code> or <code>QueryAlias</code>. Specifying the <code>QueryAlias</code>
     * parameter returns information about the last query run for the alias. You can provide <code>RefreshId</code>
     * along with <code>QueryAlias</code> to view the query results of a dashboard query for the specified
     * <code>RefreshId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQueryRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeQueryRequest#builder()}
     * </p>
     *
     * @param describeQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.DescribeQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeQueryResponse> describeQuery(Consumer<DescribeQueryRequest.Builder> describeQueryRequest) {
        return describeQuery(DescribeQueryRequest.builder().applyMutation(describeQueryRequest).build());
    }

    /**
     * <p>
     * Retrieves settings for one or more trails associated with the current Region for your account.
     * </p>
     *
     * @param describeTrailsRequest
     *        Returns information about the trail.
     * @return A Java Future containing the result of the DescribeTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrailsResponse> describeTrails(DescribeTrailsRequest describeTrailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves settings for one or more trails associated with the current Region for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrailsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTrailsRequest#builder()}
     * </p>
     *
     * @param describeTrailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsRequest.Builder} to create a
     *        request. Returns information about the trail.
     * @return A Java Future containing the result of the DescribeTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrailsResponse> describeTrails(Consumer<DescribeTrailsRequest.Builder> describeTrailsRequest) {
        return describeTrails(DescribeTrailsRequest.builder().applyMutation(describeTrailsRequest).build());
    }

    /**
     * <p>
     * Retrieves settings for one or more trails associated with the current Region for your account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrailsResponse> describeTrails() {
        return describeTrails(DescribeTrailsRequest.builder().build());
    }

    /**
     * <p>
     * Disables Lake query federation on the specified event data store. When you disable federation, CloudTrail
     * disables the integration with Glue, Lake Formation, and Amazon Athena. After disabling Lake query federation, you
     * can no longer query your event data in Amazon Athena.
     * </p>
     * <p>
     * No CloudTrail Lake data is deleted when you disable federation and you can continue to run queries in CloudTrail
     * Lake.
     * </p>
     *
     * @param disableFederationRequest
     * @return A Java Future containing the result of the DisableFederation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>ConcurrentModificationException You are trying to update a resource when another request is in
     *         progress. Allow sufficient wait time for the previous request to complete, then retry your request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DisableFederation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DisableFederation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableFederationResponse> disableFederation(DisableFederationRequest disableFederationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables Lake query federation on the specified event data store. When you disable federation, CloudTrail
     * disables the integration with Glue, Lake Formation, and Amazon Athena. After disabling Lake query federation, you
     * can no longer query your event data in Amazon Athena.
     * </p>
     * <p>
     * No CloudTrail Lake data is deleted when you disable federation and you can continue to run queries in CloudTrail
     * Lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableFederationRequest.Builder} avoiding the need
     * to create one manually via {@link DisableFederationRequest#builder()}
     * </p>
     *
     * @param disableFederationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.DisableFederationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisableFederation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>ConcurrentModificationException You are trying to update a resource when another request is in
     *         progress. Allow sufficient wait time for the previous request to complete, then retry your request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DisableFederation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DisableFederation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableFederationResponse> disableFederation(
            Consumer<DisableFederationRequest.Builder> disableFederationRequest) {
        return disableFederation(DisableFederationRequest.builder().applyMutation(disableFederationRequest).build());
    }

    /**
     * <p>
     * Enables Lake query federation on the specified event data store. Federating an event data store lets you view the
     * metadata associated with the event data store in the Glue <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro">Data Catalog</a>
     * and run SQL queries against your event data using Amazon Athena. The table metadata stored in the Glue Data
     * Catalog lets the Athena query engine know how to find, read, and process the data that you want to query.
     * </p>
     * <p>
     * When you enable Lake query federation, CloudTrail creates a managed database named <code>aws:cloudtrail</code>
     * (if the database doesn't already exist) and a managed federated table in the Glue Data Catalog. The event data
     * store ID is used for the table name. CloudTrail registers the role ARN and event data store in <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation-lake-formation.html">Lake
     * Formation</a>, the service responsible for allowing fine-grained access control of the federated resources in the
     * Glue Data Catalog.
     * </p>
     * <p>
     * For more information about Lake query federation, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Federate an event data
     * store</a>.
     * </p>
     *
     * @param enableFederationRequest
     * @return A Java Future containing the result of the EnableFederation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>ConcurrentModificationException You are trying to update a resource when another request is in
     *         progress. Allow sufficient wait time for the previous request to complete, then retry your request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>EventDataStoreFederationEnabledException You cannot delete the event data store because Lake query
     *         federation is enabled. To delete the event data store, run the <code>DisableFederation</code> operation
     *         to disable Lake query federation on the event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.EnableFederation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/EnableFederation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableFederationResponse> enableFederation(EnableFederationRequest enableFederationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Lake query federation on the specified event data store. Federating an event data store lets you view the
     * metadata associated with the event data store in the Glue <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro">Data Catalog</a>
     * and run SQL queries against your event data using Amazon Athena. The table metadata stored in the Glue Data
     * Catalog lets the Athena query engine know how to find, read, and process the data that you want to query.
     * </p>
     * <p>
     * When you enable Lake query federation, CloudTrail creates a managed database named <code>aws:cloudtrail</code>
     * (if the database doesn't already exist) and a managed federated table in the Glue Data Catalog. The event data
     * store ID is used for the table name. CloudTrail registers the role ARN and event data store in <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation-lake-formation.html">Lake
     * Formation</a>, the service responsible for allowing fine-grained access control of the federated resources in the
     * Glue Data Catalog.
     * </p>
     * <p>
     * For more information about Lake query federation, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Federate an event data
     * store</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableFederationRequest.Builder} avoiding the need
     * to create one manually via {@link EnableFederationRequest#builder()}
     * </p>
     *
     * @param enableFederationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.EnableFederationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the EnableFederation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>ConcurrentModificationException You are trying to update a resource when another request is in
     *         progress. Allow sufficient wait time for the previous request to complete, then retry your request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>EventDataStoreFederationEnabledException You cannot delete the event data store because Lake query
     *         federation is enabled. To delete the event data store, run the <code>DisableFederation</code> operation
     *         to disable Lake query federation on the event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.EnableFederation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/EnableFederation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableFederationResponse> enableFederation(
            Consumer<EnableFederationRequest.Builder> enableFederationRequest) {
        return enableFederation(EnableFederationRequest.builder().applyMutation(enableFederationRequest).build());
    }

    /**
     * <p>
     * Generates a query from a natural language prompt. This operation uses generative artificial intelligence
     * (generative AI) to produce a ready-to-use SQL query from the prompt.
     * </p>
     * <p>
     * The prompt can be a question or a statement about the event data in your event data store. For example, you can
     * enter prompts like "What are my top errors in the past month?" and “Give me a list of users that used SNS.”
     * </p>
     * <p>
     * The prompt must be in English. For information about limitations, permissions, and supported Regions, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html">Create CloudTrail
     * Lake queries from natural language prompts</a> in the <i>CloudTrail </i> user guide.
     * </p>
     * <note>
     * <p>
     * Do not include any personally identifying, confidential, or sensitive information in your prompts.
     * </p>
     * <p>
     * This feature uses generative AI large language models (LLMs); we recommend double-checking the LLM response.
     * </p>
     * </note>
     *
     * @param generateQueryRequest
     * @return A Java Future containing the result of the GenerateQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>GenerateResponseException This exception is thrown when a valid query could not be generated for the
     *         provided prompt.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GenerateQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GenerateQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GenerateQueryResponse> generateQuery(GenerateQueryRequest generateQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a query from a natural language prompt. This operation uses generative artificial intelligence
     * (generative AI) to produce a ready-to-use SQL query from the prompt.
     * </p>
     * <p>
     * The prompt can be a question or a statement about the event data in your event data store. For example, you can
     * enter prompts like "What are my top errors in the past month?" and “Give me a list of users that used SNS.”
     * </p>
     * <p>
     * The prompt must be in English. For information about limitations, permissions, and supported Regions, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html">Create CloudTrail
     * Lake queries from natural language prompts</a> in the <i>CloudTrail </i> user guide.
     * </p>
     * <note>
     * <p>
     * Do not include any personally identifying, confidential, or sensitive information in your prompts.
     * </p>
     * <p>
     * This feature uses generative AI large language models (LLMs); we recommend double-checking the LLM response.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateQueryRequest.Builder} avoiding the need to
     * create one manually via {@link GenerateQueryRequest#builder()}
     * </p>
     *
     * @param generateQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GenerateQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GenerateQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>GenerateResponseException This exception is thrown when a valid query could not be generated for the
     *         provided prompt.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GenerateQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GenerateQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GenerateQueryResponse> generateQuery(Consumer<GenerateQueryRequest.Builder> generateQueryRequest) {
        return generateQuery(GenerateQueryRequest.builder().applyMutation(generateQueryRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific channel.
     * </p>
     *
     * @param getChannelRequest
     * @return A Java Future containing the result of the GetChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelResponse> getChannel(GetChannelRequest getChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetChannelRequest#builder()}
     * </p>
     *
     * @param getChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelResponse> getChannel(Consumer<GetChannelRequest.Builder> getChannelRequest) {
        return getChannel(GetChannelRequest.builder().applyMutation(getChannelRequest).build());
    }

    /**
     * <p>
     * Returns the specified dashboard.
     * </p>
     *
     * @param getDashboardRequest
     * @return A Java Future containing the result of the GetDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDashboardResponse> getDashboard(GetDashboardRequest getDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the specified dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDashboardRequest.Builder} avoiding the need to
     * create one manually via {@link GetDashboardRequest#builder()}
     * </p>
     *
     * @param getDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetDashboardRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDashboardResponse> getDashboard(Consumer<GetDashboardRequest.Builder> getDashboardRequest) {
        return getDashboard(GetDashboardRequest.builder().applyMutation(getDashboardRequest).build());
    }

    /**
     * <p>
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     * </p>
     *
     * @param getEventDataStoreRequest
     * @return A Java Future containing the result of the GetEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventDataStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventDataStoreResponse> getEventDataStore(GetEventDataStoreRequest getEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventDataStoreRequest.Builder} avoiding the need
     * to create one manually via {@link GetEventDataStoreRequest#builder()}
     * </p>
     *
     * @param getEventDataStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventDataStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventDataStoreResponse> getEventDataStore(
            Consumer<GetEventDataStoreRequest.Builder> getEventDataStoreRequest) {
        return getEventDataStore(GetEventDataStoreRequest.builder().applyMutation(getEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Describes the settings for the event selectors that you configured for your trail. The information returned for
     * your event selectors includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your event selector includes read-only events, write-only events, or all events. This applies to management
     * events, data events, and network activity events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes management events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes network activity events, the event sources for which you are logging network
     * activity events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes data events, the resources on which you are logging data events.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about logging management, data, and network activity events, see the following topics in the
     * <i>CloudTrail User Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">
     * Logging data events</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html">
     * Logging network activity events</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getEventSelectorsRequest
     * @return A Java Future containing the result of the GetEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventSelectorsResponse> getEventSelectors(GetEventSelectorsRequest getEventSelectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings for the event selectors that you configured for your trail. The information returned for
     * your event selectors includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your event selector includes read-only events, write-only events, or all events. This applies to management
     * events, data events, and network activity events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes management events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes network activity events, the event sources for which you are logging network
     * activity events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes data events, the resources on which you are logging data events.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about logging management, data, and network activity events, see the following topics in the
     * <i>CloudTrail User Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">
     * Logging data events</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html">
     * Logging network activity events</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventSelectorsRequest.Builder} avoiding the need
     * to create one manually via {@link GetEventSelectorsRequest#builder()}
     * </p>
     *
     * @param getEventSelectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventSelectorsResponse> getEventSelectors(
            Consumer<GetEventSelectorsRequest.Builder> getEventSelectorsRequest) {
        return getEventSelectors(GetEventSelectorsRequest.builder().applyMutation(getEventSelectorsRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific import.
     * </p>
     *
     * @param getImportRequest
     * @return A Java Future containing the result of the GetImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportResponse> getImport(GetImportRequest getImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportRequest#builder()}
     * </p>
     *
     * @param getImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportResponse> getImport(Consumer<GetImportRequest.Builder> getImportRequest) {
        return getImport(GetImportRequest.builder().applyMutation(getImportRequest).build());
    }

    /**
     * <p>
     * Describes the settings for the Insights event selectors that you configured for your trail or event data store.
     * <code>GetInsightSelectors</code> shows if CloudTrail Insights event logging is enabled on the trail or event data
     * store, and if it is, which Insights types are enabled. If you run <code>GetInsightSelectors</code> on a trail or
     * event data store that does not have Insights events enabled, the operation throws the exception
     * <code>InsightNotEnabledException</code>
     * </p>
     * <p>
     * Specify either the <code>EventDataStore</code> parameter to get Insights event selectors for an event data store,
     * or the <code>TrailName</code> parameter to the get Insights event selectors for a trail. You cannot specify these
     * parameters together.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Working with CloudTrail Insights</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param getInsightSelectorsRequest
     * @return A Java Future containing the result of the GetInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InsightNotEnabledException If you run <code>GetInsightSelectors</code> on a trail or event data store
     *         that does not have Insights events enabled, the operation throws the exception
     *         <code>InsightNotEnabledException</code>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInsightSelectorsResponse> getInsightSelectors(
            GetInsightSelectorsRequest getInsightSelectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings for the Insights event selectors that you configured for your trail or event data store.
     * <code>GetInsightSelectors</code> shows if CloudTrail Insights event logging is enabled on the trail or event data
     * store, and if it is, which Insights types are enabled. If you run <code>GetInsightSelectors</code> on a trail or
     * event data store that does not have Insights events enabled, the operation throws the exception
     * <code>InsightNotEnabledException</code>
     * </p>
     * <p>
     * Specify either the <code>EventDataStore</code> parameter to get Insights event selectors for an event data store,
     * or the <code>TrailName</code> parameter to the get Insights event selectors for a trail. You cannot specify these
     * parameters together.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Working with CloudTrail Insights</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightSelectorsRequest.Builder} avoiding the
     * need to create one manually via {@link GetInsightSelectorsRequest#builder()}
     * </p>
     *
     * @param getInsightSelectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InsightNotEnabledException If you run <code>GetInsightSelectors</code> on a trail or event data store
     *         that does not have Insights events enabled, the operation throws the exception
     *         <code>InsightNotEnabledException</code>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInsightSelectorsResponse> getInsightSelectors(
            Consumer<GetInsightSelectorsRequest.Builder> getInsightSelectorsRequest) {
        return getInsightSelectors(GetInsightSelectorsRequest.builder().applyMutation(getInsightSelectorsRequest).build());
    }

    /**
     * <p>
     * Gets event data results of a query. You must specify the <code>QueryID</code> value returned by the
     * <code>StartQuery</code> operation.
     * </p>
     *
     * @param getQueryResultsRequest
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets event data results of a query. You must specify the <code>QueryID</code> value returned by the
     * <code>StartQuery</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetQueryResultsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsResponse> getQueryResults(
            Consumer<GetQueryResultsRequest.Builder> getQueryResultsRequest) {
        return getQueryResults(GetQueryResultsRequest.builder().applyMutation(getQueryResultsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResults(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResults(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest)} operation.</b>
     * </p>
     *
     * @param getQueryResultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQueryResultsPublisher getQueryResultsPaginator(GetQueryResultsRequest getQueryResultsRequest) {
        return new GetQueryResultsPublisher(this, getQueryResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResults(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResults(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetQueryResultsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQueryResultsPublisher getQueryResultsPaginator(Consumer<GetQueryResultsRequest.Builder> getQueryResultsRequest) {
        return getQueryResultsPaginator(GetQueryResultsRequest.builder().applyMutation(getQueryResultsRequest).build());
    }

    /**
     * <p>
     * Retrieves the JSON text of the resource-based policy document attached to the CloudTrail event data store,
     * dashboard, or channel.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceArnNotValidException This exception is thrown when the provided resource does not exist, or
     *         the ARN format of the resource is not valid. </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>ResourcePolicyNotFoundException This exception is thrown when the specified resource policy is not
     *         found.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the JSON text of the resource-based policy document attached to the CloudTrail event data store,
     * dashboard, or channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceArnNotValidException This exception is thrown when the provided resource does not exist, or
     *         the ARN format of the resource is not valid. </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>ResourcePolicyNotFoundException This exception is thrown when the specified resource policy is not
     *         found.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Returns settings information for a specified trail.
     * </p>
     *
     * @param getTrailRequest
     * @return A Java Future containing the result of the GetTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrailResponse> getTrail(GetTrailRequest getTrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns settings information for a specified trail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrailRequest.Builder} avoiding the need to
     * create one manually via {@link GetTrailRequest#builder()}
     * </p>
     *
     * @param getTrailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrailResponse> getTrail(Consumer<GetTrailRequest.Builder> getTrailRequest) {
        return getTrail(GetTrailRequest.builder().applyMutation(getTrailRequest).build());
    }

    /**
     * <p>
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery
     * errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns
     * trail status from a single Region. To return trail status from all Regions, you must call the operation on each
     * Region.
     * </p>
     *
     * @param getTrailStatusRequest
     *        The name of a trail about which you want the current status.
     * @return A Java Future containing the result of the GetTrailStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrailStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrailStatusResponse> getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery
     * errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns
     * trail status from a single Region. To return trail status from all Regions, you must call the operation on each
     * Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrailStatusRequest.Builder} avoiding the need to
     * create one manually via {@link GetTrailStatusRequest#builder()}
     * </p>
     *
     * @param getTrailStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest.Builder} to create a
     *        request. The name of a trail about which you want the current status.
     * @return A Java Future containing the result of the GetTrailStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrailStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrailStatusResponse> getTrailStatus(Consumer<GetTrailStatusRequest.Builder> getTrailStatusRequest) {
        return getTrailStatus(GetTrailStatusRequest.builder().applyMutation(getTrailStatusRequest).build());
    }

    /**
     * <p>
     * Lists the channels in the current account, and their source names.
     * </p>
     *
     * @param listChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the channels in the current account, and their source names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(ListChannelsRequest listChannelsRequest) {
        return new ListChannelsPublisher(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Returns information about all dashboards in the account, in the current Region.
     * </p>
     *
     * @param listDashboardsRequest
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest listDashboardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all dashboards in the account, in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListDashboardsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDashboardsResponse> listDashboards(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) {
        return listDashboards(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * Returns information about all event data stores in the account, in the current Region.
     * </p>
     *
     * @param listEventDataStoresRequest
     * @return A Java Future containing the result of the ListEventDataStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventDataStoresResponse> listEventDataStores(
            ListEventDataStoresRequest listEventDataStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all event data stores in the account, in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventDataStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventDataStoresRequest#builder()}
     * </p>
     *
     * @param listEventDataStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventDataStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventDataStoresResponse> listEventDataStores(
            Consumer<ListEventDataStoresRequest.Builder> listEventDataStoresRequest) {
        return listEventDataStores(ListEventDataStoresRequest.builder().applyMutation(listEventDataStoresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventDataStores(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher publisher = client.listEventDataStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher publisher = client.listEventDataStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventDataStores(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventDataStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventDataStoresPublisher listEventDataStoresPaginator(ListEventDataStoresRequest listEventDataStoresRequest) {
        return new ListEventDataStoresPublisher(this, listEventDataStoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventDataStores(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher publisher = client.listEventDataStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher publisher = client.listEventDataStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventDataStores(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventDataStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventDataStoresRequest#builder()}
     * </p>
     *
     * @param listEventDataStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventDataStoresPublisher listEventDataStoresPaginator(
            Consumer<ListEventDataStoresRequest.Builder> listEventDataStoresRequest) {
        return listEventDataStoresPaginator(ListEventDataStoresRequest.builder().applyMutation(listEventDataStoresRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of failures for the specified import.
     * </p>
     *
     * @param listImportFailuresRequest
     * @return A Java Future containing the result of the ListImportFailures operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportFailuresResponse> listImportFailures(ListImportFailuresRequest listImportFailuresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of failures for the specified import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportFailuresRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportFailuresRequest#builder()}
     * </p>
     *
     * @param listImportFailuresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListImportFailures operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportFailuresResponse> listImportFailures(
            Consumer<ListImportFailuresRequest.Builder> listImportFailuresRequest) {
        return listImportFailures(ListImportFailuresRequest.builder().applyMutation(listImportFailuresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportFailures(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher publisher = client.listImportFailuresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher publisher = client.listImportFailuresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportFailures(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImportFailuresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportFailuresPublisher listImportFailuresPaginator(ListImportFailuresRequest listImportFailuresRequest) {
        return new ListImportFailuresPublisher(this, listImportFailuresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportFailures(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher publisher = client.listImportFailuresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher publisher = client.listImportFailuresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportFailures(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportFailuresRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportFailuresRequest#builder()}
     * </p>
     *
     * @param listImportFailuresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportFailuresPublisher listImportFailuresPaginator(
            Consumer<ListImportFailuresRequest.Builder> listImportFailuresRequest) {
        return listImportFailuresPaginator(ListImportFailuresRequest.builder().applyMutation(listImportFailuresRequest).build());
    }

    /**
     * <p>
     * Returns information on all imports, or a select set of imports by <code>ImportStatus</code> or
     * <code>Destination</code>.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information on all imports, or a select set of imports by <code>ImportStatus</code> or
     * <code>Destination</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(ListImportsRequest listImportsRequest) {
        return new ListImportsPublisher(this, listImportsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Returns Insights metrics data for trails that have enabled Insights. The request must include the
     * <code>EventSource</code>, <code>EventName</code>, and <code>InsightType</code> parameters.
     * </p>
     * <p>
     * If the <code>InsightType</code> is set to <code>ApiErrorRateInsight</code>, the request must also include the
     * <code>ErrorCode</code> parameter.
     * </p>
     * <p>
     * The following are the available time periods for <code>ListInsightsMetricData</code>. Each cutoff is inclusive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Data points with a period of 60 seconds (1-minute) are available for 15 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * Data points with a period of 300 seconds (5-minute) are available for 63 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * Data points with a period of 3600 seconds (1 hour) are available for 90 days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Access to the <code>ListInsightsMetricData</code> API operation is linked to the
     * <code>cloudtrail:LookupEvents</code> action. To use this operation, you must have permissions to perform the
     * <code>cloudtrail:LookupEvents</code> action.
     * </p>
     *
     * @param listInsightsMetricDataRequest
     * @return A Java Future containing the result of the ListInsightsMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListInsightsMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListInsightsMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInsightsMetricDataResponse> listInsightsMetricData(
            ListInsightsMetricDataRequest listInsightsMetricDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Insights metrics data for trails that have enabled Insights. The request must include the
     * <code>EventSource</code>, <code>EventName</code>, and <code>InsightType</code> parameters.
     * </p>
     * <p>
     * If the <code>InsightType</code> is set to <code>ApiErrorRateInsight</code>, the request must also include the
     * <code>ErrorCode</code> parameter.
     * </p>
     * <p>
     * The following are the available time periods for <code>ListInsightsMetricData</code>. Each cutoff is inclusive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Data points with a period of 60 seconds (1-minute) are available for 15 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * Data points with a period of 300 seconds (5-minute) are available for 63 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * Data points with a period of 3600 seconds (1 hour) are available for 90 days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Access to the <code>ListInsightsMetricData</code> API operation is linked to the
     * <code>cloudtrail:LookupEvents</code> action. To use this operation, you must have permissions to perform the
     * <code>cloudtrail:LookupEvents</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInsightsMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link ListInsightsMetricDataRequest#builder()}
     * </p>
     *
     * @param listInsightsMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInsightsMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListInsightsMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListInsightsMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInsightsMetricDataResponse> listInsightsMetricData(
            Consumer<ListInsightsMetricDataRequest.Builder> listInsightsMetricDataRequest) {
        return listInsightsMetricData(ListInsightsMetricDataRequest.builder().applyMutation(listInsightsMetricDataRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInsightsMetricData(software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListInsightsMetricDataPublisher publisher = client.listInsightsMetricDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListInsightsMetricDataPublisher publisher = client.listInsightsMetricDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInsightsMetricData(software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInsightsMetricDataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListInsightsMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListInsightsMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInsightsMetricDataPublisher listInsightsMetricDataPaginator(
            ListInsightsMetricDataRequest listInsightsMetricDataRequest) {
        return new ListInsightsMetricDataPublisher(this, listInsightsMetricDataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInsightsMetricData(software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListInsightsMetricDataPublisher publisher = client.listInsightsMetricDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListInsightsMetricDataPublisher publisher = client.listInsightsMetricDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInsightsMetricData(software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInsightsMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link ListInsightsMetricDataRequest#builder()}
     * </p>
     *
     * @param listInsightsMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListInsightsMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListInsightsMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInsightsMetricDataPublisher listInsightsMetricDataPaginator(
            Consumer<ListInsightsMetricDataRequest.Builder> listInsightsMetricDataRequest) {
        return listInsightsMetricDataPaginator(ListInsightsMetricDataRequest.builder()
                .applyMutation(listInsightsMetricDataRequest).build());
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per Region. Each digest file is signed with a private key
     * unique to its Region. When you validate a digest file from a specific Region, you must look in the same Region
     * for its corresponding public key.
     * </p>
     * </note>
     *
     * @param listPublicKeysRequest
     *        Requests the public keys for a specified time range.
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per Region. Each digest file is signed with a private key
     * unique to its Region. When you validate a digest file from a specific Region, you must look in the same Region
     * for its corresponding public key.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublicKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListPublicKeysRequest#builder()}
     * </p>
     *
     * @param listPublicKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest.Builder} to create a
     *        request. Requests the public keys for a specified time range.
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys(Consumer<ListPublicKeysRequest.Builder> listPublicKeysRequest) {
        return listPublicKeys(ListPublicKeysRequest.builder().applyMutation(listPublicKeysRequest).build());
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per Region. Each digest file is signed with a private key
     * unique to its Region. When you validate a digest file from a specific Region, you must look in the same Region
     * for its corresponding public key.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys() {
        return listPublicKeys(ListPublicKeysRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysPublisher listPublicKeysPaginator() {
        return listPublicKeysPaginator(ListPublicKeysRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation.</b>
     * </p>
     *
     * @param listPublicKeysRequest
     *        Requests the public keys for a specified time range.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysPublisher listPublicKeysPaginator(ListPublicKeysRequest listPublicKeysRequest) {
        return new ListPublicKeysPublisher(this, listPublicKeysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublicKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListPublicKeysRequest#builder()}
     * </p>
     *
     * @param listPublicKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest.Builder} to create a
     *        request. Requests the public keys for a specified time range.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysPublisher listPublicKeysPaginator(Consumer<ListPublicKeysRequest.Builder> listPublicKeysRequest) {
        return listPublicKeysPaginator(ListPublicKeysRequest.builder().applyMutation(listPublicKeysRequest).build());
    }

    /**
     * <p>
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for
     * <code>EventDataStore</code>. Optionally, to shorten the list of results, you can specify a time range, formatted
     * as timestamps, by adding <code>StartTime</code> and <code>EndTime</code> parameters, and a
     * <code>QueryStatus</code> value. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>,
     * <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>CANCELLED</code>.
     * </p>
     *
     * @param listQueriesRequest
     * @return A Java Future containing the result of the ListQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidDateRangeException A date range for the query was specified that is not valid. Be sure that
     *         the start time is chronologically before the end time. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatusException The query status is not valid for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueriesResponse> listQueries(ListQueriesRequest listQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for
     * <code>EventDataStore</code>. Optionally, to shorten the list of results, you can specify a time range, formatted
     * as timestamps, by adding <code>StartTime</code> and <code>EndTime</code> parameters, and a
     * <code>QueryStatus</code> value. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>,
     * <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>CANCELLED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueriesRequest#builder()}
     * </p>
     *
     * @param listQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidDateRangeException A date range for the query was specified that is not valid. Be sure that
     *         the start time is chronologically before the end time. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatusException The query status is not valid for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueriesResponse> listQueries(Consumer<ListQueriesRequest.Builder> listQueriesRequest) {
        return listQueries(ListQueriesRequest.builder().applyMutation(listQueriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listQueries(software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher publisher = client.listQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher publisher = client.listQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueries(software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest)} operation.</b>
     * </p>
     *
     * @param listQueriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidDateRangeException A date range for the query was specified that is not valid. Be sure that
     *         the start time is chronologically before the end time. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatusException The query status is not valid for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueriesPublisher listQueriesPaginator(ListQueriesRequest listQueriesRequest) {
        return new ListQueriesPublisher(this, listQueriesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listQueries(software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher publisher = client.listQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher publisher = client.listQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueries(software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueriesRequest#builder()}
     * </p>
     *
     * @param listQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidDateRangeException A date range for the query was specified that is not valid. Be sure that
     *         the start time is chronologically before the end time. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatusException The query status is not valid for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueriesPublisher listQueriesPaginator(Consumer<ListQueriesRequest.Builder> listQueriesRequest) {
        return listQueriesPaginator(ListQueriesRequest.builder().applyMutation(listQueriesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified trails, event data stores, dashboards, or channels in the current Region.
     * </p>
     *
     * @param listTagsRequest
     *        Specifies a list of tags to return.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified trails, event data stores, dashboards, or channels in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest.Builder} to create a request.
     *        Specifies a list of tags to return.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     *        Specifies a list of tags to return.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsPublisher listTagsPaginator(ListTagsRequest listTagsRequest) {
        return new ListTagsPublisher(this, listTagsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest.Builder} to create a request.
     *        Specifies a list of tags to return.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsPublisher listTagsPaginator(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTagsPaginator(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists trails that are in the current account.
     * </p>
     *
     * @param listTrailsRequest
     * @return A Java Future containing the result of the ListTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTrailsResponse> listTrails(ListTrailsRequest listTrailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists trails that are in the current account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrailsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTrailsRequest#builder()}
     * </p>
     *
     * @param listTrailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTrailsResponse> listTrails(Consumer<ListTrailsRequest.Builder> listTrailsRequest) {
        return listTrails(ListTrailsRequest.builder().applyMutation(listTrailsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTrails(software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher publisher = client.listTrailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher publisher = client.listTrailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrails(software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest)} operation.</b>
     * </p>
     *
     * @param listTrailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrailsPublisher listTrailsPaginator(ListTrailsRequest listTrailsRequest) {
        return new ListTrailsPublisher(this, listTrailsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTrails(software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher publisher = client.listTrailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher publisher = client.listTrailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrails(software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrailsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTrailsRequest#builder()}
     * </p>
     *
     * @param listTrailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrailsPublisher listTrailsPaginator(Consumer<ListTrailsRequest.Builder> listTrailsRequest) {
        return listTrailsPaginator(ListTrailsRequest.builder().applyMutation(listTrailsRequest).build());
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a Region
     * within the last 90 days.
     * </p>
     * <note>
     * <p>
     * <code>LookupEvents</code> returns recent Insights events for trails that enable Insights. To view Insights events
     * for an event data store, you can run queries on your Insights event data store, and you can also view the Lake
     * dashboard for Insights.
     * </p>
     * </note>
     * <p>
     * Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per Region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important>
     *
     * @param lookupEventsRequest
     *        Contains a request for LookupEvents.
     * @return A Java Future containing the result of the LookupEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LookupEventsResponse> lookupEvents(LookupEventsRequest lookupEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a Region
     * within the last 90 days.
     * </p>
     * <note>
     * <p>
     * <code>LookupEvents</code> returns recent Insights events for trails that enable Insights. To view Insights events
     * for an event data store, you can run queries on your Insights event data store, and you can also view the Lake
     * dashboard for Insights.
     * </p>
     * </note>
     * <p>
     * Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per Region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link LookupEventsRequest.Builder} avoiding the need to
     * create one manually via {@link LookupEventsRequest#builder()}
     * </p>
     *
     * @param lookupEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest.Builder} to create a request.
     *        Contains a request for LookupEvents.
     * @return A Java Future containing the result of the LookupEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LookupEventsResponse> lookupEvents(Consumer<LookupEventsRequest.Builder> lookupEventsRequest) {
        return lookupEvents(LookupEventsRequest.builder().applyMutation(lookupEventsRequest).build());
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a Region
     * within the last 90 days.
     * </p>
     * <note>
     * <p>
     * <code>LookupEvents</code> returns recent Insights events for trails that enable Insights. To view Insights events
     * for an event data store, you can run queries on your Insights event data store, and you can also view the Lake
     * dashboard for Insights.
     * </p>
     * </note>
     * <p>
     * Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per Region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important>
     *
     * @return A Java Future containing the result of the LookupEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LookupEventsResponse> lookupEvents() {
        return lookupEvents(LookupEventsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default LookupEventsPublisher lookupEventsPaginator() {
        return lookupEventsPaginator(LookupEventsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)} operation.</b>
     * </p>
     *
     * @param lookupEventsRequest
     *        Contains a request for LookupEvents.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default LookupEventsPublisher lookupEventsPaginator(LookupEventsRequest lookupEventsRequest) {
        return new LookupEventsPublisher(this, lookupEventsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link LookupEventsRequest.Builder} avoiding the need to
     * create one manually via {@link LookupEventsRequest#builder()}
     * </p>
     *
     * @param lookupEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest.Builder} to create a request.
     *        Contains a request for LookupEvents.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default LookupEventsPublisher lookupEventsPaginator(Consumer<LookupEventsRequest.Builder> lookupEventsRequest) {
        return lookupEventsPaginator(LookupEventsRequest.builder().applyMutation(lookupEventsRequest).build());
    }

    /**
     * <p>
     * Configures event selectors (also referred to as <i>basic event selectors</i>) or advanced event selectors for
     * your trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both.
     * If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are
     * overwritten.
     * </p>
     * <p>
     * You can use <code>AdvancedEventSelectors</code> to log management events, data events for all resource types, and
     * network activity events.
     * </p>
     * <p>
     * You can use <code>EventSelectors</code> to log management events and data events for the following resource
     * types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::Lambda::Function</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3::Object</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use <code>EventSelectors</code> to log network activity events.
     * </p>
     * <p>
     * If you want your trail to log Insights events, be sure the event selector or advanced event selector enables
     * logging of the Insights event types you want configured for your trail. For more information about logging
     * Insights events, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Working with CloudTrail Insights</a> in the <i>CloudTrail User Guide</i>. By default, trails created without
     * specific event selectors are configured to log all read and write management events, and no data events or
     * network activity events.
     * </p>
     * <p>
     * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all
     * trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the
     * event doesn't match any event selector, the trail doesn't log the event.
     * </p>
     * <p>
     * Example
     * </p>
     * <ol>
     * <li>
     * <p>
     * You create an event selector for a trail and specify that you want to log write-only events.
     * </p>
     * </li>
     * <li>
     * <p>
     * The EC2 <code>GetConsoleOutput</code> and <code>RunInstances</code> API operations occur in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * CloudTrail evaluates whether the events match your event selectors.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>RunInstances</code> is a write-only event and it matches your event selector. The trail logs the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>GetConsoleOutput</code> is a read-only event that doesn't match your event selector. The trail doesn't
     * log the event.
     * </p>
     * </li>
     * </ol>
     * <p>
     * The <code>PutEventSelectors</code> operation must be called from the Region in which the trail was created;
     * otherwise, an <code>InvalidHomeRegionException</code> exception is thrown.
     * </p>
     * <p>
     * You can configure up to five event selectors for each trail.
     * </p>
     * <p>
     * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500
     * values for all conditions and selectors on a trail. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events</a>, <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
     * >Logging data events</a>, <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html"
     * >Logging network activity events</a>, and <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Quotas in
     * CloudTrail</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param putEventSelectorsRequest
     * @return A Java Future containing the result of the PutEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventSelectorsResponse> putEventSelectors(PutEventSelectorsRequest putEventSelectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures event selectors (also referred to as <i>basic event selectors</i>) or advanced event selectors for
     * your trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both.
     * If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are
     * overwritten.
     * </p>
     * <p>
     * You can use <code>AdvancedEventSelectors</code> to log management events, data events for all resource types, and
     * network activity events.
     * </p>
     * <p>
     * You can use <code>EventSelectors</code> to log management events and data events for the following resource
     * types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::Lambda::Function</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3::Object</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use <code>EventSelectors</code> to log network activity events.
     * </p>
     * <p>
     * If you want your trail to log Insights events, be sure the event selector or advanced event selector enables
     * logging of the Insights event types you want configured for your trail. For more information about logging
     * Insights events, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Working with CloudTrail Insights</a> in the <i>CloudTrail User Guide</i>. By default, trails created without
     * specific event selectors are configured to log all read and write management events, and no data events or
     * network activity events.
     * </p>
     * <p>
     * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all
     * trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the
     * event doesn't match any event selector, the trail doesn't log the event.
     * </p>
     * <p>
     * Example
     * </p>
     * <ol>
     * <li>
     * <p>
     * You create an event selector for a trail and specify that you want to log write-only events.
     * </p>
     * </li>
     * <li>
     * <p>
     * The EC2 <code>GetConsoleOutput</code> and <code>RunInstances</code> API operations occur in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * CloudTrail evaluates whether the events match your event selectors.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>RunInstances</code> is a write-only event and it matches your event selector. The trail logs the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>GetConsoleOutput</code> is a read-only event that doesn't match your event selector. The trail doesn't
     * log the event.
     * </p>
     * </li>
     * </ol>
     * <p>
     * The <code>PutEventSelectors</code> operation must be called from the Region in which the trail was created;
     * otherwise, an <code>InvalidHomeRegionException</code> exception is thrown.
     * </p>
     * <p>
     * You can configure up to five event selectors for each trail.
     * </p>
     * <p>
     * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500
     * values for all conditions and selectors on a trail. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events</a>, <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
     * >Logging data events</a>, <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html"
     * >Logging network activity events</a>, and <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Quotas in
     * CloudTrail</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventSelectorsRequest.Builder} avoiding the need
     * to create one manually via {@link PutEventSelectorsRequest#builder()}
     * </p>
     *
     * @param putEventSelectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventSelectorsResponse> putEventSelectors(
            Consumer<PutEventSelectorsRequest.Builder> putEventSelectorsRequest) {
        return putEventSelectors(PutEventSelectorsRequest.builder().applyMutation(putEventSelectorsRequest).build());
    }

    /**
     * <p>
     * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an
     * existing trail or event data store. You also use <code>PutInsightSelectors</code> to turn off Insights event
     * logging, by passing an empty list of Insights types. The valid Insights event types are
     * <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code>.
     * </p>
     * <p>
     * To enable Insights on an event data store, you must specify the ARNs (or ID suffix of the ARNs) for the source
     * event data store (<code>EventDataStore</code>) and the destination event data store (
     * <code>InsightsDestination</code>). The source event data store logs management events and enables Insights. The
     * destination event data store logs Insights events based upon the management event activity of the source event
     * data store. The source and destination event data stores must belong to the same Amazon Web Services account.
     * </p>
     * <p>
     * To log Insights events for a trail, you must specify the name (<code>TrailName</code>) of the CloudTrail trail
     * for which you want to change or add Insights selectors.
     * </p>
     * <p>
     * To log CloudTrail Insights events on API call volume, the trail or event data store must log <code>write</code>
     * management events. To log CloudTrail Insights events on API error rate, the trail or event data store must log
     * <code>read</code> or <code>write</code> management events. You can call <code>GetEventSelectors</code> on a trail
     * to check whether the trail logs management events. You can call <code>GetEventDataStore</code> on an event data
     * store to check whether the event data store logs management events.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Working with CloudTrail Insights</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param putInsightSelectorsRequest
     * @return A Java Future containing the result of the PutInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>InvalidInsightSelectorsException For <code>PutInsightSelectors</code>, this exception is thrown when
     *         the formatting or syntax of the <code>InsightSelectors</code> JSON statement is not valid, or the
     *         specified <code>InsightType</code> in the <code>InsightSelectors</code> statement is not valid. Valid
     *         values for <code>InsightType</code> are <code>ApiCallRateInsight</code> and
     *         <code>ApiErrorRateInsight</code>. To enable Insights on an event data store, the destination event data
     *         store specified by the <code>InsightsDestination</code> parameter must log Insights events and the source
     *         event data store specified by the <code>EventDataStore</code> parameter must log management events.</p>
     *         <p>
     *         For <code>UpdateEventDataStore</code>, this exception is thrown if Insights are enabled on the event data
     *         store and the updated advanced event selectors are not compatible with the configured
     *         <code>InsightSelectors</code>. If the <code>InsightSelectors</code> includes an <code>InsightType</code>
     *         of <code>ApiCallRateInsight</code>, the source event data store must log <code>write</code> management
     *         events. If the <code>InsightSelectors</code> includes an <code>InsightType</code> of
     *         <code>ApiErrorRateInsight</code>, the source event data store must log management events.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInsightSelectorsResponse> putInsightSelectors(
            PutInsightSelectorsRequest putInsightSelectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an
     * existing trail or event data store. You also use <code>PutInsightSelectors</code> to turn off Insights event
     * logging, by passing an empty list of Insights types. The valid Insights event types are
     * <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code>.
     * </p>
     * <p>
     * To enable Insights on an event data store, you must specify the ARNs (or ID suffix of the ARNs) for the source
     * event data store (<code>EventDataStore</code>) and the destination event data store (
     * <code>InsightsDestination</code>). The source event data store logs management events and enables Insights. The
     * destination event data store logs Insights events based upon the management event activity of the source event
     * data store. The source and destination event data stores must belong to the same Amazon Web Services account.
     * </p>
     * <p>
     * To log Insights events for a trail, you must specify the name (<code>TrailName</code>) of the CloudTrail trail
     * for which you want to change or add Insights selectors.
     * </p>
     * <p>
     * To log CloudTrail Insights events on API call volume, the trail or event data store must log <code>write</code>
     * management events. To log CloudTrail Insights events on API error rate, the trail or event data store must log
     * <code>read</code> or <code>write</code> management events. You can call <code>GetEventSelectors</code> on a trail
     * to check whether the trail logs management events. You can call <code>GetEventDataStore</code> on an event data
     * store to check whether the event data store logs management events.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Working with CloudTrail Insights</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInsightSelectorsRequest.Builder} avoiding the
     * need to create one manually via {@link PutInsightSelectorsRequest#builder()}
     * </p>
     *
     * @param putInsightSelectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>InvalidInsightSelectorsException For <code>PutInsightSelectors</code>, this exception is thrown when
     *         the formatting or syntax of the <code>InsightSelectors</code> JSON statement is not valid, or the
     *         specified <code>InsightType</code> in the <code>InsightSelectors</code> statement is not valid. Valid
     *         values for <code>InsightType</code> are <code>ApiCallRateInsight</code> and
     *         <code>ApiErrorRateInsight</code>. To enable Insights on an event data store, the destination event data
     *         store specified by the <code>InsightsDestination</code> parameter must log Insights events and the source
     *         event data store specified by the <code>EventDataStore</code> parameter must log management events.</p>
     *         <p>
     *         For <code>UpdateEventDataStore</code>, this exception is thrown if Insights are enabled on the event data
     *         store and the updated advanced event selectors are not compatible with the configured
     *         <code>InsightSelectors</code>. If the <code>InsightSelectors</code> includes an <code>InsightType</code>
     *         of <code>ApiCallRateInsight</code>, the source event data store must log <code>write</code> management
     *         events. If the <code>InsightSelectors</code> includes an <code>InsightType</code> of
     *         <code>ApiErrorRateInsight</code>, the source event data store must log management events.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInsightSelectorsResponse> putInsightSelectors(
            Consumer<PutInsightSelectorsRequest.Builder> putInsightSelectorsRequest) {
        return putInsightSelectors(PutInsightSelectorsRequest.builder().applyMutation(putInsightSelectorsRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based permission policy to a CloudTrail event data store, dashboard, or channel. For more
     * information about resource-based policies, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html"
     * >CloudTrail resource-based policy examples</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceArnNotValidException This exception is thrown when the provided resource does not exist, or
     *         the ARN format of the resource is not valid. </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ResourcePolicyNotValidException This exception is thrown when the resouce-based policy has syntax
     *         errors, or contains a principal that is not valid.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based permission policy to a CloudTrail event data store, dashboard, or channel. For more
     * information about resource-based policies, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html"
     * >CloudTrail resource-based policy examples</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceArnNotValidException This exception is thrown when the provided resource does not exist, or
     *         the ARN format of the resource is not valid. </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ResourcePolicyNotValidException This exception is thrown when the resouce-based policy has syntax
     *         errors, or contains a principal that is not valid.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Registers an organization’s member account as the CloudTrail <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-delegated-administrator.html"
     * >delegated administrator</a>.
     * </p>
     *
     * @param registerOrganizationDelegatedAdminRequest
     *        Specifies an organization member account ID as a CloudTrail delegated administrator.
     * @return A Java Future containing the result of the RegisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccountRegisteredException This exception is thrown when the account is already registered as the
     *         CloudTrail delegated administrator.</li>
     *         <li>AccountNotFoundException This exception is thrown when the specified account is not found or not part
     *         of an organization.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>CannotDelegateManagementAccountException This exception is thrown when the management account of an
     *         organization is registered as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>DelegatedAdminAccountLimitExceededException This exception is thrown when the maximum number of
     *         CloudTrail delegated administrators is reached.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RegisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RegisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterOrganizationDelegatedAdminResponse> registerOrganizationDelegatedAdmin(
            RegisterOrganizationDelegatedAdminRequest registerOrganizationDelegatedAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an organization’s member account as the CloudTrail <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-delegated-administrator.html"
     * >delegated administrator</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterOrganizationDelegatedAdminRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterOrganizationDelegatedAdminRequest#builder()}
     * </p>
     *
     * @param registerOrganizationDelegatedAdminRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminRequest.Builder}
     *        to create a request. Specifies an organization member account ID as a CloudTrail delegated administrator.
     * @return A Java Future containing the result of the RegisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccountRegisteredException This exception is thrown when the account is already registered as the
     *         CloudTrail delegated administrator.</li>
     *         <li>AccountNotFoundException This exception is thrown when the specified account is not found or not part
     *         of an organization.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>CannotDelegateManagementAccountException This exception is thrown when the management account of an
     *         organization is registered as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>DelegatedAdminAccountLimitExceededException This exception is thrown when the maximum number of
     *         CloudTrail delegated administrators is reached.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RegisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RegisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterOrganizationDelegatedAdminResponse> registerOrganizationDelegatedAdmin(
            Consumer<RegisterOrganizationDelegatedAdminRequest.Builder> registerOrganizationDelegatedAdminRequest) {
        return registerOrganizationDelegatedAdmin(RegisterOrganizationDelegatedAdminRequest.builder()
                .applyMutation(registerOrganizationDelegatedAdminRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from a trail, event data store, dashboard, or channel.
     * </p>
     *
     * @param removeTagsRequest
     *        Specifies the tags to remove from a trail, event data store, dashboard, or channel.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from a trail, event data store, dashboard, or channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.RemoveTagsRequest.Builder} to create a request.
     *        Specifies the tags to remove from a trail, event data store, dashboard, or channel.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * Restores a deleted event data store specified by <code>EventDataStore</code>, which accepts an event data store
     * ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring
     * an event data store can take several minutes, depending on the size of the event data store.
     * </p>
     *
     * @param restoreEventDataStoreRequest
     * @return A Java Future containing the result of the RestoreEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RestoreEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RestoreEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreEventDataStoreResponse> restoreEventDataStore(
            RestoreEventDataStoreRequest restoreEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a deleted event data store specified by <code>EventDataStore</code>, which accepts an event data store
     * ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring
     * an event data store can take several minutes, depending on the size of the event data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreEventDataStoreRequest.Builder} avoiding the
     * need to create one manually via {@link RestoreEventDataStoreRequest#builder()}
     * </p>
     *
     * @param restoreEventDataStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestoreEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RestoreEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RestoreEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreEventDataStoreResponse> restoreEventDataStore(
            Consumer<RestoreEventDataStoreRequest.Builder> restoreEventDataStoreRequest) {
        return restoreEventDataStore(RestoreEventDataStoreRequest.builder().applyMutation(restoreEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Searches sample queries and returns a list of sample queries that are sorted by relevance. To search for sample
     * queries, provide a natural language <code>SearchPhrase</code> in English.
     * </p>
     *
     * @param searchSampleQueriesRequest
     * @return A Java Future containing the result of the SearchSampleQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.SearchSampleQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/SearchSampleQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchSampleQueriesResponse> searchSampleQueries(
            SearchSampleQueriesRequest searchSampleQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches sample queries and returns a list of sample queries that are sorted by relevance. To search for sample
     * queries, provide a natural language <code>SearchPhrase</code> in English.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSampleQueriesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchSampleQueriesRequest#builder()}
     * </p>
     *
     * @param searchSampleQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchSampleQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.SearchSampleQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/SearchSampleQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchSampleQueriesResponse> searchSampleQueries(
            Consumer<SearchSampleQueriesRequest.Builder> searchSampleQueriesRequest) {
        return searchSampleQueries(SearchSampleQueriesRequest.builder().applyMutation(searchSampleQueriesRequest).build());
    }

    /**
     * <p>
     * Starts a refresh of the specified dashboard.
     * </p>
     * <p>
     * Each time a dashboard is refreshed, CloudTrail runs queries to populate the dashboard's widgets. CloudTrail must
     * be granted permissions to run the <code>StartQuery</code> operation on your behalf. To provide permissions, run
     * the <code>PutResourcePolicy</code> operation to attach a resource-based policy to each event data store. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard"
     * >Example: Allow CloudTrail to run queries to populate a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param startDashboardRefreshRequest
     * @return A Java Future containing the result of the StartDashboardRefresh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when the quota is exceeded. For information
     *         about CloudTrail quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ct.html#limits_cloudtrail">Service quotas</a> in the
     *         <i>Amazon Web Services General Reference</i>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartDashboardRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartDashboardRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDashboardRefreshResponse> startDashboardRefresh(
            StartDashboardRefreshRequest startDashboardRefreshRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a refresh of the specified dashboard.
     * </p>
     * <p>
     * Each time a dashboard is refreshed, CloudTrail runs queries to populate the dashboard's widgets. CloudTrail must
     * be granted permissions to run the <code>StartQuery</code> operation on your behalf. To provide permissions, run
     * the <code>PutResourcePolicy</code> operation to attach a resource-based policy to each event data store. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard"
     * >Example: Allow CloudTrail to run queries to populate a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDashboardRefreshRequest.Builder} avoiding the
     * need to create one manually via {@link StartDashboardRefreshRequest#builder()}
     * </p>
     *
     * @param startDashboardRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.StartDashboardRefreshRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartDashboardRefresh operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when the quota is exceeded. For information
     *         about CloudTrail quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ct.html#limits_cloudtrail">Service quotas</a> in the
     *         <i>Amazon Web Services General Reference</i>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartDashboardRefresh
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartDashboardRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDashboardRefreshResponse> startDashboardRefresh(
            Consumer<StartDashboardRefreshRequest.Builder> startDashboardRefreshRequest) {
        return startDashboardRefresh(StartDashboardRefreshRequest.builder().applyMutation(startDashboardRefreshRequest).build());
    }

    /**
     * <p>
     * Starts the ingestion of live events on an event data store specified as either an ARN or the ID portion of the
     * ARN. To start ingestion, the event data store <code>Status</code> must be <code>STOPPED_INGESTION</code> and the
     * <code>eventCategory</code> must be <code>Management</code>, <code>Data</code>, <code>NetworkActivity</code>, or
     * <code>ConfigurationItem</code>.
     * </p>
     *
     * @param startEventDataStoreIngestionRequest
     * @return A Java Future containing the result of the StartEventDataStoreIngestion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartEventDataStoreIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartEventDataStoreIngestion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEventDataStoreIngestionResponse> startEventDataStoreIngestion(
            StartEventDataStoreIngestionRequest startEventDataStoreIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the ingestion of live events on an event data store specified as either an ARN or the ID portion of the
     * ARN. To start ingestion, the event data store <code>Status</code> must be <code>STOPPED_INGESTION</code> and the
     * <code>eventCategory</code> must be <code>Management</code>, <code>Data</code>, <code>NetworkActivity</code>, or
     * <code>ConfigurationItem</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEventDataStoreIngestionRequest.Builder}
     * avoiding the need to create one manually via {@link StartEventDataStoreIngestionRequest#builder()}
     * </p>
     *
     * @param startEventDataStoreIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartEventDataStoreIngestion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartEventDataStoreIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartEventDataStoreIngestion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartEventDataStoreIngestionResponse> startEventDataStoreIngestion(
            Consumer<StartEventDataStoreIngestionRequest.Builder> startEventDataStoreIngestionRequest) {
        return startEventDataStoreIngestion(StartEventDataStoreIngestionRequest.builder()
                .applyMutation(startEventDataStoreIngestionRequest).build());
    }

    /**
     * <p>
     * Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default,
     * CloudTrail only imports events contained in the S3 bucket's <code>CloudTrail</code> prefix and the prefixes
     * inside the <code>CloudTrail</code> prefix, and does not check prefixes for other Amazon Web Services services. If
     * you want to import CloudTrail events contained in another prefix, you must include the prefix in the
     * <code>S3LocationUri</code>. For more considerations about importing trail events, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations"
     * >Considerations for copying trail events</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * When you start a new import, the <code>Destinations</code> and <code>ImportSource</code> parameters are required.
     * Before starting a new import, disable any access control lists (ACLs) attached to the source S3 bucket. For more
     * information about disabling ACLs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of
     * objects and disabling ACLs for your bucket</a>.
     * </p>
     * <p>
     * When you retry an import, the <code>ImportID</code> parameter is required.
     * </p>
     * <note>
     * <p>
     * If the destination event data store is for an organization, you must use the management account to import trail
     * events. You cannot use the delegated administrator account for the organization.
     * </p>
     * </note>
     *
     * @param startImportRequest
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccountHasOngoingImportException This exception is thrown when you start a new import and a previous
     *         import is still in progress.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidImportSourceException This exception is thrown when the provided source S3 bucket is not valid
     *         for import.</li>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportResponse> startImport(StartImportRequest startImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default,
     * CloudTrail only imports events contained in the S3 bucket's <code>CloudTrail</code> prefix and the prefixes
     * inside the <code>CloudTrail</code> prefix, and does not check prefixes for other Amazon Web Services services. If
     * you want to import CloudTrail events contained in another prefix, you must include the prefix in the
     * <code>S3LocationUri</code>. For more considerations about importing trail events, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations"
     * >Considerations for copying trail events</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * When you start a new import, the <code>Destinations</code> and <code>ImportSource</code> parameters are required.
     * Before starting a new import, disable any access control lists (ACLs) attached to the source S3 bucket. For more
     * information about disabling ACLs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of
     * objects and disabling ACLs for your bucket</a>.
     * </p>
     * <p>
     * When you retry an import, the <code>ImportID</code> parameter is required.
     * </p>
     * <note>
     * <p>
     * If the destination event data store is for an organization, you must use the management account to import trail
     * events. You cannot use the delegated administrator account for the organization.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportRequest.Builder} avoiding the need to
     * create one manually via {@link StartImportRequest#builder()}
     * </p>
     *
     * @param startImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.StartImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccountHasOngoingImportException This exception is thrown when you start a new import and a previous
     *         import is still in progress.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidImportSourceException This exception is thrown when the provided source S3 bucket is not valid
     *         for import.</li>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportResponse> startImport(Consumer<StartImportRequest.Builder> startImportRequest) {
        return startImport(StartImportRequest.builder().applyMutation(startImportRequest).build());
    }

    /**
     * <p>
     * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is
     * enabled in all Regions, this operation must be called from the Region in which the trail was created. This
     * operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled
     * in all Regions.
     * </p>
     *
     * @param startLoggingRequest
     *        The request to CloudTrail to start logging Amazon Web Services API calls for an account.
     * @return A Java Future containing the result of the StartLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartLoggingResponse> startLogging(StartLoggingRequest startLoggingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is
     * enabled in all Regions, this operation must be called from the Region in which the trail was created. This
     * operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled
     * in all Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLoggingRequest.Builder} avoiding the need to
     * create one manually via {@link StartLoggingRequest#builder()}
     * </p>
     *
     * @param startLoggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.StartLoggingRequest.Builder} to create a request.
     *        The request to CloudTrail to start logging Amazon Web Services API calls for an account.
     * @return A Java Future containing the result of the StartLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartLoggingResponse> startLogging(Consumer<StartLoggingRequest.Builder> startLoggingRequest) {
        return startLogging(StartLoggingRequest.builder().applyMutation(startLoggingRequest).build());
    }

    /**
     * <p>
     * Starts a CloudTrail Lake query. Use the <code>QueryStatement</code> parameter to provide your SQL query, enclosed
     * in single quotation marks. Use the optional <code>DeliveryS3Uri</code> parameter to deliver the query results to
     * an S3 bucket.
     * </p>
     * <p>
     * <code>StartQuery</code> requires you specify either the <code>QueryStatement</code> parameter, or a
     * <code>QueryAlias</code> and any <code>QueryParameters</code>. In the current release, the <code>QueryAlias</code>
     * and <code>QueryParameters</code> parameters are used only for the queries that populate the CloudTrail Lake
     * dashboards.
     * </p>
     *
     * @param startQueryRequest
     * @return A Java Future containing the result of the StartQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatementException The query that was submitted has validation errors, or uses incorrect
     *         syntax or unsupported keywords. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>MaxConcurrentQueriesException You are already running the maximum number of concurrent queries. The
     *         maximum number of concurrent queries is 10. Wait a minute for some queries to finish, and then run the
     *         query again.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartQueryResponse> startQuery(StartQueryRequest startQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a CloudTrail Lake query. Use the <code>QueryStatement</code> parameter to provide your SQL query, enclosed
     * in single quotation marks. Use the optional <code>DeliveryS3Uri</code> parameter to deliver the query results to
     * an S3 bucket.
     * </p>
     * <p>
     * <code>StartQuery</code> requires you specify either the <code>QueryStatement</code> parameter, or a
     * <code>QueryAlias</code> and any <code>QueryParameters</code>. In the current release, the <code>QueryAlias</code>
     * and <code>QueryParameters</code> parameters are used only for the queries that populate the CloudTrail Lake
     * dashboards.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartQueryRequest.Builder} avoiding the need to
     * create one manually via {@link StartQueryRequest#builder()}
     * </p>
     *
     * @param startQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.StartQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatementException The query that was submitted has validation errors, or uses incorrect
     *         syntax or unsupported keywords. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>MaxConcurrentQueriesException You are already running the maximum number of concurrent queries. The
     *         maximum number of concurrent queries is 10. Wait a minute for some queries to finish, and then run the
     *         query again.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartQueryResponse> startQuery(Consumer<StartQueryRequest.Builder> startQueryRequest) {
        return startQuery(StartQueryRequest.builder().applyMutation(startQueryRequest).build());
    }

    /**
     * <p>
     * Stops the ingestion of live events on an event data store specified as either an ARN or the ID portion of the
     * ARN. To stop ingestion, the event data store <code>Status</code> must be <code>ENABLED</code> and the
     * <code>eventCategory</code> must be <code>Management</code>, <code>Data</code>, <code>NetworkActivity</code>, or
     * <code>ConfigurationItem</code>.
     * </p>
     *
     * @param stopEventDataStoreIngestionRequest
     * @return A Java Future containing the result of the StopEventDataStoreIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopEventDataStoreIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopEventDataStoreIngestion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEventDataStoreIngestionResponse> stopEventDataStoreIngestion(
            StopEventDataStoreIngestionRequest stopEventDataStoreIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the ingestion of live events on an event data store specified as either an ARN or the ID portion of the
     * ARN. To stop ingestion, the event data store <code>Status</code> must be <code>ENABLED</code> and the
     * <code>eventCategory</code> must be <code>Management</code>, <code>Data</code>, <code>NetworkActivity</code>, or
     * <code>ConfigurationItem</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEventDataStoreIngestionRequest.Builder}
     * avoiding the need to create one manually via {@link StopEventDataStoreIngestionRequest#builder()}
     * </p>
     *
     * @param stopEventDataStoreIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StopEventDataStoreIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopEventDataStoreIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopEventDataStoreIngestion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopEventDataStoreIngestionResponse> stopEventDataStoreIngestion(
            Consumer<StopEventDataStoreIngestionRequest.Builder> stopEventDataStoreIngestionRequest) {
        return stopEventDataStoreIngestion(StopEventDataStoreIngestionRequest.builder()
                .applyMutation(stopEventDataStoreIngestionRequest).build());
    }

    /**
     * <p>
     * Stops a specified import.
     * </p>
     *
     * @param stopImportRequest
     * @return A Java Future containing the result of the StopImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopImportResponse> stopImport(StopImportRequest stopImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a specified import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopImportRequest.Builder} avoiding the need to
     * create one manually via {@link StopImportRequest#builder()}
     * </p>
     *
     * @param stopImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.StopImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopImportResponse> stopImport(Consumer<StopImportRequest.Builder> stopImportRequest) {
        return stopImport(StopImportRequest.builder().applyMutation(stopImportRequest).build());
    }

    /**
     * <p>
     * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most
     * circumstances, there is no need to use this action. You can update a trail without stopping it first. This action
     * is the only way to stop recording. For a trail enabled in all Regions, this operation must be called from the
     * Region in which the trail was created, or an <code>InvalidHomeRegionException</code> will occur. This operation
     * cannot be called on the shadow trails (replicated trails in other Regions) of a trail enabled in all Regions.
     * </p>
     *
     * @param stopLoggingRequest
     *        Passes the request to CloudTrail to stop logging Amazon Web Services API calls for the specified account.
     * @return A Java Future containing the result of the StopLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopLoggingResponse> stopLogging(StopLoggingRequest stopLoggingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most
     * circumstances, there is no need to use this action. You can update a trail without stopping it first. This action
     * is the only way to stop recording. For a trail enabled in all Regions, this operation must be called from the
     * Region in which the trail was created, or an <code>InvalidHomeRegionException</code> will occur. This operation
     * cannot be called on the shadow trails (replicated trails in other Regions) of a trail enabled in all Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopLoggingRequest.Builder} avoiding the need to
     * create one manually via {@link StopLoggingRequest#builder()}
     * </p>
     *
     * @param stopLoggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.StopLoggingRequest.Builder} to create a request.
     *        Passes the request to CloudTrail to stop logging Amazon Web Services API calls for the specified account.
     * @return A Java Future containing the result of the StopLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopLoggingResponse> stopLogging(Consumer<StopLoggingRequest.Builder> stopLoggingRequest) {
        return stopLogging(StopLoggingRequest.builder().applyMutation(stopLoggingRequest).build());
    }

    /**
     * <p>
     * Updates a channel specified by a required channel ARN or UUID.
     * </p>
     *
     * @param updateChannelRequest
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>ChannelAlreadyExistsException This exception is thrown when the provided channel already exists.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(UpdateChannelRequest updateChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a channel specified by a required channel ARN or UUID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.UpdateChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>ChannelAlreadyExistsException This exception is thrown when the provided channel already exists.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest) {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * <p>
     * Updates the specified dashboard.
     * </p>
     * <p>
     * To set a refresh schedule, CloudTrail must be granted permissions to run the <code>StartDashboardRefresh</code>
     * operation to refresh the dashboard on your behalf. To provide permissions, run the <code>PutResourcePolicy</code>
     * operation to attach a resource-based policy to the dashboard. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards"
     * > Resource-based policy example for a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must
     * be granted permissions to run the <code>StartQuery</code> operation on your behalf. To provide permissions, run
     * the <code>PutResourcePolicy</code> operation to attach a resource-based policy to each event data store. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard"
     * >Example: Allow CloudTrail to run queries to populate a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param updateDashboardRequest
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidQueryStatementException The query that was submitted has validation errors, or uses incorrect
     *         syntax or unsupported keywords. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when the quota is exceeded. For information
     *         about CloudTrail quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ct.html#limits_cloudtrail">Service quotas</a> in the
     *         <i>Amazon Web Services General Reference</i>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardResponse> updateDashboard(UpdateDashboardRequest updateDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified dashboard.
     * </p>
     * <p>
     * To set a refresh schedule, CloudTrail must be granted permissions to run the <code>StartDashboardRefresh</code>
     * operation to refresh the dashboard on your behalf. To provide permissions, run the <code>PutResourcePolicy</code>
     * operation to attach a resource-based policy to the dashboard. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards"
     * > Resource-based policy example for a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must
     * be granted permissions to run the <code>StartQuery</code> operation on your behalf. To provide permissions, run
     * the <code>PutResourcePolicy</code> operation to attach a resource-based policy to each event data store. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard"
     * >Example: Allow CloudTrail to run queries to populate a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDashboardRequest#builder()}
     * </p>
     *
     * @param updateDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.UpdateDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidQueryStatementException The query that was submitted has validation errors, or uses incorrect
     *         syntax or unsupported keywords. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when the quota is exceeded. For information
     *         about CloudTrail quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ct.html#limits_cloudtrail">Service quotas</a> in the
     *         <i>Amazon Web Services General Reference</i>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardResponse> updateDashboard(
            Consumer<UpdateDashboardRequest.Builder> updateDashboardRequest) {
        return updateDashboard(UpdateDashboardRequest.builder().applyMutation(updateDashboardRequest).build());
    }

    /**
     * <p>
     * Updates an event data store. The required <code>EventDataStore</code> value is an ARN or the ID portion of the
     * ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws
     * an error. <code>RetentionPeriod</code> is in days, and valid values are integers between 7 and 3653 if the
     * <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code>, or between 7 and 2557 if
     * <code>BillingMode</code> is set to <code>FIXED_RETENTION_PRICING</code>. By default,
     * <code>TerminationProtection</code> is enabled.
     * </p>
     * <p>
     * For event data stores for CloudTrail events, <code>AdvancedEventSelectors</code> includes or excludes management,
     * data, or network activity events in your event data store. For more information about
     * <code>AdvancedEventSelectors</code>, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html"
     * >AdvancedEventSelectors</a>.
     * </p>
     * <p>
     * For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or
     * non-Amazon Web Services events, <code>AdvancedEventSelectors</code> includes events of that type in your event
     * data store.
     * </p>
     *
     * @param updateEventDataStoreRequest
     * @return A Java Future containing the result of the UpdateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreAlreadyExistsException An event data store with that name already exists.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>InvalidInsightSelectorsException For <code>PutInsightSelectors</code>, this exception is thrown when
     *         the formatting or syntax of the <code>InsightSelectors</code> JSON statement is not valid, or the
     *         specified <code>InsightType</code> in the <code>InsightSelectors</code> statement is not valid. Valid
     *         values for <code>InsightType</code> are <code>ApiCallRateInsight</code> and
     *         <code>ApiErrorRateInsight</code>. To enable Insights on an event data store, the destination event data
     *         store specified by the <code>InsightsDestination</code> parameter must log Insights events and the source
     *         event data store specified by the <code>EventDataStore</code> parameter must log management events.</p>
     *         <p>
     *         For <code>UpdateEventDataStore</code>, this exception is thrown if Insights are enabled on the event data
     *         store and the updated advanced event selectors are not compatible with the configured
     *         <code>InsightSelectors</code>. If the <code>InsightSelectors</code> includes an <code>InsightType</code>
     *         of <code>ApiCallRateInsight</code>, the source event data store must log <code>write</code> management
     *         events. If the <code>InsightSelectors</code> includes an <code>InsightType</code> of
     *         <code>ApiErrorRateInsight</code>, the source event data store must log management events.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventDataStoreResponse> updateEventDataStore(
            UpdateEventDataStoreRequest updateEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an event data store. The required <code>EventDataStore</code> value is an ARN or the ID portion of the
     * ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws
     * an error. <code>RetentionPeriod</code> is in days, and valid values are integers between 7 and 3653 if the
     * <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code>, or between 7 and 2557 if
     * <code>BillingMode</code> is set to <code>FIXED_RETENTION_PRICING</code>. By default,
     * <code>TerminationProtection</code> is enabled.
     * </p>
     * <p>
     * For event data stores for CloudTrail events, <code>AdvancedEventSelectors</code> includes or excludes management,
     * data, or network activity events in your event data store. For more information about
     * <code>AdvancedEventSelectors</code>, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html"
     * >AdvancedEventSelectors</a>.
     * </p>
     * <p>
     * For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or
     * non-Amazon Web Services events, <code>AdvancedEventSelectors</code> includes events of that type in your event
     * data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventDataStoreRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEventDataStoreRequest#builder()}
     * </p>
     *
     * @param updateEventDataStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventDataStoreAlreadyExistsException An event data store with that name already exists.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>InvalidInsightSelectorsException For <code>PutInsightSelectors</code>, this exception is thrown when
     *         the formatting or syntax of the <code>InsightSelectors</code> JSON statement is not valid, or the
     *         specified <code>InsightType</code> in the <code>InsightSelectors</code> statement is not valid. Valid
     *         values for <code>InsightType</code> are <code>ApiCallRateInsight</code> and
     *         <code>ApiErrorRateInsight</code>. To enable Insights on an event data store, the destination event data
     *         store specified by the <code>InsightsDestination</code> parameter must log Insights events and the source
     *         event data store specified by the <code>EventDataStore</code> parameter must log management events.</p>
     *         <p>
     *         For <code>UpdateEventDataStore</code>, this exception is thrown if Insights are enabled on the event data
     *         store and the updated advanced event selectors are not compatible with the configured
     *         <code>InsightSelectors</code>. If the <code>InsightSelectors</code> includes an <code>InsightType</code>
     *         of <code>ApiCallRateInsight</code>, the source event data store must log <code>write</code> management
     *         events. If the <code>InsightSelectors</code> includes an <code>InsightType</code> of
     *         <code>ApiErrorRateInsight</code>, the source event data store must log management events.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventDataStoreResponse> updateEventDataStore(
            Consumer<UpdateEventDataStoreRequest.Builder> updateEventDataStoreRequest) {
        return updateEventDataStore(UpdateEventDataStoreRequest.builder().applyMutation(updateEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail
     * do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery.
     * If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the
     * bucket. <code>UpdateTrail</code> must be called from the Region in which the trail was created; otherwise, an
     * <code>InvalidHomeRegionException</code> is thrown.
     * </p>
     *
     * @param updateTrailRequest
     *        Specifies settings to update for the trail.
     * @return A Java Future containing the result of the UpdateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this Region.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTrailResponse> updateTrail(UpdateTrailRequest updateTrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail
     * do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery.
     * If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the
     * bucket. <code>UpdateTrail</code> must be called from the Region in which the trail was created; otherwise, an
     * <code>InvalidHomeRegionException</code> is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrailRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTrailRequest#builder()}
     * </p>
     *
     * @param updateTrailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtrail.model.UpdateTrailRequest.Builder} to create a request.
     *        Specifies settings to update for the trail.
     * @return A Java Future containing the result of the UpdateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException For the <code>CreateTrail</code>
     *         <code>PutInsightSelectors</code>, <code>UpdateTrail</code>, <code>StartQuery</code>, and
     *         <code>StartImport</code> operations, this exception is thrown when the policy on the S3 bucket or KMS key
     *         does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this Region.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTrailResponse> updateTrail(Consumer<UpdateTrailRequest.Builder> updateTrailRequest) {
        return updateTrail(UpdateTrailRequest.builder().applyMutation(updateTrailRequest).build());
    }

    @Override
    default CloudTrailServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CloudTrailAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudTrailAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudTrailAsyncClient}.
     */
    static CloudTrailAsyncClientBuilder builder() {
        return new DefaultCloudTrailAsyncClientBuilder();
    }
}
