/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInsightSelectorsRequest extends CloudTrailRequest implements
        ToCopyableBuilder<PutInsightSelectorsRequest.Builder, PutInsightSelectorsRequest> {
    private static final SdkField<String> TRAIL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrailName").getter(getter(PutInsightSelectorsRequest::trailName)).setter(setter(Builder::trailName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailName").build()).build();

    private static final SdkField<List<InsightSelector>> INSIGHT_SELECTORS_FIELD = SdkField
            .<List<InsightSelector>> builder(MarshallingType.LIST)
            .memberName("InsightSelectors")
            .getter(getter(PutInsightSelectorsRequest::insightSelectors))
            .setter(setter(Builder::insightSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStore").getter(getter(PutInsightSelectorsRequest::eventDataStore))
            .setter(setter(Builder::eventDataStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()).build();

    private static final SdkField<String> INSIGHTS_DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightsDestination").getter(getter(PutInsightSelectorsRequest::insightsDestination))
            .setter(setter(Builder::insightsDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightsDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_FIELD,
            INSIGHT_SELECTORS_FIELD, EVENT_DATA_STORE_FIELD, INSIGHTS_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trailName;

    private final List<InsightSelector> insightSelectors;

    private final String eventDataStore;

    private final String insightsDestination;

    private PutInsightSelectorsRequest(BuilderImpl builder) {
        super(builder);
        this.trailName = builder.trailName;
        this.insightSelectors = builder.insightSelectors;
        this.eventDataStore = builder.eventDataStore;
        this.insightsDestination = builder.insightsDestination;
    }

    /**
     * <p>
     * The name of the CloudTrail trail for which you want to change or add Insights selectors.
     * </p>
     * <p>
     * You cannot use this parameter with the <code>EventDataStore</code> and <code>InsightsDestination</code>
     * parameters.
     * </p>
     * 
     * @return The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
     *         <p>
     *         You cannot use this parameter with the <code>EventDataStore</code> and <code>InsightsDestination</code>
     *         parameters.
     */
    public final String trailName() {
        return trailName;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsightSelectors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsightSelectors() {
        return insightSelectors != null && !(insightSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON string that contains the Insights types you want to log on a trail or event data store.
     * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
     * </p>
     * <p>
     * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated
     * per minute against a baseline API call volume.
     * </p>
     * <p>
     * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The
     * error is shown if the API call is unsuccessful.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsightSelectors} method.
     * </p>
     * 
     * @return A JSON string that contains the Insights types you want to log on a trail or event data store.
     *         <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.</p>
     *         <p>
     *         The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
     *         aggregated per minute against a baseline API call volume.
     *         </p>
     *         <p>
     *         The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
     *         codes. The error is shown if the API call is unsuccessful.
     */
    public final List<InsightSelector> insightSelectors() {
        return insightSelectors;
    }

    /**
     * <p>
     * The ARN (or ID suffix of the ARN) of the source event data store for which you want to change or add Insights
     * selectors. To enable Insights on an event data store, you must provide both the <code>EventDataStore</code> and
     * <code>InsightsDestination</code> parameters.
     * </p>
     * <p>
     * You cannot use this parameter with the <code>TrailName</code> parameter.
     * </p>
     * 
     * @return The ARN (or ID suffix of the ARN) of the source event data store for which you want to change or add
     *         Insights selectors. To enable Insights on an event data store, you must provide both the
     *         <code>EventDataStore</code> and <code>InsightsDestination</code> parameters.</p>
     *         <p>
     *         You cannot use this parameter with the <code>TrailName</code> parameter.
     */
    public final String eventDataStore() {
        return eventDataStore;
    }

    /**
     * <p>
     * The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events. To enable
     * Insights on an event data store, you must provide both the <code>EventDataStore</code> and
     * <code>InsightsDestination</code> parameters.
     * </p>
     * <p>
     * You cannot use this parameter with the <code>TrailName</code> parameter.
     * </p>
     * 
     * @return The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events. To
     *         enable Insights on an event data store, you must provide both the <code>EventDataStore</code> and
     *         <code>InsightsDestination</code> parameters. </p>
     *         <p>
     *         You cannot use this parameter with the <code>TrailName</code> parameter.
     */
    public final String insightsDestination() {
        return insightsDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trailName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsightSelectors() ? insightSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(insightsDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInsightSelectorsRequest)) {
            return false;
        }
        PutInsightSelectorsRequest other = (PutInsightSelectorsRequest) obj;
        return Objects.equals(trailName(), other.trailName()) && hasInsightSelectors() == other.hasInsightSelectors()
                && Objects.equals(insightSelectors(), other.insightSelectors())
                && Objects.equals(eventDataStore(), other.eventDataStore())
                && Objects.equals(insightsDestination(), other.insightsDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutInsightSelectorsRequest").add("TrailName", trailName())
                .add("InsightSelectors", hasInsightSelectors() ? insightSelectors() : null)
                .add("EventDataStore", eventDataStore()).add("InsightsDestination", insightsDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrailName":
            return Optional.ofNullable(clazz.cast(trailName()));
        case "InsightSelectors":
            return Optional.ofNullable(clazz.cast(insightSelectors()));
        case "EventDataStore":
            return Optional.ofNullable(clazz.cast(eventDataStore()));
        case "InsightsDestination":
            return Optional.ofNullable(clazz.cast(insightsDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrailName", TRAIL_NAME_FIELD);
        map.put("InsightSelectors", INSIGHT_SELECTORS_FIELD);
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        map.put("InsightsDestination", INSIGHTS_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutInsightSelectorsRequest, T> g) {
        return obj -> g.apply((PutInsightSelectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutInsightSelectorsRequest> {
        /**
         * <p>
         * The name of the CloudTrail trail for which you want to change or add Insights selectors.
         * </p>
         * <p>
         * You cannot use this parameter with the <code>EventDataStore</code> and <code>InsightsDestination</code>
         * parameters.
         * </p>
         * 
         * @param trailName
         *        The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
         *        <p>
         *        You cannot use this parameter with the <code>EventDataStore</code> and
         *        <code>InsightsDestination</code> parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailName(String trailName);

        /**
         * <p>
         * A JSON string that contains the Insights types you want to log on a trail or event data store.
         * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         * </p>
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
         * aggregated per minute against a baseline API call volume.
         * </p>
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
         * The error is shown if the API call is unsuccessful.
         * </p>
         * 
         * @param insightSelectors
         *        A JSON string that contains the Insights types you want to log on a trail or event data store.
         *        <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.</p>
         *        <p>
         *        The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
         *        aggregated per minute against a baseline API call volume.
         *        </p>
         *        <p>
         *        The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
         *        codes. The error is shown if the API call is unsuccessful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightSelectors(Collection<InsightSelector> insightSelectors);

        /**
         * <p>
         * A JSON string that contains the Insights types you want to log on a trail or event data store.
         * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         * </p>
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
         * aggregated per minute against a baseline API call volume.
         * </p>
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
         * The error is shown if the API call is unsuccessful.
         * </p>
         * 
         * @param insightSelectors
         *        A JSON string that contains the Insights types you want to log on a trail or event data store.
         *        <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.</p>
         *        <p>
         *        The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
         *        aggregated per minute against a baseline API call volume.
         *        </p>
         *        <p>
         *        The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
         *        codes. The error is shown if the API call is unsuccessful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightSelectors(InsightSelector... insightSelectors);

        /**
         * <p>
         * A JSON string that contains the Insights types you want to log on a trail or event data store.
         * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         * </p>
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are
         * aggregated per minute against a baseline API call volume.
         * </p>
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
         * The error is shown if the API call is unsuccessful.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.InsightSelector.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudtrail.model.InsightSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.InsightSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #insightSelectors(List<InsightSelector>)}.
         * 
         * @param insightSelectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.InsightSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightSelectors(java.util.Collection<InsightSelector>)
         */
        Builder insightSelectors(Consumer<InsightSelector.Builder>... insightSelectors);

        /**
         * <p>
         * The ARN (or ID suffix of the ARN) of the source event data store for which you want to change or add Insights
         * selectors. To enable Insights on an event data store, you must provide both the <code>EventDataStore</code>
         * and <code>InsightsDestination</code> parameters.
         * </p>
         * <p>
         * You cannot use this parameter with the <code>TrailName</code> parameter.
         * </p>
         * 
         * @param eventDataStore
         *        The ARN (or ID suffix of the ARN) of the source event data store for which you want to change or add
         *        Insights selectors. To enable Insights on an event data store, you must provide both the
         *        <code>EventDataStore</code> and <code>InsightsDestination</code> parameters.</p>
         *        <p>
         *        You cannot use this parameter with the <code>TrailName</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStore(String eventDataStore);

        /**
         * <p>
         * The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events. To enable
         * Insights on an event data store, you must provide both the <code>EventDataStore</code> and
         * <code>InsightsDestination</code> parameters.
         * </p>
         * <p>
         * You cannot use this parameter with the <code>TrailName</code> parameter.
         * </p>
         * 
         * @param insightsDestination
         *        The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events. To
         *        enable Insights on an event data store, you must provide both the <code>EventDataStore</code> and
         *        <code>InsightsDestination</code> parameters. </p>
         *        <p>
         *        You cannot use this parameter with the <code>TrailName</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightsDestination(String insightsDestination);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String trailName;

        private List<InsightSelector> insightSelectors = DefaultSdkAutoConstructList.getInstance();

        private String eventDataStore;

        private String insightsDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInsightSelectorsRequest model) {
            super(model);
            trailName(model.trailName);
            insightSelectors(model.insightSelectors);
            eventDataStore(model.eventDataStore);
            insightsDestination(model.insightsDestination);
        }

        public final String getTrailName() {
            return trailName;
        }

        public final void setTrailName(String trailName) {
            this.trailName = trailName;
        }

        @Override
        public final Builder trailName(String trailName) {
            this.trailName = trailName;
            return this;
        }

        public final List<InsightSelector.Builder> getInsightSelectors() {
            List<InsightSelector.Builder> result = InsightSelectorsCopier.copyToBuilder(this.insightSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsightSelectors(Collection<InsightSelector.BuilderImpl> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copyFromBuilder(insightSelectors);
        }

        @Override
        public final Builder insightSelectors(Collection<InsightSelector> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copy(insightSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(InsightSelector... insightSelectors) {
            insightSelectors(Arrays.asList(insightSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(Consumer<InsightSelector.Builder>... insightSelectors) {
            insightSelectors(Stream.of(insightSelectors).map(c -> InsightSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEventDataStore() {
            return eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getInsightsDestination() {
            return insightsDestination;
        }

        public final void setInsightsDestination(String insightsDestination) {
            this.insightsDestination = insightsDestination;
        }

        @Override
        public final Builder insightsDestination(String insightsDestination) {
            this.insightsDestination = insightsDestination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInsightSelectorsRequest build() {
            return new PutInsightSelectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
